/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.touchnfce.utils;

import com.touchcomp.basementor.constants.enums.EnumConstantsModeloDocFiscal;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.touchnfce.Controllers;
import com.touchcomp.touchnfce.Main;
import com.touchcomp.touchnfce.StaticObjects;
import com.touchcomp.touchnfce.controller.Alerts;
import com.touchcomp.touchnfce.controller.dialogs.DialogTable;
import com.touchcomp.touchnfce.model.BandeiraTEF;
import com.touchcomp.touchnfce.model.CondicoesPagamento;
import com.touchcomp.touchnfce.model.NaturezaOperacao;
import com.touchcomp.touchnfce.model.SituacaoPedidos;
import com.touchcomp.touchnfce.modeltemp.NFCeTipoNota;
import com.touchcomp.touchnfce.modeltemp.TempSaldoProdutoByCentroEst;
import com.touchcomp.touchnfce.service.impl.ServiceBandeiraTEF;
import com.touchcomp.touchnfce.service.impl.ServiceNaturezaOperacao;
import com.touchcomp.touchnfce.service.impl.ServiceSituacaoPedidos;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;

public class UtilShowDialogTable {
    public static Short showTipoNotaSelected() {
        DialogTable dialog = UtilShowDialogTable.showSelecionaTipoNota();
        switch (dialog.getStatus()) {
            case 0: {
                NFCeTipoNota tipo = (NFCeTipoNota)dialog.getSelectedItem();
                if (tipo == null) {
                    return null;
                }
                if (ToolMethods.isEquals((Object)tipo.getIdentificador(), (Object)1)) {
                    return (short)1;
                }
                if (ToolMethods.isEquals((Object)tipo.getIdentificador(), (Object)0)) {
                    return (short)0;
                }
                if (!ToolMethods.isEquals((Object)tipo.getIdentificador(), (Object)3)) break;
                return (short)3;
            }
            case 1: {
                Alerts.showAlertError("Primeiro, informe o Tipo de Nota!");
                dialog.closeDialog();
            }
        }
        return (short)0;
    }

    public static NaturezaOperacao getNaturezaOperacao(Short tipoFaturamento) {
        ServiceNaturezaOperacao service = Main.getBean(ServiceNaturezaOperacao.class);
        String codModDoc = EnumConstantsModeloDocFiscal.NFCE_65.getCodigo();
        List<Object> list = new ArrayList();
        if (tipoFaturamento != null) {
            if (ToolMethods.isEquals((Object)1, (Object)tipoFaturamento) || ToolMethods.isEquals((Object)3, (Object)tipoFaturamento)) {
                codModDoc = EnumConstantsModeloDocFiscal.NFE_55.getCodigo();
            }
            list = service.getNaturezaOperacaoByModDocFiscal(codModDoc, StaticObjects.getEmpresa().getIdentificador());
        } else {
            list = service.getAllNuterezaOperacaoDisponivelNFCe(StaticObjects.getEmpresa().getIdentificador());
        }
        if (list.isEmpty()) {
            throw new RuntimeException("Nenhuma Natureza de Opera\u00e7\u00e3o foi encontrada para Modelo Doc. Fiscal " + codModDoc);
        }
        if (list.size() == 1) {
            return (NaturezaOperacao)list.get(0);
        }
        DialogTable d = UtilShowDialogTable.showSelecionaNaturezaOperacao(list);
        switch (d.getStatus()) {
            case 0: {
                return (NaturezaOperacao)d.getSelectedItem();
            }
            case 1: {
                Alerts.showAlertError("Primeiro, informe a Natureza de Opera\u00e7\u00e3o!");
                d.closeDialog();
            }
            case 2: {
                d.closeDialog();
            }
        }
        throw new RuntimeException("Nenhuma Natureza de Opera\u00e7\u00e3o foi selecionada!");
    }

    public static SituacaoPedidos getSituacaoPedido() {
        ServiceSituacaoPedidos service = Main.getBean(ServiceSituacaoPedidos.class);
        List<SituacaoPedidos> list = service.getSituacoesDisponiveis();
        if (list == null || list.isEmpty()) {
            throw new RuntimeException("Nenhuma Situa\u00e7\u00e3o de Pedido disponivel para NFCe foi encontrada!");
        }
        if (list.size() == 1) {
            return list.get(0);
        }
        DialogTable d = UtilShowDialogTable.showSelecionaSituacaoPedido(list);
        switch (d.getStatus()) {
            case 0: {
                return (SituacaoPedidos)d.getSelectedItem();
            }
            case 1: {
                Alerts.showAlertError("Primeiro, informe a Situa\u00e7\u00e3o do Pedido!");
                return UtilShowDialogTable.getSituacaoPedido();
            }
        }
        return null;
    }

    public static BandeiraTEF getBandeiraTEF(Short debitoCredito) {
        ServiceBandeiraTEF service = Main.getBean(ServiceBandeiraTEF.class);
        List<BandeiraTEF> list = service.get(StaticObjects.getEmpresa(), debitoCredito);
        if (list == null || list.isEmpty()) {
            Alerts.showAlertError("Nenhuma Bandeira encontada para esta empresa. Verifique o cadastro do Tipo Pagamento NFe!");
            throw new RuntimeException("Nenhuma Bandeira encontada para esta empresa. Verifique o cadastro do Tipo Pagamento NFe!");
        }
        DialogTable d = UtilShowDialogTable.showBandeiraTEFCartao(list);
        switch (d.getStatus()) {
            case 0: {
                return (BandeiraTEF)d.getSelectedItem();
            }
            case 1: {
                return null;
            }
        }
        return null;
    }

    public static CondicoesPagamento getCondicaoPagamento(List<CondicoesPagamento> list) {
        DialogTable dialog = UtilShowDialogTable.showSelecionaFormaPag(list);
        switch (dialog.getStatus()) {
            case 0: {
                CondicoesPagamento condicao = (CondicoesPagamento)dialog.getSelectedItem();
                if (condicao == null) break;
                return condicao;
            }
            case 1: {
                dialog.closeDialog();
            }
        }
        return null;
    }

    private static DialogTable showSelecionaFormaPag(List<CondicoesPagamento> cond) {
        Comparator<CondicoesPagamento> comparator = new Comparator<CondicoesPagamento>(){

            @Override
            public int compare(CondicoesPagamento o1, CondicoesPagamento o2) {
                String cond1 = o1 != null ? o1.getNome() : "";
                String cond2 = o2 != null ? o2.getNome() : "";
                return cond1.compareTo(cond2);
            }
        };
        Collections.sort(cond, comparator);
        HashMap<String, Object> h = new HashMap<String, Object>();
        h.put("label", "Formas de Pagamento");
        h.put("classe", CondicoesPagamento.class);
        LinkedList<String> fields = new LinkedList<String>();
        fields.add("identificador");
        fields.add("nome");
        h.put("colunas", fields);
        h.put("itens", cond);
        DialogTable dialog = (DialogTable)Main.get().showDialog(Controllers.DIALOG_TABLE, h);
        return dialog;
    }

    private static DialogTable showSelecionaTipoNota() {
        ArrayList<NFCeTipoNota> tipos = new ArrayList<NFCeTipoNota>();
        tipos.add(new NFCeTipoNota((short)0, "NFC-e (Modelo 65)"));
        tipos.add(new NFCeTipoNota((short)1, "NF-e (Modelo 55)"));
        tipos.add(new NFCeTipoNota((short)3, "NF-e Transfer\u00eancia (Modelo 55)"));
        HashMap<String, Object> h = new HashMap<String, Object>();
        h.put("label", "Informe o tipo de nota a ser gerada");
        h.put("classe", NFCeTipoNota.class);
        LinkedList<String> fields = new LinkedList<String>();
        fields.add("identificador");
        fields.add("descricao");
        h.put("colunas", fields);
        h.put("itens", tipos);
        DialogTable dialog = (DialogTable)Main.get().showDialog(Controllers.DIALOG_TABLE, h);
        return dialog;
    }

    private static DialogTable showSelecionaNaturezaOperacao(List<NaturezaOperacao> nuturezas) {
        HashMap<String, Object> h = new HashMap<String, Object>();
        h.put("label", "Informe a Natureza de Opera\u00e7\u00e3o");
        h.put("classe", NaturezaOperacao.class);
        LinkedList<String> fields = new LinkedList<String>();
        fields.add("identificador");
        fields.add("descricao");
        h.put("colunas", fields);
        h.put("itens", nuturezas);
        DialogTable dialog = (DialogTable)Main.get().showDialog(Controllers.DIALOG_TABLE, h);
        return dialog;
    }

    private static DialogTable showSelecionaSituacaoPedido(List<SituacaoPedidos> situacaoPedido) {
        HashMap<String, Object> h = new HashMap<String, Object>();
        h.put("label", "Informe a Situa\u00e7\u00e3o do Pedido");
        h.put("classe", SituacaoPedidos.class);
        LinkedList<String> fields = new LinkedList<String>();
        fields.add("identificador");
        fields.add("descricao");
        h.put("colunas", fields);
        h.put("itens", situacaoPedido);
        DialogTable dialog = (DialogTable)Main.get().showDialog(Controllers.DIALOG_TABLE, h);
        return dialog;
    }

    public static DialogTable showSaldoEstoqueGeralByCentroEstoque(List<TempSaldoProdutoByCentroEst> listSaldo) {
        HashMap<String, Object> h = new HashMap<String, Object>();
        h.put("label", "Saldo Produto por Centro de Estoque");
        h.put("classe", TempSaldoProdutoByCentroEst.class);
        LinkedList<String> fields = new LinkedList<String>();
        fields.add("centroEstoque");
        fields.add("quantidade");
        h.put("colunas", fields);
        h.put("itens", listSaldo);
        DialogTable dialog = (DialogTable)Main.get().showDialog(Controllers.DIALOG_TABLE, h);
        return dialog;
    }

    public static DialogTable showBandeiraTEFCartao(List<BandeiraTEF> listBandeiras) {
        HashMap<String, Object> h = new HashMap<String, Object>();
        h.put("label", "Informe a Bandeira do Cart\u00e3o");
        h.put("classe", BandeiraTEF.class);
        LinkedList<String> fields = new LinkedList<String>();
        fields.add("descricao");
        h.put("colunas", fields);
        h.put("itens", listBandeiras);
        DialogTable dialog = (DialogTable)Main.get().showDialog(Controllers.DIALOG_TABLE, h);
        return dialog;
    }
}

