/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.touchnfce.utils.analisefinanceira;

import com.touchcomp.basementorlogger.TLogger;
import com.touchcomp.touchnfce.StaticObjects;
import com.touchcomp.touchnfce.controller.Alerts;
import com.touchcomp.touchnfce.controller.splash.SplashMain;
import com.touchcomp.touchnfce.model.Cliente;
import com.touchcomp.touchnfce.sinc.receive.SincOthers;
import com.touchcomp.touchvomodel.vo.estatisticascliente.nfce.DTONFCeEstatisticasPessoa;
import javafx.application.Platform;
import javafx.concurrent.WorkerStateEvent;
import javafx.fxml.Initializable;

public class SplashAnaliseFinanceira
extends SplashMain<DTONFCeEstatisticasPessoa>
implements Initializable {
    private Cliente cliente;

    public SplashAnaliseFinanceira(Cliente cliente) {
        this.cliente = cliente;
    }

    @Override
    protected void successTask() {
        this.updateStatus("Realizando consulta. Aguarde");
    }

    @Override
    protected void errorTask(WorkerStateEvent workerStateEvent) {
        Platform.runLater(() -> Alerts.showAlertError("Erro ao realizar consulta:\n\n" + workerStateEvent.getSource().getException().getMessage()));
    }

    @Override
    protected DTONFCeEstatisticasPessoa call() throws Exception {
        try {
            this.updateStatus("Realizando an\u00e1lise financeira. Aguarde alguns instantes..");
            DTONFCeEstatisticasPessoa out = SincOthers.analiseCreditoCliente(this.cliente.getPessoa().getIdentificador(), StaticObjects.getEmpresa().getIdentificador());
            return out;
        }
        catch (Exception ex) {
            TLogger.get(((Object)((Object)this)).getClass()).error((Throwable)ex);
            throw ex;
        }
    }
}

