/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.touchnfce.utils.impressora;

import com.touchcomp.touchnfce.print.impl.PrintComprovanteTransacaoGerencialTEF;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;

public class UtilImpressora {
    public static boolean isImpressoraWorking() {
        PrintService printService = PrintServiceLookup.lookupDefaultPrintService();
        String printerName = printService.getName();
        ProcessBuilder builder = new ProcessBuilder("powershell.exe", "get-wmiobject -class win32_printer | Select-Object Name, PrinterState, PrinterStatus | where {$_.Name -eq '" + printerName + "'}");
        String fullStatus = null;
        builder.redirectErrorStream(true);
        try {
            Process reg = builder.start();
            fullStatus = UtilImpressora.getStringFromInputStream(reg.getInputStream());
            reg.destroy();
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        System.out.print("STATUS IMPRESSORA: " + fullStatus);
        int statusCode = 0;
        int stateCode = 0;
        int indexPrinterStatusCodeStart = fullStatus.length() - 1;
        while (fullStatus.charAt(indexPrinterStatusCodeStart) != ' ') {
            --indexPrinterStatusCodeStart;
        }
        try {
            statusCode = Integer.parseInt(fullStatus.substring(indexPrinterStatusCodeStart).trim());
            stateCode = Integer.parseInt(fullStatus.substring(fullStatus.indexOf(printerName) + printerName.length(), indexPrinterStatusCodeStart).trim());
        }
        catch (Exception e) {
            System.err.println("Failed to parse printer status/state codes!" + e.getMessage());
        }
        String printerStatus = null;
        if (statusCode == 1 || statusCode == 2) {
            printerStatus = statusCode == 1 && stateCode == 1 ? "Printer paused!" : "Printer turned off!";
        } else if (statusCode == 3) {
            if (stateCode == 0) {
                printerStatus = "Printer should work!";
                return true;
            }
            if (stateCode == 144) {
                printerStatus = "Printer not paper!";
            }
        }
        return false;
    }

    private static String getStringFromInputStream(InputStream inputStream) {
        try {
            int length;
            ByteArrayOutputStream result = new ByteArrayOutputStream();
            byte[] buffer = new byte[1024];
            while ((length = inputStream.read(buffer)) != -1) {
                result.write(buffer, 0, length);
            }
            return result.toString();
        }
        catch (IOException ex) {
            Logger.getLogger(PrintComprovanteTransacaoGerencialTEF.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }
}

