/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.touchnfce.utils.pedido;

import com.touchcomp.basementorexceptions.exceptions.impl.decoder.ExceptionDecodeHexString64;
import com.touchcomp.basementorexceptions.exceptions.impl.jasperreports.ExceptionJasperReports;
import com.touchcomp.basementorexceptions.exceptions.impl.reflection.ExceptionReflection;
import com.touchcomp.basementorexceptions.exceptions.impl.webservice.ExceptionWebService;
import com.touchcomp.basementorlogger.TLogger;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.touchnfce.Main;
import com.touchcomp.touchnfce.StaticObjects;
import com.touchcomp.touchnfce.constants.EnumTipoViaPedido;
import com.touchcomp.touchnfce.controller.Alerts;
import com.touchcomp.touchnfce.controller.auxwizardvendas.AuxGetTipoFaturamento;
import com.touchcomp.touchnfce.helpers.preco.tabpromocao.HelperPrecosTabPromocao;
import com.touchcomp.touchnfce.model.BandeiraCartaoNFe;
import com.touchcomp.touchnfce.model.CentroEstoque;
import com.touchcomp.touchnfce.model.Cidade;
import com.touchcomp.touchnfce.model.CondicoesPagamento;
import com.touchcomp.touchnfce.model.DadosRecAgrPedido;
import com.touchcomp.touchnfce.model.EnderecoEntregaPedido;
import com.touchcomp.touchnfce.model.GradeCor;
import com.touchcomp.touchnfce.model.GradeItemPedido;
import com.touchcomp.touchnfce.model.InfPagamentoPedido;
import com.touchcomp.touchnfce.model.ItemPedido;
import com.touchcomp.touchnfce.model.MeioPagamento;
import com.touchcomp.touchnfce.model.ModeloFiscal;
import com.touchcomp.touchnfce.model.NFCeConsumidor;
import com.touchcomp.touchnfce.model.NaturezaOperacao;
import com.touchcomp.touchnfce.model.Pedido;
import com.touchcomp.touchnfce.model.PedidoTitulo;
import com.touchcomp.touchnfce.model.Pessoa;
import com.touchcomp.touchnfce.model.Produto;
import com.touchcomp.touchnfce.model.Representante;
import com.touchcomp.touchnfce.model.SituacaoPedidos;
import com.touchcomp.touchnfce.model.TipoFrete;
import com.touchcomp.touchnfce.model.TipoPagamentoNFe;
import com.touchcomp.touchnfce.model.Transportador;
import com.touchcomp.touchnfce.model.UnidadeFatCliente;
import com.touchcomp.touchnfce.model.UnidadeMedida;
import com.touchcomp.touchnfce.modeltemp.TempPesquisaProduto;
import com.touchcomp.touchnfce.print.impl.PrintPreVenda;
import com.touchcomp.touchnfce.print.impl.PrintPreVendaTermica;
import com.touchcomp.touchnfce.service.impl.ServiceBandeiraCartaoNFe;
import com.touchcomp.touchnfce.service.impl.ServiceCentroEstoque;
import com.touchcomp.touchnfce.service.impl.ServiceCfop;
import com.touchcomp.touchnfce.service.impl.ServiceCidade;
import com.touchcomp.touchnfce.service.impl.ServiceCondicoesPagamento;
import com.touchcomp.touchnfce.service.impl.ServiceGradeCor;
import com.touchcomp.touchnfce.service.impl.ServiceMeioPagamento;
import com.touchcomp.touchnfce.service.impl.ServiceModeloFiscal;
import com.touchcomp.touchnfce.service.impl.ServiceNFCe;
import com.touchcomp.touchnfce.service.impl.ServiceNFCeLoteNotas;
import com.touchcomp.touchnfce.service.impl.ServiceNaturezaOperacao;
import com.touchcomp.touchnfce.service.impl.ServicePedidoEnv;
import com.touchcomp.touchnfce.service.impl.ServicePessoa;
import com.touchcomp.touchnfce.service.impl.ServicePrevImpostosNcm;
import com.touchcomp.touchnfce.service.impl.ServiceProduto;
import com.touchcomp.touchnfce.service.impl.ServiceRepresentante;
import com.touchcomp.touchnfce.service.impl.ServiceSituacaoDocumento;
import com.touchcomp.touchnfce.service.impl.ServiceSituacaoPedidos;
import com.touchcomp.touchnfce.service.impl.ServiceTabelaPrecoBaseProduto;
import com.touchcomp.touchnfce.service.impl.ServiceTipoFrete;
import com.touchcomp.touchnfce.service.impl.ServiceTipoPagamentoNFe;
import com.touchcomp.touchnfce.service.impl.ServiceTransportador;
import com.touchcomp.touchnfce.service.impl.ServiceUnidadeFatCliente;
import com.touchcomp.touchnfce.service.impl.ServiceUnidadeMedida;
import com.touchcomp.touchnfce.sinc.send.SincParamsSend;
import com.touchcomp.touchnfce.sinc.send.impl.SincPedidoPreVenda;
import com.touchcomp.touchnfce.utils.UtilNFCeSerial;
import com.touchcomp.touchnfce.utils.UtilShowDialogTable;
import com.touchcomp.touchvomodel.vo.findpedidoprevenda.DTOFindPedidoPreVenda;
import com.touchcomp.touchvomodel.vo.nfce.DTONFCeConsumidor;
import com.touchcomp.touchvomodel.vo.pedido.nfce.DTOPedidoV9;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.stage.FileChooser;
import javafx.stage.Window;

public class UtilPedido {
    private static final TLogger logger = TLogger.get(UtilPedido.class);
    private static final ServiceNFCe serviceNFCe = Main.getBean(ServiceNFCe.class);
    private static final ServiceNFCeLoteNotas serviceNFCeLoteNotas = Main.getBean(ServiceNFCeLoteNotas.class);
    private static final ServiceSituacaoDocumento serviceSituacaoDocumento = Main.getBean(ServiceSituacaoDocumento.class);
    private static final ServiceRepresentante serviceRepresentante = Main.getBean(ServiceRepresentante.class);
    private static final ServicePrevImpostosNcm servicePrevImpostosNcm = Main.getBean(ServicePrevImpostosNcm.class);
    private static final ServiceCfop serviceCfop = Main.getBean(ServiceCfop.class);
    private static final ServiceNaturezaOperacao serviceNaturezaOperacao = Main.getBean(ServiceNaturezaOperacao.class);
    private static final ServiceTabelaPrecoBaseProduto serviceTabelaPrecoBaseProduto = Main.getBean(ServiceTabelaPrecoBaseProduto.class);
    private static final ServiceUnidadeFatCliente serviceUnidadeFatCliente = Main.getBean(ServiceUnidadeFatCliente.class);
    private static final ServiceCidade serviceCidade = Main.getBean(ServiceCidade.class);
    private static final ServiceTransportador serviceTransportador = Main.getBean(ServiceTransportador.class);
    private static final ServiceTipoFrete serviceTipoFrete = Main.getBean(ServiceTipoFrete.class);
    private static final ServiceSituacaoPedidos serviceSituacaoPedidos = Main.getBean(ServiceSituacaoPedidos.class);
    private static final ServiceCondicoesPagamento serviceCondicaoPagamento = Main.getBean(ServiceCondicoesPagamento.class);
    private static final ServiceBandeiraCartaoNFe serviceBandeiraCartaoNFe = Main.getBean(ServiceBandeiraCartaoNFe.class);
    private static final ServiceMeioPagamento serviceMeioPagamento = Main.getBean(ServiceMeioPagamento.class);
    private static final ServicePessoa servicePessoa = Main.getBean(ServicePessoa.class);
    private static final ServiceTipoPagamentoNFe serviceTipoPagamentoNFe = Main.getBean(ServiceTipoPagamentoNFe.class);
    private static final ServiceCentroEstoque serviceCentroEstoque = Main.getBean(ServiceCentroEstoque.class);
    private static final ServiceGradeCor serviceGradeCor = Main.getBean(ServiceGradeCor.class);
    private static final ServiceModeloFiscal serviceModeloFiscal = Main.getBean(ServiceModeloFiscal.class);
    private static final ServiceProduto serviceProduto = Main.getBean(ServiceProduto.class);
    private static final ServiceUnidadeMedida serviceUnidadeMedida = Main.getBean(ServiceUnidadeMedida.class);

    public static Pedido getNewPedido(UnidadeFatCliente unidadeFatCliente) {
        if (unidadeFatCliente == null) {
            unidadeFatCliente = StaticObjects.getOpcoes().getUnidadeFatCliente();
        }
        NaturezaOperacao nat = UtilShowDialogTable.getNaturezaOperacao(new AuxGetTipoFaturamento().getTipoFaturamento(unidadeFatCliente, StaticObjects.getEmpresa()));
        return UtilPedido.getNewPedido(unidadeFatCliente, nat);
    }

    public static Pedido getNewPedido(UnidadeFatCliente unidadeFatCliente, NaturezaOperacao nat) {
        if (unidadeFatCliente == null) {
            unidadeFatCliente = StaticObjects.getOpcoes().getUnidadeFatCliente();
        }
        Pedido vo = new Pedido();
        vo.setNfceControleCaixa(StaticObjects.getControleCaixa());
        vo.setEmpresa(StaticObjects.getEmpresa());
        vo.setDataEmissao(new Date());
        vo.setDataPrevisaoSaida(new Date());
        vo.setDataPrevisaoFat(new Date());
        vo.setTipoFrete(StaticObjects.getOpcoes().getTipoFrete());
        vo.setSerialForSync(UtilNFCeSerial.getSerial(StaticObjects.getNFCeCaixa()));
        vo.setUsuario(StaticObjects.getUsuario());
        vo.setRepresentante(UtilPedido.getRepresentanteToUser());
        vo.setUnidadeFatCliente(unidadeFatCliente);
        vo.setNaturezaOperacao(nat);
        vo.setSituacaoPedidos(UtilShowDialogTable.getSituacaoPedido());
        if (StaticObjects.getOpcoes().getDestacarDesconto() != null) {
            vo.setDestacarDesconto(StaticObjects.getOpcoes().getDestacarDesconto());
        }
        if (StaticObjects.getOpcoes().getDestacarDespAcessoria() != null) {
            vo.setDestacarDespAcessoria(StaticObjects.getOpcoes().getDestacarDespAcessoria());
        }
        return vo;
    }

    public static ItemPedido getNewItemPedido(Pedido pedido, GradeCor gradeCor, ModeloFiscal modFiscalItem, Double quantidade, Double percComissao, Double valorUnit, Double percDescTrib, Double valorUnitarioMinimo, Double valorUnitarioMaximo) {
        ItemPedido it = new ItemPedido();
        it.setModeloFiscal(modFiscalItem);
        it.setProduto(gradeCor.getProdutoGrade().getProduto());
        it.setPedido(pedido);
        it.setQuantidadeTotal(quantidade);
        it.setPercComissao(percComissao);
        it.setValorUnitario(valorUnit);
        it.setValorMinimo(valorUnitarioMinimo);
        it.setValorMaximo(valorUnitarioMaximo);
        it.setPercDescTrib(percDescTrib);
        it.setUnidadeMedida(gradeCor.getProdutoGrade().getProduto().getUnidadeMedida());
        UtilPedido.getNewGradeItemPedido(it, gradeCor, quantidade);
        return it;
    }

    public static void aplicarDescontoPromocionalPedido(ItemPedido toAdd, Pedido pedido) {
        Double quantidadeTotal = pedido.getItemPedido().stream().filter(i -> ToolMethods.isEquals((Object)toAdd.getProduto(), (Object)i.getProduto())).mapToDouble(i -> i.getQuantidadeTotal()).sum();
        TempPesquisaProduto itemPromocional = new HelperPrecosTabPromocao().getPesqTabPromocao(toAdd.getProduto().getIdentificador(), pedido.getEmpresa(), pedido.getDataEmissao(), quantidadeTotal);
        if (itemPromocional != null) {
            for (ItemPedido it : pedido.getItemPedido()) {
                if (!ToolMethods.isEquals((Object)it.getProduto(), (Object)toAdd.getProduto())) continue;
                if (it.getValorDesconto() != null && it.getValorDescontoPromocional() != null && it.getValorDesconto() - it.getValorDescontoPromocional() >= 0.0) {
                    it.setValorDesconto(it.getValorDesconto() - it.getValorDescontoPromocional());
                }
                it.setValorDescontoPromocional((it.getValorUnitario() - itemPromocional.getValorUnitario()) * it.getQuantidadeTotal());
                it.setValorDesconto(it.getValorDesconto() + it.getValorDescontoPromocional());
                if (it.getValorDesconto() > 0.0) {
                    it.setDescontoItem((short)1);
                    it.setPercDescontoPromocional(it.getValorDescontoPromocional() / (it.getValorUnitario() * it.getQuantidadeTotal()) * 100.0);
                }
                it.setValorMaximo(itemPromocional.getValorMaximo());
                it.setValorMinimo(itemPromocional.getValorMinimo());
                it.setPercComissao(itemPromocional.getPercComissao());
            }
        }
    }

    public static void getNewGradeItemPedido(ItemPedido itemPedido, GradeCor gradeCor, Double quantidade) {
        GradeItemPedido gip = new GradeItemPedido();
        gip.setGradeCor(gradeCor);
        gip.setItemPedido(itemPedido);
        gip.setQuantidade(quantidade);
        itemPedido.getGradeItemPedido().add(gip);
    }

    public static Pedido save(Pedido nova) {
        ServicePedidoEnv service = Main.getBean(ServicePedidoEnv.class);
        Pedido ret = service.merge(nova);
        if (Objects.equals(ret, StaticObjects.getPedidoAberto())) {
            StaticObjects.setPedidoAberto(ret);
        }
        return ret;
    }

    public static Pedido getClonePedidoSincronizado(DTOPedidoV9 dto) {
        Pedido vo = new Pedido();
        vo.setNfceControleCaixa(StaticObjects.getControleCaixa());
        vo.setEmpresa(StaticObjects.getEmpresa());
        vo.setDataEmissao(dto.getDataEmissao());
        vo.setDataPrevisaoSaida(dto.getDataPrevisaoSaida());
        vo.setDataPrevisaoFat(dto.getDataPrevisaoFat());
        vo.setTipoFrete(UtilPedido.getTipoFrete(dto.getTipoFreteIdentificador()));
        vo.setSerialForSync(dto.getSerialForSync());
        vo.setStatusSincERP((short)1);
        vo.setUsuario(StaticObjects.getUsuario());
        vo.setRepresentante(UtilPedido.getRepresentante(dto.getRepresentanteIdentificador()));
        vo.setNaturezaOperacao(UtilPedido.getNaturezaOperacao(dto.getNaturezaOperacaoIdentificador()));
        vo.setSituacaoPedidos(UtilPedido.getSituacaoPedido(dto.getSituacaoPedidoIdentificador()));
        vo.setCondicoesPagamento(UtilPedido.getCondicaoPagamento(dto.getCondicoesPagamentoIdentificador()));
        vo.setDataCadastro(dto.getDataCadastro());
        vo.setDestacarDesconto(dto.getDestacarDesconto());
        vo.setDestacarDespAcessoria(dto.getDestacarDespAcessoria());
        vo.setDestacarFrete(dto.getDestacarFrete());
        vo.setDestacarSeguro(dto.getDestacarSeguro());
        vo.setDiasMediosCondPag(dto.getDiasMediosCondPag());
        vo.setEnderecoEntrega(UtilPedido.getEnderecoEntrega(dto.getEnderecoEntrega()));
        vo.setInfPagamentoPedido(UtilPedido.getInfPagementoPedido(dto.getInfPagamentoPedido(), vo));
        vo.setInformarLocalEntrega(dto.getInformarLocalEntrega());
        vo.setItemPedido(UtilPedido.getItemPedido(dto.getItemPedido(), vo));
        vo.setMeioPagamento(UtilPedido.getMeioPagamento(dto.getMeioPagamentoIdentificador()));
        vo.setNaturezaOperacao(UtilPedido.getNaturezaOperacao(dto.getNaturezaOperacaoIdentificador()));
        vo.setNfCeConsumidor(UtilPedido.getNFCeConsumidor(dto.getNfceConsumidor()));
        vo.setNrPedidoCliente(dto.getNrPedidoCliente());
        vo.setNrTotalItens(dto.getNrTotalItens());
        vo.setObservacao(dto.getObservacao());
        vo.setObservacaoSistema(dto.getObservacaoSistema());
        vo.setObservacaoUsoInterno(dto.getObservacaoUsoInterno());
        vo.setPercComissao(dto.getPercComissao());
        vo.setPercDescFinanceiro(dto.getPercDescFinanceiro());
        vo.setPercDesconto(dto.getPercDesconto());
        vo.setPercDescontoInf(dto.getPercDescontoInf());
        vo.setPercDespAcessoria(dto.getPercDespAcessoria());
        vo.setPercDespAcessoriaInf(dto.getPercDespAcessoriaInf());
        vo.setPercFrete(dto.getPercFrete());
        vo.setPercFreteInf(dto.getPercFreteInf());
        vo.setPercSeguro(dto.getPercSeguro());
        vo.setPercSeguroInf(dto.getPercSeguroInf());
        vo.setPessoaAutorizada(UtilPedido.getPessoaAutorizada(dto.getPessoaAutorizadaIdentificador()));
        vo.setIndicante(UtilPedido.getPessoaIndicante(dto.getIndicanteIdentificador()));
        vo.setQtdeTotalItens(dto.getQtdeTotalItens());
        vo.setTipoConsumidor(dto.getTipoConsumidor());
        vo.setTipoDesconto(dto.getTipoDesconto());
        vo.setTipoDespAcessInf(dto.getTipoDespAcessInf());
        vo.setTipoFreteInf(dto.getTipoFreteInf());
        vo.setTipoSeguroInf(dto.getTipoSeguroInf());
        vo.setTransportador(UtilPedido.getTransportador(dto.getTransportadorIdentificador()));
        vo.setUnidadeFatCliente(UtilPedido.getUnidadeFatCliente(dto.getUnidadeFatClienteIdentificador()));
        vo.setValorDesconto(dto.getValorDesconto());
        vo.setValorDescontoInf(dto.getValorDescontoInf());
        vo.setValorDespAcessoria(dto.getValorDespAcessoria());
        vo.setValorDespAcessoriaInf(dto.getValorDespAcessoriaInf());
        vo.setValorFrete(dto.getValorFrete());
        vo.setValorFreteInf(dto.getValorFreteInf());
        vo.setValorSeguro(dto.getValorSeguro());
        vo.setValorSeguroInf(dto.getValorSeguroInf());
        vo.setValorTotal(dto.getValorTotal());
        vo.setValorTotalDescTrib(dto.getValorTotalDescTrib());
        vo.setValorTotalBrutoDescTrib(dto.getValorTotalBrutoDescTrib());
        vo.setValorTotalBruto(dto.getValorTotalBruto());
        vo.setVlrTotalCusto(dto.getVlrTotalCusto());
        vo.setIdentificadorERP(dto.getIdentificadorERP());
        for (DTOPedidoV9.DTOPedidoReceitaAgronomica r : dto.getReceitasAgronomicas()) {
            DadosRecAgrPedido d = new DadosRecAgrPedido();
            d.setNrReceitaAgro(r.getNrReceita());
            d.setCpfTecnicoReceita(r.getCpfTecnicoAgricola());
            vo.getReceitasAgronomicas().add(d);
        }
        return vo;
    }

    public static Pedido getUltimoPedidoAberto() {
        ServicePedidoEnv service = Main.getBean(ServicePedidoEnv.class);
        return service.getPedidoAbertoNaoSincronizado();
    }

    private static Representante getRepresentanteToUser() {
        if (ToolMethods.isEquals((Object)StaticObjects.getOpcoes().getInformarVendedorVenda(), (Object)1)) {
            return null;
        }
        ServiceRepresentante serviceRep = Main.getBean(ServiceRepresentante.class);
        return serviceRep.getRepresentanteByPessoa(StaticObjects.getUsuario().getPessoa().getIdentificador());
    }

    public static boolean showOpcaoImpressaoPreVenda(Pedido pedido) {
        Alert dialog = new Alert(Alert.AlertType.INFORMATION);
        ButtonType btnSim = new ButtonType("Sim", ButtonBar.ButtonData.OK_DONE);
        ButtonType btnSimTermica = new ButtonType("T\u00e9rmica", ButtonBar.ButtonData.OK_DONE);
        ButtonType btnSalvar = new ButtonType("Salvar", ButtonBar.ButtonData.OK_DONE);
        ButtonType btnNao = new ButtonType("N\u00e3o", ButtonBar.ButtonData.CANCEL_CLOSE);
        dialog.setTitle("Pr\u00e9 Venda");
        dialog.setHeaderText("Deseja imprimir Pr\u00e9 Venda?");
        dialog.getButtonTypes().setAll((Object[])new ButtonType[]{btnSim, btnSimTermica, btnSalvar, btnNao});
        Boolean sucess = true;
        dialog.showAndWait().ifPresent(b -> {
            block15: {
                if (b == btnSim) {
                    try {
                        if (pedido.getUnidadeFatCliente() == null) {
                            Alerts.showAlertInfo("Este pedido n\u00e3o pode ser impresso, pois n\u00e3o possui cliente!");
                        } else {
                            new PrintPreVenda().printPreVenda(pedido);
                        }
                    }
                    catch (ExceptionJasperReports ex) {
                        Logger.getLogger(UtilPedido.class.getName()).log(Level.SEVERE, null, ex);
                        Alerts.showAlertError("Erro ao imprimir Pr\u00e9 Venda: " + ex.getMessage());
                    }
                }
                if (b == btnSimTermica) {
                    try {
                        if (pedido.getUnidadeFatCliente() == null) {
                            Alerts.showAlertInfo("Este pedido n\u00e3o pode ser impresso, pois n\u00e3o possui cliente!");
                        } else {
                            new PrintPreVendaTermica().PrintPreVenda(pedido, EnumTipoViaPedido.VIA_CLIENTE);
                            new PrintPreVendaTermica().PrintPreVenda(pedido, EnumTipoViaPedido.VIA_EMPRESA);
                        }
                    }
                    catch (ExceptionJasperReports ex) {
                        Logger.getLogger(UtilPedido.class.getName()).log(Level.SEVERE, null, ex);
                        Alerts.showAlertError("Erro ao imprimir Pr\u00e9 Venda: " + ex.getMessage());
                    }
                }
                if (b == btnSalvar) {
                    try {
                        if (pedido.getUnidadeFatCliente() == null) {
                            Alerts.showAlertInfo("Este pedido n\u00e3o pode ser salvo, pois n\u00e3o possui cliente!");
                            break block15;
                        }
                        FileChooser fileChooser = new FileChooser();
                        fileChooser.setTitle("Arquivo");
                        File f = fileChooser.showSaveDialog((Window)Main.get().getPrimaryStage());
                        new PrintPreVenda().salvarPreVenda(pedido, f);
                    }
                    catch (ExceptionJasperReports ex) {
                        Logger.getLogger(UtilPedido.class.getName()).log(Level.SEVERE, null, ex);
                        Alerts.showAlertError("Erro ao imprimir/salvar Pr\u00e9 Venda: " + ex.getMessage());
                    }
                } else {
                    dialog.close();
                }
            }
        });
        return sucess;
    }

    public static List<DTOFindPedidoPreVenda> findPedidosSemNotas(String aux) {
        if (StaticObjects.getOpcoes().getSituacaoPedidosCad() != null) {
            try {
                SincParamsSend s = new SincParamsSend(StaticObjects.getDadosSincronizacao(), StaticObjects.getNFCeCaixa());
                return new SincPedidoPreVenda(s).findPedidosPreVenda(aux, StaticObjects.getOpcoes().getSituacaoPedidosCad().getIdentificador(), StaticObjects.getEmpresa().getIdentificador());
            }
            catch (ExceptionReflection ex) {
                ex.printStackTrace();
                logger.error(ex.getMessage(), (Throwable)ex);
                Alerts.showAlertError("Erro ao pesquisar pedido: " + ex.getMessage());
            }
            catch (ExceptionDecodeHexString64 | ExceptionWebService ex) {
                ex.printStackTrace();
                logger.error(ex.getMessage(), ex);
                Alerts.showAlertError("Erro ao pesquisar pedido: " + ex.getMessage());
            }
            catch (Exception ex) {
                ex.printStackTrace();
                logger.error(ex.getMessage(), (Throwable)ex);
                Alerts.showAlertError("Erro ao pesquisar pedido: " + ex.getMessage());
            }
        } else {
            Alerts.showAlertError("Primeiro defina em Op\u00e7oes NFCe qual a situa\u00e7\u00e3o de pedidos cadastrado deseja buscar!");
        }
        return new ArrayList<DTOFindPedidoPreVenda>();
    }

    public static DTOPedidoV9 sicronizaPedidoPreVenda(Long identificador) {
        try {
            SincParamsSend s = new SincParamsSend(StaticObjects.getDadosSincronizacao(), StaticObjects.getNFCeCaixa());
            return new SincPedidoPreVenda(s).sincronizaPedidoERPToNFCe(identificador);
        }
        catch (ExceptionReflection ex) {
            ex.printStackTrace();
            logger.error(ex.getMessage(), (Throwable)ex);
            Alerts.showAlertError("Erro ao sincronizar pedido: " + ex.getMessage());
        }
        catch (ExceptionDecodeHexString64 | ExceptionWebService ex) {
            ex.printStackTrace();
            logger.error(ex.getMessage(), ex);
            Alerts.showAlertError("Erro ao sincronizar pedido: " + ex.getMessage());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            logger.error(ex.getMessage(), (Throwable)ex);
            Alerts.showAlertError("Erro ao sincronizar pedido: " + ex.getMessage());
        }
        return null;
    }

    public static void atualizaSituacaoPedido(Long idPedidoERP, Long idSituacaoPedido) {
        try {
            SincParamsSend s = new SincParamsSend(StaticObjects.getDadosSincronizacao(), StaticObjects.getNFCeCaixa());
            new SincPedidoPreVenda(s).atualizaSituacaoPedidoById(idPedidoERP, idSituacaoPedido);
        }
        catch (ExceptionReflection ex) {
            ex.printStackTrace();
            logger.error(ex.getMessage(), (Throwable)ex);
            Alerts.showAlertError("Erro ao atualizar situa\u00e7\u00e3o do pedido: " + ex.getMessage());
        }
        catch (ExceptionDecodeHexString64 | ExceptionWebService ex) {
            ex.printStackTrace();
            logger.error(ex.getMessage(), ex);
            Alerts.showAlertError("Erro ao atualizar situa\u00e7\u00e3o do pedido: " + ex.getMessage());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            logger.error(ex.getMessage(), (Throwable)ex);
            Alerts.showAlertError("Erro ao atualizar situa\u00e7\u00e3o do pedido: " + ex.getMessage());
        }
    }

    private static TipoFrete getTipoFrete(Long tipoFreteIdentificador) {
        if (tipoFreteIdentificador == null) {
            return null;
        }
        return (TipoFrete)serviceTipoFrete.get(tipoFreteIdentificador);
    }

    private static Representante getRepresentante(Long representanteIdentificador) {
        if (representanteIdentificador == null) {
            return null;
        }
        return (Representante)serviceRepresentante.get(representanteIdentificador);
    }

    private static NaturezaOperacao getNaturezaOperacao(Long naturezaOperacaoIdentificador) {
        if (naturezaOperacaoIdentificador == null) {
            return null;
        }
        return (NaturezaOperacao)serviceNaturezaOperacao.get(naturezaOperacaoIdentificador);
    }

    private static SituacaoPedidos getSituacaoPedido(Long situacaoPedidoIdentificador) {
        if (situacaoPedidoIdentificador == null) {
            return null;
        }
        return (SituacaoPedidos)serviceSituacaoPedidos.get(situacaoPedidoIdentificador);
    }

    private static CondicoesPagamento getCondicaoPagamento(Long condicoesPagamentoIdentificador) {
        if (condicoesPagamentoIdentificador == null) {
            return null;
        }
        return (CondicoesPagamento)serviceCondicaoPagamento.get(condicoesPagamentoIdentificador);
    }

    private static EnderecoEntregaPedido getEnderecoEntrega(DTOPedidoV9.DTOPedidoEndereco enderecoEntrega) {
        if (enderecoEntrega == null || enderecoEntrega.getCidadeIdentificador() == null) {
            return null;
        }
        EnderecoEntregaPedido vo = new EnderecoEntregaPedido();
        vo.setBairro(enderecoEntrega.getBairro());
        vo.setCep(enderecoEntrega.getCep());
        vo.setCidade(UtilPedido.getCidade(enderecoEntrega.getCidadeIdentificador()));
        vo.setComplemento(enderecoEntrega.getComplemento());
        vo.setCpfCnpj(enderecoEntrega.getCpfCnpj());
        vo.setLogradouro(enderecoEntrega.getLogradouro());
        vo.setNomePessoaResp(enderecoEntrega.getNomePessoaResp());
        vo.setNumero(enderecoEntrega.getNumero());
        vo.setObservacao(enderecoEntrega.getObservacao());
        vo.setReferencia(enderecoEntrega.getReferencia());
        return vo;
    }

    private static Cidade getCidade(Long cidadeIdentificador) {
        if (cidadeIdentificador == null) {
            return null;
        }
        return (Cidade)serviceCidade.get(cidadeIdentificador);
    }

    private static List<InfPagamentoPedido> getInfPagementoPedido(List<DTOPedidoV9.DTOInfPagamentoPedido> infPagamentoPedido, Pedido vo) {
        if (infPagamentoPedido == null || infPagamentoPedido.isEmpty()) {
            return new ArrayList<InfPagamentoPedido>();
        }
        ArrayList<InfPagamentoPedido> list = new ArrayList<InfPagamentoPedido>();
        for (DTOPedidoV9.DTOInfPagamentoPedido dto : infPagamentoPedido) {
            InfPagamentoPedido i = new InfPagamentoPedido();
            i.setPedido(vo);
            i.setBandeiraCartaoNFe(UtilPedido.getBandeiraCartaoNFe(dto.getBandeiraCartaoNFeIdentificador()));
            i.setCondicoesPagamento(UtilPedido.getCondicaoPagamento(dto.getCondicoesPagamentoIdentificador()));
            i.setCredenciadoraCreditoDebito(UtilPedido.getCredenciadoraCartaoCredito(dto.getCredenciadoraCreditoDebitoIdentificador()));
            i.setMeioPagamento(UtilPedido.getMeioPagamento(dto.getMeioPagamentoIdentificador()));
            i.setNrAutorizacao(dto.getNrAutorizacao());
            i.setTipoIntegracao(dto.getTipoIntegracao());
            i.setTipoPagamentoNFe(UtilPedido.getTipoPagamentoNFe(dto.getTipoPagamentoNFeIdentificador()));
            i.setTitulos(UtilPedido.getPedidoTitulo(dto.getTitulos(), i));
            i.setValor(dto.getValor());
            i.setValorLiquido(dto.getValorLiquido());
            i.setValorTroco(dto.getValorTroco());
            list.add(i);
        }
        return list;
    }

    private static BandeiraCartaoNFe getBandeiraCartaoNFe(Long bandeiraCartaoNFeIdentificador) {
        if (bandeiraCartaoNFeIdentificador == null) {
            return null;
        }
        return (BandeiraCartaoNFe)serviceBandeiraCartaoNFe.get(bandeiraCartaoNFeIdentificador);
    }

    private static Pessoa getCredenciadoraCartaoCredito(Long credenciadoraCreditoDebitoIdentificador) {
        if (credenciadoraCreditoDebitoIdentificador == null) {
            return null;
        }
        return (Pessoa)servicePessoa.get(credenciadoraCreditoDebitoIdentificador);
    }

    private static MeioPagamento getMeioPagamento(Long meioPagamentoIdentificador) {
        if (meioPagamentoIdentificador == null) {
            return null;
        }
        return (MeioPagamento)serviceMeioPagamento.get(meioPagamentoIdentificador);
    }

    private static TipoPagamentoNFe getTipoPagamentoNFe(Long tipoPagamentoNFeIdentificador) {
        if (tipoPagamentoNFeIdentificador == null) {
            return null;
        }
        return (TipoPagamentoNFe)serviceTipoPagamentoNFe.get(tipoPagamentoNFeIdentificador);
    }

    private static List<PedidoTitulo> getPedidoTitulo(List<DTOPedidoV9.DTOPedidoTitulo> titulos, InfPagamentoPedido i) {
        if (titulos == null || titulos.isEmpty()) {
            return new ArrayList<PedidoTitulo>();
        }
        ArrayList<PedidoTitulo> aux = new ArrayList<PedidoTitulo>();
        short nrParcela = 1;
        for (DTOPedidoV9.DTOPedidoTitulo t : titulos) {
            PedidoTitulo vo = new PedidoTitulo();
            vo.setDataCadastro(t.getDataCadastro());
            vo.setDataVencimento(t.getDataVencimento());
            vo.setInfPagamentoPedido(i);
            vo.setNumeroParcela(nrParcela);
            vo.setValor(t.getValor());
            aux.add(vo);
            nrParcela = (short)(nrParcela + 1);
        }
        return aux;
    }

    private static List<ItemPedido> getItemPedido(List<DTOPedidoV9.DTOItemPedido> itemPedido, Pedido vo) {
        if (itemPedido == null || itemPedido.isEmpty()) {
            return new ArrayList<ItemPedido>();
        }
        ArrayList<ItemPedido> aux = new ArrayList<ItemPedido>();
        for (DTOPedidoV9.DTOItemPedido dto : itemPedido) {
            ItemPedido i = new ItemPedido();
            i.setCentroEstoque(UtilPedido.getCentroEstoque(dto.getCentroEstoqueIdentificador()));
            i.setDescontoItem(dto.getDescontoItem());
            i.setDespAcessItem(dto.getDespAcessItem());
            i.setFatorConversao(dto.getFatorConversao());
            i.setFreteItem(dto.getFreteItem());
            i.setGradeItemPedido(UtilPedido.getGradeItemPedido(dto.getGradeItemPedido(), i));
            i.setInfoAdicionalItem(dto.getInfoAdicionalItem());
            i.setInfoAdicionalItemAux(dto.getInfoAdicionalItemAux());
            i.setModeloFiscal(UtilPedido.getModeloFiscal(dto.getModeloFiscalIdentificador()));
            if (ToolMethods.isStrWithData((String)dto.getNrItemPedido())) {
                i.setNrItemPedido(Long.valueOf(dto.getNrItemPedido()));
            }
            i.setNrPedido(dto.getNrPedido());
            i.setNrSequencial(dto.getNrSequencial());
            i.setPedido(vo);
            i.setPercComissao(dto.getPercComissao());
            i.setPercDesconto(dto.getPercDesconto());
            i.setPercDespesaAcessoria(dto.getPercDespesaAcessoria());
            i.setPercFrete(dto.getPercFrete());
            i.setPercSeguro(dto.getPercSeguro());
            i.setPercDescTrib(dto.getPercDescTrib());
            i.setProduto(UtilPedido.getProduto(dto.getProdutoIdentificador()));
            i.setQuantidadeTotal(dto.getQuantidadeTotal());
            i.setSeguroItem(dto.getSeguroItem());
            i.setTipoDesconto(dto.getTipoDesconto());
            i.setTipoDespAcessoria(dto.getTipoDespAcessoria());
            i.setTipoFrete(dto.getTipoFrete());
            i.setTipoSeguro(dto.getTipoSeguro());
            i.setTipoTabPreco(dto.getTipoTabPreco());
            i.setUnidadeMedida(UtilPedido.getUnidadeMedida(dto.getUnidadeMedidaIdentificador()));
            i.setValorCusto(dto.getValorCusto());
            i.setValorDesconto(dto.getValorDesconto());
            i.setValorDespesaAcessoria(dto.getValorDespesaAcessoria());
            i.setValorFrete(dto.getValorFrete());
            i.setValorMaximo(dto.getValorMaximo());
            i.setValorMinimo(dto.getValorMinimo());
            i.setValorSeguro(dto.getValorSeguro());
            i.setValorSugerido(dto.getValorSugerido());
            i.setValorTotal(dto.getValorTotal());
            i.setValorTotalDescTrib(dto.getValorTotalDescTrib());
            i.setValorTotalBruto(dto.getValorTotalBruto());
            i.setValorTotalBrutoDescTrib(dto.getValorTotalBrutoDescTrib());
            i.setValorUnitario(dto.getValorUnitario());
            i.setValorUnitarioDescTrib(dto.getValorUnitarioDescTrib());
            i.setNrLoteFabricacao(dto.getNrLoteFabricacao());
            i.setDataFabricacao(dto.getDataFabricacao());
            i.setDataValidade(dto.getDataValidade());
            aux.add(i);
        }
        return aux;
    }

    private static CentroEstoque getCentroEstoque(Long centroEstoqueIdentificador) {
        if (centroEstoqueIdentificador == null) {
            return null;
        }
        return (CentroEstoque)serviceCentroEstoque.get(centroEstoqueIdentificador);
    }

    private static List<GradeItemPedido> getGradeItemPedido(List<DTOPedidoV9.DTOGradeItemPedido> gradeItemPedido, ItemPedido i) {
        if (gradeItemPedido == null || gradeItemPedido.isEmpty()) {
            return new ArrayList<GradeItemPedido>();
        }
        ArrayList<GradeItemPedido> aux = new ArrayList<GradeItemPedido>();
        for (DTOPedidoV9.DTOGradeItemPedido dto : gradeItemPedido) {
            GradeItemPedido vo = new GradeItemPedido();
            vo.setGradeCor(UtilPedido.getGradeCor(dto.getGradeCorIdentificador()));
            vo.setItemPedido(i);
            vo.setQuantidade(dto.getQuantidade());
            aux.add(vo);
        }
        return aux;
    }

    private static GradeCor getGradeCor(Long gradeCorIdentificador) {
        if (gradeCorIdentificador == null) {
            return null;
        }
        return (GradeCor)serviceGradeCor.get(gradeCorIdentificador);
    }

    private static ModeloFiscal getModeloFiscal(Long modeloFiscalIdentificador) {
        if (modeloFiscalIdentificador == null) {
            return null;
        }
        return (ModeloFiscal)serviceModeloFiscal.get(modeloFiscalIdentificador);
    }

    private static Produto getProduto(Long produtoIdentificador) {
        if (produtoIdentificador == null) {
            return null;
        }
        return (Produto)serviceProduto.get(produtoIdentificador);
    }

    private static UnidadeMedida getUnidadeMedida(Long unidadeMedidaIdentificador) {
        if (unidadeMedidaIdentificador == null) {
            return null;
        }
        return (UnidadeMedida)serviceUnidadeMedida.get(unidadeMedidaIdentificador);
    }

    private static NFCeConsumidor getNFCeConsumidor(DTONFCeConsumidor nfceConsumidor) {
        if (nfceConsumidor == null || nfceConsumidor.getCpfCnpj() == null) {
            return null;
        }
        NFCeConsumidor vo = new NFCeConsumidor();
        vo.setCpfCnpj(nfceConsumidor.getCpfCnpj());
        vo.setEmail(nfceConsumidor.getEmail());
        vo.setNome(nfceConsumidor.getNome());
        vo.setPassaporte(nfceConsumidor.getPassaporte());
        return vo;
    }

    private static Pessoa getPessoaAutorizada(Long pessoaAutorizadaIdentificador) {
        if (pessoaAutorizadaIdentificador == null) {
            return null;
        }
        return (Pessoa)servicePessoa.get(pessoaAutorizadaIdentificador);
    }

    private static Transportador getTransportador(Long transportadorIdentificador) {
        if (transportadorIdentificador == null) {
            return null;
        }
        return (Transportador)serviceTransportador.get(transportadorIdentificador);
    }

    private static UnidadeFatCliente getUnidadeFatCliente(Long unidadeFatClienteIdentificador) {
        if (unidadeFatClienteIdentificador == null) {
            return null;
        }
        return (UnidadeFatCliente)serviceUnidadeFatCliente.get(unidadeFatClienteIdentificador);
    }

    private static Pessoa getPessoaIndicante(Long pessoaIndicanteIdentificador) {
        if (pessoaIndicanteIdentificador == null) {
            return null;
        }
        return (Pessoa)servicePessoa.get(pessoaIndicanteIdentificador);
    }

    public static boolean showOpcaoImpressaoPreVendaTermica(Pedido pedido) {
        Boolean sucess = true;
        try {
            if (pedido.getUnidadeFatCliente() == null) {
                Alerts.showAlertInfo("Este pedido n\u00e3o pode ser impresso, pois n\u00e3o possui cliente!");
            } else {
                new PrintPreVendaTermica().PrintPreVenda(pedido, EnumTipoViaPedido.VIA_CLIENTE);
                new PrintPreVendaTermica().PrintPreVenda(pedido, EnumTipoViaPedido.VIA_EMPRESA);
            }
        }
        catch (ExceptionJasperReports ex) {
            Logger.getLogger(UtilPedido.class.getName()).log(Level.SEVERE, null, ex);
            Alerts.showAlertError("Erro ao imprimir Pr\u00e9 Venda: " + ex.getMessage());
        }
        return sucess;
    }
}

