/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.touchnfce.utils.pedido;

import com.touchcomp.basementor.constants.enums.EnumConstPercentualValor;
import com.touchcomp.basementortools.tools.formatter.ToolFormatter;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.touchnfce.StaticObjects;
import com.touchcomp.touchnfce.model.InfPagamentoPedido;
import com.touchcomp.touchnfce.model.ItemPedido;
import com.touchcomp.touchnfce.model.Pedido;
import com.touchcomp.touchnfce.utils.pedido.UtilPedidoCalculosDesc;
import com.touchcomp.touchnfce.utils.pedido.UtilPedidoCalculosDespAcess;
import com.touchcomp.touchnfce.utils.pedido.UtilPedidoCalculosFrete;
import com.touchcomp.touchnfce.utils.pedido.UtilPedidoCalculosSeguro;
import java.util.List;

public class UtilPedidoCalculos {
    public static void calcularValores(Pedido pedido) throws Exception {
        UtilPedidoCalculos.calcularValorProduto(pedido);
        UtilPedidoCalculos.calcularValoresAcessoriosItens(pedido.getItemPedido());
        UtilPedidoCalculos.ratearValoresAcessoriosPedido(pedido);
        UtilPedidoCalculos.calculartTotaisItens(pedido);
        UtilPedidoCalculos.calcularValoresAcessoriosPedido(pedido);
        UtilPedidoCalculos.calcularTotalizadores(pedido);
        UtilPedidoCalculos.recalcularVrTroco(pedido);
        UtilPedidoCalculos.setNrItemPedidoAndNrSequencial(pedido);
    }

    private static void ratearValoresAcessoriosPedido(Pedido pedido) throws Exception {
        List<ItemPedido> itens = pedido.getItemPedido();
        if (itens == null || itens.isEmpty()) {
            return;
        }
        UtilPedidoCalculos.ratearDesconto(pedido);
        UtilPedidoCalculos.ratearDespAcess(pedido);
        UtilPedidoCalculos.ratearFrete(pedido);
        UtilPedidoCalculos.ratearSeguro(pedido);
    }

    private static void recalcularVrTroco(Pedido pedido) {
        for (InfPagamentoPedido inf : pedido.getInfPagamentoPedido()) {
            inf.setValorTroco(inf.getValor() - inf.getValorLiquido());
        }
    }

    private static void calcularValorProduto(Pedido pedido) {
        for (ItemPedido item : pedido.getItemPedido()) {
            item.setValorTotalBruto(UtilPedidoCalculos.arredondarNumero(item.getQuantidadeTotal() * item.getValorUnitario()));
            if (ToolMethods.isWithData((Number)item.getPercDescTrib())) {
                item.setValorUnitarioDescTrib(item.getValorUnitario() - item.getValorUnitario() * item.getPercDescTrib() / 100.0);
            } else {
                item.setValorUnitarioDescTrib(item.getValorUnitario());
            }
            item.setValorTotalBrutoDescTrib(UtilPedidoCalculos.arredondarNumero(item.getQuantidadeTotal() * item.getValorUnitarioDescTrib()));
        }
    }

    private static void calculartTotaisItens(Pedido pedido) {
        for (ItemPedido item : pedido.getItemPedido()) {
            Double valorTotal = item.getValorTotalBruto() - item.getValorDesconto() + item.getValorFrete() + item.getValorSeguro() + item.getValorDespesaAcessoria();
            item.setValorTotal(UtilPedidoCalculos.arredondarNumero(valorTotal));
            Double valorTotalDescTrib = item.getValorTotalBrutoDescTrib() - item.getValorDesconto() + item.getValorFrete() + item.getValorSeguro() + item.getValorDespesaAcessoria();
            item.setValorTotalDescTrib(UtilPedidoCalculos.arredondarNumero(valorTotalDescTrib));
        }
    }

    private static Double arredondarNumero(double valor) {
        return ToolFormatter.arrredondarNumero((Double)valor, (int)2);
    }

    public static void calcularValoresAcessoriosItens(List<ItemPedido> itensPedido) {
        itensPedido.forEach(item -> {
            item.setValorTotalBruto(UtilPedidoCalculos.arredondarNumero(item.getQuantidadeTotal() * item.getValorUnitario()));
            if (item.getTipoDespAcessoria().shortValue() == EnumConstPercentualValor.PERCENTUAL.getValue()) {
                item.setValorDespesaAcessoria(UtilPedidoCalculos.arredondarNumero(item.getValorTotalBruto() * item.getPercDespesaAcessoria() / 100.0));
            } else {
                item.setPercDespesaAcessoria(UtilPedidoCalculos.arredondarNumero(item.getValorDespesaAcessoria() / item.getValorTotalBruto() * 100.0));
            }
            if (item.getTipoSeguro().shortValue() == EnumConstPercentualValor.PERCENTUAL.getValue()) {
                item.setValorSeguro(UtilPedidoCalculos.arredondarNumero(item.getValorTotalBruto() * item.getPercSeguro() / 100.0));
            } else {
                item.setPercSeguro(UtilPedidoCalculos.arredondarNumero(item.getValorSeguro() / item.getValorTotalBruto() * 100.0));
            }
            if (item.getTipoFrete().shortValue() == EnumConstPercentualValor.PERCENTUAL.getValue()) {
                item.setValorFrete(UtilPedidoCalculos.arredondarNumero(item.getValorTotalBruto() * item.getPercFrete() / 100.0));
            } else {
                item.setPercFrete(UtilPedidoCalculos.arredondarNumero(item.getValorFrete() / item.getValorTotalBruto() * 100.0));
            }
            if (item.getTipoDesconto().shortValue() == EnumConstPercentualValor.PERCENTUAL.getValue()) {
                item.setValorDesconto(UtilPedidoCalculos.arredondarNumero(item.getValorTotalBruto() * item.getPercDesconto() / 100.0));
            } else {
                item.setPercDesconto(UtilPedidoCalculos.arredondarNumero(item.getValorDesconto() / item.getValorTotalBruto() * 100.0));
            }
        });
    }

    private static void calcularValoresAcessoriosPedido(Pedido pedido) {
        Double totalVlrBruto = 0.0;
        Double total = 0.0;
        for (ItemPedido iten : pedido.getItemPedido()) {
            totalVlrBruto = totalVlrBruto + iten.getValorTotalBruto();
            total = total + iten.getValorTotal();
        }
        pedido.setValorTotal(UtilPedidoCalculos.arredondarNumero(total));
        pedido.setValorTotalBruto(UtilPedidoCalculos.arredondarNumero(totalVlrBruto));
        if (pedido.getTipoDespAcessInf().shortValue() == EnumConstPercentualValor.PERCENTUAL.getValue()) {
            pedido.setValorDespAcessoriaInf(UtilPedidoCalculos.arredondarNumero(pedido.getValorTotalBruto() * pedido.getPercDespAcessoriaInf() / 100.0));
        } else {
            pedido.setPercDespAcessoriaInf(UtilPedidoCalculos.arredondarNumero(pedido.getValorDespAcessoriaInf() / pedido.getValorTotalBruto() * 100.0));
        }
        if (pedido.getTipoDesconto().shortValue() == EnumConstPercentualValor.PERCENTUAL.getValue()) {
            pedido.setValorDescontoInf(UtilPedidoCalculos.arredondarNumero(pedido.getValorTotalBruto() * pedido.getPercDescontoInf() / 100.0));
        } else {
            pedido.setPercDescontoInf(UtilPedidoCalculos.arredondarNumero(pedido.getValorDescontoInf() / pedido.getValorTotalBruto() * 100.0));
        }
        if (pedido.getTipoFreteInf().shortValue() == EnumConstPercentualValor.PERCENTUAL.getValue()) {
            pedido.setValorFreteInf(UtilPedidoCalculos.arredondarNumero(pedido.getValorTotalBruto() * pedido.getPercFreteInf() / 100.0));
        } else {
            pedido.setPercFreteInf(UtilPedidoCalculos.arredondarNumero(pedido.getValorFreteInf() / pedido.getValorTotalBruto() * 100.0));
        }
        if (pedido.getTipoSeguroInf().shortValue() == EnumConstPercentualValor.PERCENTUAL.getValue()) {
            pedido.setValorSeguroInf(UtilPedidoCalculos.arredondarNumero(pedido.getValorTotalBruto() * pedido.getPercSeguroInf() / 100.0));
        } else {
            pedido.setPercSeguroInf(UtilPedidoCalculos.arredondarNumero(pedido.getValorSeguroInf() / pedido.getValorTotalBruto() * 100.0));
        }
    }

    private static void ratearDesconto(Pedido ped) throws Exception {
        new UtilPedidoCalculosDesc().ratearDesconto(ped, StaticObjects.getOpcoes().getNaoPermitirDescontoAcimaTabela());
    }

    private static void ratearFrete(Pedido ped) throws Exception {
        new UtilPedidoCalculosFrete().ratearFrete(ped);
    }

    private static void ratearDespAcess(Pedido ped) throws Exception {
        new UtilPedidoCalculosDespAcess().ratearDespAcessoria(ped);
    }

    private static void ratearSeguro(Pedido ped) throws Exception {
        new UtilPedidoCalculosSeguro().ratearSeguro(ped);
    }

    public static void calcularTotalizadores(Pedido ped) {
        List<ItemPedido> its = ped.getItemPedido();
        Double valorTotalBruto = 0.0;
        Double valorTotalBrutoDescTrib = 0.0;
        Double valorTotal = 0.0;
        Double valorTotalDescTrib = 0.0;
        Double valorDesconto = 0.0;
        Double valorDescontoInf = 0.0;
        Double valorBrutoDescontoInf = 0.0;
        Double valorDesp = 0.0;
        Double valorDespInf = 0.0;
        Double valorBrutoDespInf = 0.0;
        Double valorSeguro = 0.0;
        Double valorSeguroInf = 0.0;
        Double valorBrutoSeguroInf = 0.0;
        Double valorFrete = 0.0;
        Double valorFreteInf = 0.0;
        Double valorBrutoFreteInf = 0.0;
        Double qtdeTotal = 0.0;
        Double vlrTotalCusto = 0.0;
        Integer nrItens = 0;
        for (ItemPedido it : its) {
            valorTotalBruto = valorTotalBruto + it.getValorTotalBruto();
            valorTotal = valorTotal + it.getValorTotal();
            valorDesconto = valorDesconto + it.getValorDesconto();
            valorDesp = valorDesp + it.getValorDespesaAcessoria();
            valorSeguro = valorSeguro + it.getValorSeguro();
            valorFrete = valorFrete + it.getValorFrete();
            if (ToolMethods.isWithData((Number)it.getValorTotalBrutoDescTrib())) {
                valorTotalBrutoDescTrib = valorTotalBrutoDescTrib + it.getValorTotalBrutoDescTrib();
            }
            if (ToolMethods.isWithData((Number)it.getValorTotalBrutoDescTrib())) {
                valorTotalDescTrib = valorTotalDescTrib + it.getValorTotalDescTrib();
            }
            if (it.getDescontoItem() == null || it.getDescontoItem() == 0) {
                valorDescontoInf = valorDescontoInf + it.getValorDesconto();
                valorBrutoDescontoInf = valorBrutoDescontoInf + it.getValorTotalBruto();
            }
            if (it.getFreteItem() == null || it.getFreteItem() == 0) {
                valorFreteInf = valorFreteInf + it.getValorFrete();
                valorBrutoFreteInf = valorBrutoFreteInf + it.getValorTotalBruto();
            }
            if (it.getSeguroItem() == null || it.getSeguroItem() == 0) {
                valorSeguroInf = valorSeguroInf + it.getValorSeguro();
                valorBrutoSeguroInf = valorBrutoSeguroInf + it.getValorTotalBruto();
            }
            if (it.getDespAcessItem() == null || it.getDespAcessItem() == 0) {
                valorDespInf = valorDespInf + it.getValorDespesaAcessoria();
                valorBrutoDespInf = valorBrutoDespInf + it.getValorTotalBruto();
            }
            Integer n = nrItens;
            nrItens = nrItens + 1;
            if (it.getValorCusto() == null) {
                it.setValorCusto(0.0);
            }
            vlrTotalCusto = vlrTotalCusto + it.getQuantidadeTotal() * it.getValorCusto();
            qtdeTotal = qtdeTotal + it.getQuantidadeTotal();
        }
        ped.setQtdeTotalItens(UtilPedidoCalculos.arredondarNumero(qtdeTotal));
        ped.setVlrTotalCusto(UtilPedidoCalculos.arredondarNumero(vlrTotalCusto));
        ped.setNrTotalItens(nrItens);
        ped.setValorTotalBruto(UtilPedidoCalculos.arredondarNumero(valorTotalBruto));
        ped.setValorTotal(UtilPedidoCalculos.arredondarNumero(valorTotal));
        ped.setValorTotalBrutoDescTrib(UtilPedidoCalculos.arredondarNumero(valorTotalBrutoDescTrib));
        ped.setValorTotalDescTrib(UtilPedidoCalculos.arredondarNumero(valorTotalDescTrib));
        UtilPedidoCalculos.getTotalizadorDesconto(ped, valorDesconto, valorDescontoInf, valorTotalBruto, valorBrutoDescontoInf);
        UtilPedidoCalculos.getTotalizadorFrete(ped, valorFrete, valorFreteInf, valorTotalBruto, valorBrutoFreteInf);
        UtilPedidoCalculos.getTotalizadorSeguro(ped, valorSeguro, valorSeguroInf, valorTotalBruto, valorBrutoSeguroInf);
        UtilPedidoCalculos.getTotalizadorDespAcessoria(ped, valorDesp, valorDespInf, valorTotalBruto, valorBrutoDespInf);
    }

    private static void getTotalizadorDesconto(Pedido ped, Double valorDesconto, Double valorDescontoInf, Double valorTotalBruto, Double valorTotalBrutoInf) {
        if (ped.getTipoDespAcessInf() == 0) {
            ped.setValorDescontoInf(UtilPedidoCalculos.arredondarNumero(valorDescontoInf));
        } else if (valorDescontoInf > 0.0 && valorTotalBrutoInf > 0.0) {
            ped.setPercDescontoInf(UtilPedidoCalculos.arredondarNumero(valorDescontoInf / valorTotalBrutoInf * 100.0));
        }
        ped.setValorDesconto(UtilPedidoCalculos.arredondarNumero(valorDesconto));
        if (valorTotalBruto > 0.0) {
            ped.setPercDesconto(UtilPedidoCalculos.arredondarNumero(valorDesconto / valorTotalBruto * 100.0));
        } else {
            ped.setPercDesconto(0.0);
        }
    }

    private static void getTotalizadorFrete(Pedido ped, Double valorFrete, Double valorFreteInf, Double valorTotalBruto, Double valorTotalBrutoInf) {
        if (ped.getTipoFreteInf() == 0) {
            ped.setValorFreteInf(UtilPedidoCalculos.arredondarNumero(valorFreteInf));
        } else if (valorFreteInf > 0.0 && valorTotalBrutoInf > 0.0) {
            ped.setPercFreteInf(UtilPedidoCalculos.arredondarNumero(valorFreteInf / valorTotalBrutoInf * 100.0));
        }
        ped.setValorFrete(UtilPedidoCalculos.arredondarNumero(valorFrete));
        if (valorTotalBruto > 0.0) {
            ped.setPercFrete(UtilPedidoCalculos.arredondarNumero(valorFrete / valorTotalBruto * 100.0));
        } else {
            ped.setPercFrete(0.0);
        }
    }

    private static void getTotalizadorSeguro(Pedido ped, Double valorSeguro, Double valorSeguroInf, Double valorTotalBruto, Double valorTotalBrutoInf) {
        if (ped.getTipoSeguroInf() == 0) {
            ped.setValorSeguroInf(UtilPedidoCalculos.arredondarNumero(valorSeguroInf));
        } else if (valorSeguroInf > 0.0 && valorTotalBrutoInf > 0.0) {
            ped.setPercSeguroInf(UtilPedidoCalculos.arredondarNumero(valorSeguroInf / valorTotalBrutoInf * 100.0));
        }
        ped.setValorSeguro(UtilPedidoCalculos.arredondarNumero(valorSeguro));
        if (valorTotalBruto > 0.0) {
            ped.setPercSeguro(UtilPedidoCalculos.arredondarNumero(valorSeguro / valorTotalBruto * 100.0));
        } else {
            ped.setPercSeguro(0.0);
        }
    }

    private static void getTotalizadorDespAcessoria(Pedido ped, Double valorDesp, Double valorDespInf, Double valorTotalBruto, Double valorTotalBrutoInf) {
        if (ped.getTipoDespAcessInf() == 0) {
            ped.setValorDespAcessoriaInf(UtilPedidoCalculos.arredondarNumero(valorDespInf));
        } else if (valorDespInf > 0.0 && valorTotalBrutoInf > 0.0) {
            ped.setPercDespAcessoriaInf(UtilPedidoCalculos.arredondarNumero(valorDespInf / valorTotalBrutoInf * 100.0));
        }
        ped.setValorDespAcessoria(UtilPedidoCalculos.arredondarNumero(valorDesp));
        if (valorTotalBruto > 0.0) {
            ped.setPercDespAcessoria(UtilPedidoCalculos.arredondarNumero(valorDesp / valorTotalBruto * 100.0));
        } else {
            ped.setPercDespAcessoria(0.0);
        }
    }

    private static void setNrItemPedidoAndNrSequencial(Pedido pedido) {
        Long count = 1L;
        for (ItemPedido it : pedido.getItemPedido()) {
            it.setNrItemPedido(count);
            it.setNrSequencial(count.intValue());
            Long l = count;
            count = count + 1L;
        }
    }
}

