/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.touchnfce.utils.pedido;

import com.touchcomp.basementorrules.calculorateio.CompRuleCalcRateioPercValor;
import com.touchcomp.basementorrules.calculorateio.SourcePercValor;
import com.touchcomp.basementortools.tools.formatter.ToolFormatter;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.touchnfce.model.ItemPedido;
import com.touchcomp.touchnfce.model.Pedido;
import java.util.LinkedList;
import java.util.List;

public class UtilPedidoCalculosDespAcess {
    void ratearDespAcessoria(Pedido pedido) throws Exception {
        List<SourcePercValor> itens = this.converterValores(pedido);
        Double percDespAcessoria = pedido.getPercDespAcessoriaInf();
        Double valorDespAcessoria = pedido.getValorDespAcessoriaInf();
        Short tipoDespAcessoria = pedido.getTipoDespAcessInf();
        CompRuleCalcRateioPercValor com = new CompRuleCalcRateioPercValor();
        if (tipoDespAcessoria == 0) {
            com.ratearPercentual(itens, percDespAcessoria);
        } else {
            com.ratearValor(itens, valorDespAcessoria);
        }
        double totalDescItens = 0.0;
        for (SourcePercValor iten : itens) {
            if (!iten.isPermitirRateio()) continue;
            totalDescItens += iten.getValor().doubleValue();
        }
        pedido.setValorDespAcessoriaInf(totalDescItens);
        pedido.setPercDespAcessoriaInf(ToolFormatter.arrredondarNumero((Double)(totalDescItens / pedido.getValorTotalBruto() * 100.0), (int)2));
    }

    private List<SourcePercValor> converterValores(Pedido pedido) {
        LinkedList<SourcePercValor> ret = new LinkedList<SourcePercValor>();
        for (ItemPedido item : pedido.getItemPedido()) {
            ret.add(new SourcePercValorItem(this, item));
        }
        return ret;
    }

    class SourcePercValorItem
    implements SourcePercValor {
        ItemPedido item;

        public SourcePercValorItem(UtilPedidoCalculosDespAcess this$0, ItemPedido item) {
            this.item = item;
        }

        public Double getBaseCalc() {
            return this.item.getValorTotalBruto();
        }

        public Double getValor() {
            return this.item.getValorDespesaAcessoria();
        }

        public void setPercentual(Double valor) {
            this.item.setPercDespesaAcessoria(valor);
        }

        public void setValor(Double valor) {
            this.item.setValorDespesaAcessoria(valor);
        }

        public Double getValorMinimo() {
            return this.item.getValorMinimo() * this.item.getQuantidadeTotal();
        }

        public boolean isPermitirRateio() {
            return !ToolMethods.isEquals((Object)this.item.getDespAcessItem(), (Object)1);
        }

        public Double getPercentual() {
            return this.item.getPercDespesaAcessoria();
        }
    }
}

