/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.touchnfce.utils.sitef;

import br.com.softwareexpress.sitef.JCliSiTefI;
import com.touchcomp.basementorexceptions.exceptions.impl.tef.ExceptionPinPadNotFound;
import com.touchcomp.basementorlogger.TLogger;
import com.touchcomp.basementortools.tools.date.ToolDate;
import com.touchcomp.basementortools.tools.formatter.ToolFormatter;
import com.touchcomp.touchnfce.controller.Alerts;
import com.touchcomp.touchnfce.properties.ConfPropertiesLoader;
import com.touchcomp.touchnfce.utils.sitef.SitefInterativoListener;
import com.touchcomp.touchnfce.utils.sitef.model.AuxPagamentoNFCe;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javafx.application.Platform;

public class UtilSitefPagamento {
    private static JCliSiTefI instance;
    private SitefInterativoListener listener;
    private static TLogger logger;

    public static JCliSiTefI getInstance() {
        if (instance == null) {
            instance = new JCliSiTefI();
        }
        return instance;
    }

    public HashMap iniciarPagamentoSiTef(Integer modalidade, Double valor, String nrNFCe, Date dataNFCe, Date horaNFCe, String operador, String restricoes, AuxPagamentoNFCe auxPagamento, Short restricoesSitef, SitefInterativoListener listener) {
        this.listener = listener;
        JCliSiTefI j = new JCliSiTefI();
        j.setValor(ToolFormatter.formataNumero((Number)valor, (int)2));
        j.setNumeroCuponFiscal(nrNFCe);
        j.setDataFiscal(ToolDate.dateToStr((Date)dataNFCe, (String)"yyyyMMdd"));
        j.setHorario(ToolDate.dateToStr((Date)horaNFCe, (String)"HHmmss"));
        j.setOperador(operador);
        j.setRestricoes(restricoes);
        if (restricoesSitef == 1) {
            j.setModalidade(modalidade.intValue());
            if (modalidade == 2) {
                this.setRestricoesDebito(j, auxPagamento);
            } else if (modalidade == 3) {
                this.setRestricoesCredito(j, auxPagamento);
            } else if (modalidade == 122) {
                this.setRestricoesPix(j, auxPagamento);
            }
        } else {
            j.setModalidade(0);
        }
        int retorno = j.iniciaFuncaoSiTefInterativo();
        if (retorno == 10000) {
            try {
                return this.continuaFuncaoSiTefInterativo(j, auxPagamento, restricoesSitef);
            }
            catch (ExceptionPinPadNotFound ex) {
                logger.error(ex.getMessage());
                Platform.runLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        Alerts.showAlertError(ex.getMessage());
                    }
                });
                return null;
            }
        }
        return null;
    }

    private HashMap continuaFuncaoSiTefInterativo(JCliSiTefI j, AuxPagamentoNFCe auxPagamento, Short restricoesSitef) throws ExceptionPinPadNotFound {
        j.setBuffer("");
        j.setContinuaNavegacao(0);
        int ret = 0;
        ret = j.verificaPresencaPinPad();
        if (ret == 0) {
            throw new ExceptionPinPadNotFound("PinPad n\u00e3o encontrado.");
        }
        int cont = 0;
        HashMap parametros = new HashMap();
        parametros.put("cancelaTransacao", false);
        parametros.put("AUX_PAGAMENTO", auxPagamento);
        while (true) {
            parametros.put("contador", ++cont);
            ret = j.continuaFuncaoSiTefInterativo();
            parametros.put("retorno", ret);
            if (ret != 10000) break;
            if (cont >= 1000) {
                j.setContinuaNavegacao(0);
                break;
            }
            Boolean cancelaTransacao = (Boolean)parametros.get("cancelaTransacao");
            if (cancelaTransacao.booleanValue()) {
                j.setContinuaNavegacao(-1);
                parametros.put("cancelaTransacao", false);
            }
            if (j.getTipoCampo() == 132) {
                parametros.put("BANDEIRA", j.getBuffer());
            }
            parametros = this.listener.interacaoTef(parametros, j, restricoesSitef);
        }
        return parametros;
    }

    public int finalizarTransacaoSiTef(int confirma, String nrNFCe, Date dataNFCe, Date horaNFCe) {
        JCliSiTefI j = new JCliSiTefI();
        j.setConfirma(confirma);
        j.setNumeroCuponFiscal(nrNFCe.toString());
        j.setDataFiscal(ToolDate.dateToStr((Date)dataNFCe, (String)"yyyyMMdd"));
        j.setHorario(ToolDate.dateToStr((Date)horaNFCe, (String)"HHmmss"));
        int retorno = j.finalizaTransacaoSiTefInterativo();
        System.out.println("retorno:" + retorno);
        return retorno;
    }

    public int finalizarTransacaoSiTef(int confirma, JCliSiTefI j) {
        j.setConfirma(confirma);
        int retorno = j.finalizaTransacaoSiTefInterativo();
        System.out.println("retorno:" + retorno);
        return retorno;
    }

    public int qtdeTransacoesTEFPendentes(Long nrNFCe, Date dataNFCe, Date horaNFCe) {
        JCliSiTefI j = new JCliSiTefI();
        j.setNumeroCuponFiscal(nrNFCe.toString());
        j.setDataFiscal(ToolDate.dateToStr((Date)dataNFCe, (String)"yyyyMMdd"));
        j.setHorario(ToolDate.dateToStr((Date)horaNFCe, (String)"HHmmss"));
        int ret = j.obtemQuantidadeTransacoesPendentes(nrNFCe.toString(), ToolDate.dateToStr((Date)dataNFCe, (String)"yyyyMMdd"));
        return ret;
    }

    private void setRestricoesDebito(JCliSiTefI j, AuxPagamentoNFCe auxPagamento) {
        ArrayList restricoes = new ArrayList();
        this.getCartaoDebitoMagneticoDigitado(auxPagamento, restricoes);
        this.getTipoDebito(auxPagamento, restricoes);
        Object paramAdic = "[";
        for (String aux : restricoes) {
            paramAdic = (String)paramAdic + aux + ";";
        }
        paramAdic = (String)paramAdic + "]";
        j.setParametrosAdicionais((String)paramAdic);
    }

    private void setRestricoesCredito(JCliSiTefI j, AuxPagamentoNFCe auxPagamento) {
        ArrayList restricoes = new ArrayList();
        this.getCartaoCreditoMagneticoDigitado(auxPagamento, restricoes);
        this.getTipoCredito(auxPagamento, restricoes);
        Object paramAdic = "[";
        for (String aux : restricoes) {
            paramAdic = (String)paramAdic + aux + ";";
        }
        paramAdic = (String)paramAdic + "]";
        j.setParametrosAdicionais((String)paramAdic);
    }

    private void getCartaoDebitoMagneticoDigitado(AuxPagamentoNFCe auxPagamento, List restricoes) {
        if (auxPagamento.getTipoCartao() == 1) {
            restricoes.add("43");
        } else {
            restricoes.add("42");
        }
    }

    private void getCartaoCreditoMagneticoDigitado(AuxPagamentoNFCe auxPagamento, List restricoes) {
        if (auxPagamento.getTipoCartao() == 1) {
            restricoes.add("30");
        } else {
            restricoes.add("29");
        }
    }

    private void getTipoDebito(AuxPagamentoNFCe auxPagamento, List restricoes) {
        if (auxPagamento.getFormaPagNFCe().getTipoDebito() == 0) {
            restricoes.add("19");
            restricoes.add("17");
            restricoes.add("3023");
            restricoes.add("18");
        } else if (auxPagamento.getFormaPagNFCe().getTipoDebito() == 1) {
            restricoes.add("16");
            restricoes.add("19");
            restricoes.add("3023");
            restricoes.add("18");
        } else if (auxPagamento.getFormaPagNFCe().getTipoDebito() == 2) {
            restricoes.add("16");
            restricoes.add("17");
        }
    }

    private void getTipoCredito(AuxPagamentoNFCe auxPagamento, List restricoes) {
        if (auxPagamento.getFormaPagNFCe().getTipoCredito() == 0) {
            restricoes.add("24");
            restricoes.add("3025");
            restricoes.add("28");
            restricoes.add("27");
            restricoes.add("36");
            restricoes.add("45");
            restricoes.add("47");
        } else if (auxPagamento.getFormaPagNFCe().getTipoCredito() == 1) {
            restricoes.add("24");
            restricoes.add("3025");
            restricoes.add("26");
            restricoes.add("28");
            restricoes.add("36");
            restricoes.add("41");
            restricoes.add("45");
            restricoes.add("47");
        } else if (auxPagamento.getFormaPagNFCe().getTipoCredito() == 2) {
            restricoes.add("24");
            restricoes.add("3025");
            restricoes.add("26");
            restricoes.add("27");
            restricoes.add("36");
            restricoes.add("45");
            restricoes.add("47");
        }
    }

    private void setRestricoesPix(JCliSiTefI j, AuxPagamentoNFCe auxPagamento) {
        if (ConfPropertiesLoader.get().getPinpadNaoSuportaQrcode() != null && ConfPropertiesLoader.get().getPinpadNaoSuportaQrcode().equals("1")) {
            String paramAdic = "{DevolveStringQRCode=1}";
            j.setParametrosAdicionais(paramAdic);
        }
    }

    static {
        logger = TLogger.get(UtilSitefPagamento.class);
    }
}

