/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.ArquivamentoDoc;
import com.touchcomp.basementor.model.vo.Colaborador;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.ItemTipoAdvertencia;
import com.touchcomp.basementor.model.vo.TipoPunicaoAdvertencia;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Version;

@Entity
@Table(name="ADVERTENCIA_COLABORADOR")
public class AdvertenciaColaborador
implements InterfaceVO {
    private Long identificador;
    private Empresa empresa;
    private Date dataCadastro;
    private Timestamp dataAtualizacao;
    private Colaborador colaborador;
    private Date dataAdvertencia;
    private Integer qtdade = 0;
    private ArquivamentoDoc arquivamentoDoc;
    private Date dataTermino;
    private ItemTipoAdvertencia itemTipoAdvertencia;
    private TipoPunicaoAdvertencia tipoPunicao;
    private String observacao;

    @Id
    @Column(nullable=false, unique=true, name="ID_ADVERTENCIA_COLABORADOR")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_ADVERTENCIA_COLABORADOR")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_ADVERTENCIA_COLAB_EMPRESA"))
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    @Column(name="DATA_CADASTRO")
    @Temporal(value=TemporalType.DATE)
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @Version
    @Column(name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_COLABORADOR", foreignKey=@ForeignKey(name="FK_ADVERTENCIA_COLAB_COLABORADO"))
    public Colaborador getColaborador() {
        return this.colaborador;
    }

    public void setColaborador(Colaborador colaborador) {
        this.colaborador = colaborador;
    }

    @Column(name="QTDADE")
    public Integer getQtdade() {
        return this.qtdade;
    }

    public void setQtdade(Integer qtdade) {
        this.qtdade = qtdade;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_ADVERTENCIA")
    public Date getDataAdvertencia() {
        return this.dataAdvertencia;
    }

    public void setDataAdvertencia(Date dataAdvertencia) {
        this.dataAdvertencia = dataAdvertencia;
    }

    @JoinColumn(name="ID_ARQUIVAMENTO_DOC", foreignKey=@ForeignKey(name="FK_ADVERTENCIA_COLAB_ARQUIV_DOC"))
    @ManyToOne(fetch=FetchType.LAZY)
    public ArquivamentoDoc getArquivamentoDoc() {
        return this.arquivamentoDoc;
    }

    public void setArquivamentoDoc(ArquivamentoDoc arquivamentoDoc) {
        this.arquivamentoDoc = arquivamentoDoc;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_TERMINO")
    public Date getDataTermino() {
        return this.dataTermino;
    }

    public void setDataTermino(Date dataTermino) {
        this.dataTermino = dataTermino;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_ITEM_TIPO_ADVERTENCIA", foreignKey=@ForeignKey(name="FK_ADVERTENCIA_COLAB_TIPO_ADV"))
    public ItemTipoAdvertencia getItemTipoAdvertencia() {
        return this.itemTipoAdvertencia;
    }

    public void setItemTipoAdvertencia(ItemTipoAdvertencia itemTipoAdvertencia) {
        this.itemTipoAdvertencia = itemTipoAdvertencia;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_TIPO_PUNICAO", foreignKey=@ForeignKey(name="FK_ADVERTENCIA_TIPO_PUNICAO"))
    public TipoPunicaoAdvertencia getTipoPunicao() {
        return this.tipoPunicao;
    }

    public void setTipoPunicao(TipoPunicaoAdvertencia tipoPunicao) {
        this.tipoPunicao = tipoPunicao;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0} - {1}", (Object[])new Object[]{this.getIdentificador(), this.getColaborador() != null ? this.getColaborador().getPessoa().getNome() : this.getColaborador()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @Column(name="OBSERVACAO", length=1000)
    public String getObservacao() {
        return this.observacao;
    }

    public void setObservacao(String observacao) {
        this.observacao = observacao;
    }
}

