/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.AberturaPeriodo;
import com.touchcomp.basementor.model.vo.CalculoInssEmpresa;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.ItemAlocadorTomadorServico;
import com.touchcomp.basementor.model.vo.TomadorServicoRh;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Version;
import org.hibernate.annotations.Cascade;

@Entity
@Table(name="ALOCADOR_TOMADOR_SERVICO")
public class AlocadorTomadorServico
implements InterfaceVO {
    private Long identificador;
    private Empresa empresa;
    private Date dataCadastro;
    private Timestamp dataAtualizacao;
    private AberturaPeriodo aberturaPeriodo;
    private List<ItemAlocadorTomadorServico> itemTomadores = new ArrayList<ItemAlocadorTomadorServico>();
    private Double valorRetencao = 0.0;
    private TomadorServicoRh tomador;
    private CalculoInssEmpresa calculoInss;
    private Double valorSalarioFamilia = 0.0;

    @Id
    @Column(nullable=false, unique=true, name="ID_ALOCADOR_TOMADOR_SERV")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_ALOCADOR_TOMADOR_SERV")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_ALOCADOR_TOMADOR_SERVICO_EMP"))
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    @Column(name="DATA_CADASTRO")
    @Temporal(value=TemporalType.DATE)
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @Version
    @Column(name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_ABERTURA_PERIODO", foreignKey=@ForeignKey(name="FK_ALOCADOR_TOMADOR_SERVICO_ABE"))
    public AberturaPeriodo getAberturaPeriodo() {
        return this.aberturaPeriodo;
    }

    public void setAberturaPeriodo(AberturaPeriodo ab) {
        this.aberturaPeriodo = ab;
    }

    @OneToMany(fetch=FetchType.LAZY, mappedBy="alocadorTomador", cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH, CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.ALL})
    public List<ItemAlocadorTomadorServico> getItemTomadores() {
        return this.itemTomadores;
    }

    public void setItemTomadores(List itemTomadores) {
        this.itemTomadores = itemTomadores;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0} - {1}", (Object[])new Object[]{this.getIdentificador(), this.getDataCadastro()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @Column(nullable=false, name="VALOR_RETENCAO", precision=15, scale=4)
    public Double getValorRetencao() {
        return this.valorRetencao;
    }

    public void setValorRetencao(Double valorRetencao) {
        this.valorRetencao = valorRetencao;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_TOMADOR_SERVICO", foreignKey=@ForeignKey(name="FK_ALOCADOR_TOMADOR_SERVICO_TOM"))
    @Cascade(value={org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.SAVE_UPDATE})
    public TomadorServicoRh getTomador() {
        return this.tomador;
    }

    public void setTomador(TomadorServicoRh tomador) {
        this.tomador = tomador;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_CALCULO_INSS_EMPRESA", foreignKey=@ForeignKey(name="FK_ALOCADOR_CALCULO_INSS"))
    public CalculoInssEmpresa getCalculoInss() {
        return this.calculoInss;
    }

    public void setCalculoInss(CalculoInssEmpresa calculoInss) {
        this.calculoInss = calculoInss;
    }

    @Column(name="VALOR_SALARIO_FAMILIA", precision=15, scale=2)
    public Double getValorSalarioFamilia() {
        return this.valorSalarioFamilia;
    }

    public void setValorSalarioFamilia(Double valorSalarioFamilia) {
        this.valorSalarioFamilia = valorSalarioFamilia;
    }
}

