/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.Salario13oColaborador;
import com.touchcomp.basementor.model.vo.Sindicato;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Version;
import org.hibernate.annotations.Cascade;

@Entity
@Table(name="ANO_DEC_O_SALARIO")
public class Ano13oSalario
implements InterfaceVO {
    private Long identificador;
    private Short tipoCalculo = 0;
    private Integer ano = 0;
    private List<Salario13oColaborador> salario13oColaborador = new ArrayList<Salario13oColaborador>();
    private Date dataCadastro;
    private Timestamp dataAtualizacao;
    private Empresa empresa;
    private Integer nrAvosAno = 0;
    private Double percentualCalculo = 0.0;
    private Date dataPagamento;
    private Sindicato sindicato;

    @Id
    @Column(name="ID_ANO_DEC_O_SALARIO")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_ANO_13_SALARIO")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @Column(name="ANO")
    public Integer getAno() {
        return this.ano;
    }

    public void setAno(Integer ano) {
        this.ano = ano;
    }

    @Column(name="DATA_ATUALIZACAO")
    @Version
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_CADASTRO")
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @JoinColumn(name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_ANO_DEC_O_SALARIO_EMPRESA"))
    @ManyToOne(fetch=FetchType.LAZY)
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    @Column(name="NR_AVOS_ANO")
    public Integer getNrAvosAno() {
        return this.nrAvosAno;
    }

    public void setNrAvosAno(Integer nrAvosAno) {
        this.nrAvosAno = nrAvosAno;
    }

    @Column(nullable=false, name="PERCENTUAL_CALCULO", precision=12, scale=2)
    public Double getPercentualCalculo() {
        return this.percentualCalculo;
    }

    public void setPercentualCalculo(Double percentualCalculo) {
        this.percentualCalculo = percentualCalculo;
    }

    @OneToMany(mappedBy="ano13Salario", fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN, org.hibernate.annotations.CascadeType.ALL})
    public List<Salario13oColaborador> getSalario13oColaborador() {
        return this.salario13oColaborador;
    }

    public void setSalario13oColaborador(List<Salario13oColaborador> salario13oColaborador) {
        this.salario13oColaborador = salario13oColaborador;
    }

    @Column(name="TIPO_CALCULO", precision=15, scale=2)
    public Short getTipoCalculo() {
        return this.tipoCalculo;
    }

    public void setTipoCalculo(Short tipoCalculo) {
        this.tipoCalculo = tipoCalculo;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getIdentificador()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @Column(name="DATA_PAGAMENTO")
    @Temporal(value=TemporalType.DATE)
    public Date getDataPagamento() {
        return this.dataPagamento;
    }

    public void setDataPagamento(Date dataPagamento) {
        this.dataPagamento = dataPagamento;
    }

    @JoinColumn(name="ID_SINDICATO", foreignKey=@ForeignKey(name="FK_SINDICATO_ANO_DEC"))
    @ManyToOne(fetch=FetchType.LAZY)
    public Sindicato getSindicato() {
        return this.sindicato;
    }

    public void setSindicato(Sindicato sindicato) {
        this.sindicato = sindicato;
    }
}

