/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.AgrupamentoValorIpi;
import com.touchcomp.basementor.model.vo.AjusteApuracaoIpi;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementortools.tools.date.ToolDate;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.UniqueConstraint;
import javax.persistence.Version;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;

@Entity
@Table(name="APURACAO_IPI", uniqueConstraints={@UniqueConstraint(name="UNQ1_APURACAO_IPI", columnNames={"DATA_INICIAL", "ID_EMPRESA"})})
public class ApuracaoIPI
implements InterfaceVO {
    private Long identificador;
    private Date anoMes;
    private Double vrDebito = 0.0;
    private Double vrOutroDebito = 0.0;
    private Double vrEstornoCredito = 0.0;
    private String descrOutroDebito;
    private String descrEstornoCredito;
    private Double vrCredito = 0.0;
    private Double vrOutroCredito = 0.0;
    private Double vrEstornoDebito = 0.0;
    private String descrOutroCredito;
    private String descrEstornoDebito;
    private Double vrDeducoes = 0.0;
    private Empresa empresa;
    private Date dataCadastro;
    private Timestamp dataAtualizacao;
    private String descrDeducoes;
    private Double saldoDevedor = 0.0;
    private Double saldoCredor = 0.0;
    private Short tipoApuracao = 0;
    private Double vrTotalDedito = 0.0;
    private Double vrTotalCredito = 0.0;
    private Double SaldoCreditoAnterior = 0.0;
    private String observacoes;
    private Date dataInicial;
    private Date dataFinal;
    private List<AjusteApuracaoIpi> ajustesApuracaoIpi;
    private List<AgrupamentoValorIpi> agrupamentoValorIpi = new ArrayList<AgrupamentoValorIpi>();
    private Double saldoCredorAntOutSis = 0.0;

    public ApuracaoIPI() {
        this.ajustesApuracaoIpi = new ArrayList<AjusteApuracaoIpi>();
    }

    @Id
    @Column(name="ID_APURACAO_IPI")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_APURACAO_IPI")
    public Long getIdentificador() {
        return this.identificador;
    }

    @Column(name="ANO_MES")
    @Temporal(value=TemporalType.DATE)
    public Date getAnoMes() {
        return this.anoMes;
    }

    @Column(nullable=false, name="VR_DEBITO", precision=12, scale=2)
    public Double getVrDebito() {
        return this.vrDebito;
    }

    @Column(nullable=false, name="VR_OUTRO_DEBITO", precision=12, scale=2)
    public Double getVrOutroDebito() {
        return this.vrOutroDebito;
    }

    @Column(nullable=false, name="VR_ESTORNO_CREDITO", precision=12, scale=2)
    public Double getVrEstornoCredito() {
        return this.vrEstornoCredito;
    }

    @Column(name="DESCR_OUTRO_DEBITO", length=100)
    public String getDescrOutroDebito() {
        return this.descrOutroDebito;
    }

    @Column(name="DESCR_ESTORNO_CREDITO", length=100)
    public String getDescrEstornoCredito() {
        return this.descrEstornoCredito;
    }

    @Column(nullable=false, name="VR_CREDITO", precision=12, scale=2)
    public Double getVrCredito() {
        return this.vrCredito;
    }

    @Column(nullable=false, name="VR_OUTRO_CREDITO", precision=12, scale=2)
    public Double getVrOutroCredito() {
        return this.vrOutroCredito;
    }

    @Column(nullable=false, name="VR_ESTORNO_DEBITO", precision=12, scale=2)
    public Double getVrEstornoDebito() {
        return this.vrEstornoDebito;
    }

    @Column(name="DESCR_OUTRO_CREDITO", length=100)
    public String getDescrOutroCredito() {
        return this.descrOutroCredito;
    }

    @Column(name="DESCR_ESTORNO_DEBITO", length=100)
    public String getDescrEstornoDebito() {
        return this.descrEstornoDebito;
    }

    @Column(nullable=false, name="VR_DEDUCOES", precision=12, scale=2)
    public Double getVrDeducoes() {
        return this.vrDeducoes;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_APURACAO_IPI_EMPRESA"))
    public Empresa getEmpresa() {
        return this.empresa;
    }

    @Column(name="DATA_CADASTRO")
    @Temporal(value=TemporalType.DATE)
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    @Version
    @Column(name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    @Column(name="DESCR_DEDUCOES", length=100)
    public String getDescrDeducoes() {
        return this.descrDeducoes;
    }

    @Column(nullable=false, name="SALDO_DEVEDOR", precision=12, scale=2)
    public Double getSaldoDevedor() {
        return this.saldoDevedor;
    }

    @Column(nullable=false, name="SALDO_CREDOR", precision=12, scale=2)
    public Double getSaldoCredor() {
        return this.saldoCredor;
    }

    @Column(name="TIPO_APURACAO")
    public Short getTipoApuracao() {
        return this.tipoApuracao;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    public void setAnoMes(Date anoMes) {
        this.anoMes = anoMes;
    }

    public void setVrDebito(Double vrDebito) {
        this.vrDebito = vrDebito;
    }

    public void setVrOutroDebito(Double vrOutroDebito) {
        this.vrOutroDebito = vrOutroDebito;
    }

    public void setVrEstornoCredito(Double vrEstornoCredito) {
        this.vrEstornoCredito = vrEstornoCredito;
    }

    public void setDescrOutroDebito(String descrOutroDebito) {
        this.descrOutroDebito = descrOutroDebito;
    }

    public void setDescrEstornoCredito(String descrEstornoCredito) {
        this.descrEstornoCredito = descrEstornoCredito;
    }

    public void setVrCredito(Double vrCredito) {
        this.vrCredito = vrCredito;
    }

    public void setVrOutroCredito(Double vrOutroCredito) {
        this.vrOutroCredito = vrOutroCredito;
    }

    public void setVrEstornoDebito(Double vrEstornoDebito) {
        this.vrEstornoDebito = vrEstornoDebito;
    }

    public void setDescrOutroCredito(String descrOutroCredito) {
        this.descrOutroCredito = descrOutroCredito;
    }

    public void setDescrEstornoDebito(String descrEstornoDebito) {
        this.descrEstornoDebito = descrEstornoDebito;
    }

    public void setVrDeducoes(Double vrDeducoes) {
        this.vrDeducoes = vrDeducoes;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    public void setDescrDeducoes(String descrDeducoes) {
        this.descrDeducoes = descrDeducoes;
    }

    public void setSaldoDevedor(Double saldoDevedor) {
        this.saldoDevedor = saldoDevedor;
    }

    public void setSaldoCredor(Double saldoCredor) {
        this.saldoCredor = saldoCredor;
    }

    public void setTipoApuracao(Short tipoApuracao) {
        this.tipoApuracao = tipoApuracao;
    }

    @Column(nullable=false, name="VR_TOTAL_DEBITO", precision=12, scale=2)
    public Double getVrTotalDedito() {
        return this.vrTotalDedito;
    }

    public void setVrTotalDedito(Double vrTotalDedito) {
        this.vrTotalDedito = vrTotalDedito;
    }

    @Column(nullable=false, name="VR_TOTAL_CREDITO", precision=12, scale=2)
    public Double getVrTotalCredito() {
        return this.vrTotalCredito;
    }

    public void setVrTotalCredito(Double vrTotalCredito) {
        this.vrTotalCredito = vrTotalCredito;
    }

    @Column(nullable=false, name="SALDO_CREDITO_ANTERIOR", precision=12, scale=2)
    public Double getSaldoCreditoAnterior() {
        return this.SaldoCreditoAnterior;
    }

    public void setSaldoCreditoAnterior(Double SaldoCreditoAnterior) {
        this.SaldoCreditoAnterior = SaldoCreditoAnterior;
    }

    @Column(name="OBSERVACOES", length=300)
    public String getObservacoes() {
        return this.observacoes;
    }

    public void setObservacoes(String observacoes) {
        this.observacoes = observacoes;
    }

    @Column(name="DATA_INICIAL")
    @Temporal(value=TemporalType.DATE)
    public Date getDataInicial() {
        return this.dataInicial;
    }

    public void setDataInicial(Date dataInicial) {
        this.dataInicial = dataInicial;
    }

    @Column(name="DATA_FINAL")
    @Temporal(value=TemporalType.DATE)
    public Date getDataFinal() {
        return this.dataFinal;
    }

    public void setDataFinal(Date dataFinal) {
        this.dataFinal = dataFinal;
    }

    @OneToMany(mappedBy="apuracaoIpi")
    @Cascade(value={CascadeType.ALL, CascadeType.DELETE_ORPHAN})
    public List<AjusteApuracaoIpi> getAjustesApuracaoIpi() {
        return this.ajustesApuracaoIpi;
    }

    public void setAjustesApuracaoIpi(List<AjusteApuracaoIpi> ajustesApuracaoIpi) {
        this.ajustesApuracaoIpi = ajustesApuracaoIpi;
    }

    @OneToMany(mappedBy="apuracaoIpi")
    @Cascade(value={CascadeType.ALL, CascadeType.DELETE_ORPHAN})
    public List<AgrupamentoValorIpi> getAgrupamentoValorIpi() {
        return this.agrupamentoValorIpi;
    }

    public void setAgrupamentoValorIpi(List<AgrupamentoValorIpi> agrupamentoValorIpi) {
        this.agrupamentoValorIpi = agrupamentoValorIpi;
    }

    @Column(nullable=false, name="SALDO_CREDO_ANT_OUT_SIS", precision=15, scale=2)
    public Double getSaldoCredorAntOutSis() {
        return this.saldoCredorAntOutSis;
    }

    public void setSaldoCredorAntOutSis(Double saldoCredorAntOutSis) {
        this.saldoCredorAntOutSis = saldoCredorAntOutSis;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        if (this.getTipoApuracao() == 0) {
            return ToolBaseMethodsVO.toString((String)"{0} - Periodo: {1} - Decendio 1", (Object[])new Object[]{this.getIdentificador(), ToolDate.dateToStr((Date)this.getAnoMes(), (String)"MM/yyyy")});
        }
        if (this.getTipoApuracao() == 1) {
            return ToolBaseMethodsVO.toString((String)"{0} - Periodo: {1} - Decendio 2", (Object[])new Object[]{this.getIdentificador(), ToolDate.dateToStr((Date)this.getAnoMes(), (String)"MM/yyyy")});
        }
        if (this.getTipoApuracao() == 2) {
            return ToolBaseMethodsVO.toString((String)"{0} - Periodo: {1} - Decendio 3", (Object[])new Object[]{this.getIdentificador(), ToolDate.dateToStr((Date)this.getAnoMes(), (String)"MM/yyyy")});
        }
        if (this.getTipoApuracao() == 3) {
            return ToolBaseMethodsVO.toString((String)"{0} - Periodo: {1} - Mensal", (Object[])new Object[]{this.getIdentificador(), ToolDate.dateToStr((Date)this.getAnoMes(), (String)"MM/yyyy")});
        }
        return "";
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }
}

