/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.ApuracaoLocacao;
import com.touchcomp.basementor.model.vo.ApuracaoLocacaoContratoArmazem;
import com.touchcomp.basementor.model.vo.ApuracaoLocacaoContratoBem;
import com.touchcomp.basementor.model.vo.ApuracaoLocacaoContratoFuncao;
import com.touchcomp.basementor.model.vo.ContratoLocacao;
import com.touchcomp.basementor.model.vo.GrupoApuracaoLocacao;
import com.touchcomp.basementor.model.vo.NotaContratoLocacao;
import com.touchcomp.basementor.model.vo.Rps;
import com.touchcomp.basementor.model.vo.Titulo;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.hibernate.annotations.Cascade;

@Entity
@Table(name="APUR_LOCAC_CONTRATO")
public class ApuracaoLocacaoContrato
implements InterfaceVO {
    private Long identificador;
    private ContratoLocacao contratoLocacao;
    private Double valorTotal = 0.0;
    private Double valorDesconto = 0.0;
    private Double valorTotalEventosManuais = 0.0;
    private Double valorTotalLiquido = 0.0;
    private List<ApuracaoLocacaoContratoBem> apuracaoLocacaoContratoBem = new ArrayList<ApuracaoLocacaoContratoBem>();
    private List<ApuracaoLocacaoContratoFuncao> apuracaoLocacaoContratoFuncao = new ArrayList<ApuracaoLocacaoContratoFuncao>();
    private List<ApuracaoLocacaoContratoArmazem> apuracaoLocacaoControleArmazem = new ArrayList<ApuracaoLocacaoContratoArmazem>();
    private ApuracaoLocacao apuracaoLocacao;
    private Rps rps;
    private NotaContratoLocacao notaContratoLocacao;
    private GrupoApuracaoLocacao grupoApuracao;
    private List<Titulo> titulos = new ArrayList<Titulo>();

    @Id
    @Column(nullable=false, name="ID_APUR_LOCAC_CONTRATO")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_APUR_LOCAC_CONTRATO")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_CONTRATO_LOCACAO", foreignKey=@ForeignKey(name="FK_APUR_LOCAC_CONTRATO_CONT_LOC"))
    public ContratoLocacao getContratoLocacao() {
        return this.contratoLocacao;
    }

    public void setContratoLocacao(ContratoLocacao contratoLocacao) {
        this.contratoLocacao = contratoLocacao;
    }

    @Column(nullable=false, name="VALOR_TOTAL", precision=15, scale=2)
    public Double getValorTotal() {
        return this.valorTotal;
    }

    public void setValorTotal(Double valorTotal) {
        this.valorTotal = valorTotal;
    }

    @Column(nullable=false, name="VALOR_DESCONTO", precision=15, scale=2)
    public Double getValorDesconto() {
        return this.valorDesconto;
    }

    public void setValorDesconto(Double valorDesconto) {
        this.valorDesconto = valorDesconto;
    }

    @OneToMany(mappedBy="apuracaoLocacaoContrato", fetch=FetchType.LAZY)
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN, org.hibernate.annotations.CascadeType.ALL})
    public List<ApuracaoLocacaoContratoBem> getApuracaoLocacaoContratoBem() {
        return this.apuracaoLocacaoContratoBem;
    }

    public void setApuracaoLocacaoContratoBem(List<ApuracaoLocacaoContratoBem> apuracaoLocacaoContratoBem) {
        this.apuracaoLocacaoContratoBem = apuracaoLocacaoContratoBem;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_APURACAO_LOCACAO", foreignKey=@ForeignKey(name="FK_APUR_LOCAC_CONTRATO_AP_LOCAC"))
    public ApuracaoLocacao getApuracaoLocacao() {
        return this.apuracaoLocacao;
    }

    public void setApuracaoLocacao(ApuracaoLocacao apuracaoLocacao) {
        this.apuracaoLocacao = apuracaoLocacao;
    }

    @Column(nullable=false, name="VALOR_EVENTOS_MANUAIS", precision=15, scale=4)
    public Double getValorTotalEventosManuais() {
        return this.valorTotalEventosManuais;
    }

    public void setValorTotalEventosManuais(Double valorTotalEventosManuais) {
        this.valorTotalEventosManuais = valorTotalEventosManuais;
    }

    @Column(nullable=false, name="VALOR_TOTAL_LIQUIDO", precision=15, scale=2)
    public Double getValorTotalLiquido() {
        return this.valorTotalLiquido;
    }

    public void setValorTotalLiquido(Double valorTotalLiquido) {
        this.valorTotalLiquido = valorTotalLiquido;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0} - Contrato nr: {1} - Apuracao Id.: {2}", (Object[])new Object[]{this.getIdentificador(), this.getContratoLocacao() != null ? this.getContratoLocacao().getNumeroContrato() : this.getContratoLocacao(), this.getApuracaoLocacao() != null ? this.getApuracaoLocacao().getIdentificador() : this.getApuracaoLocacao()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @OneToOne(mappedBy="apuracaoContratoLocacao", fetch=FetchType.LAZY)
    @Cascade(value={org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.REFRESH})
    public Rps getRps() {
        return this.rps;
    }

    public void setRps(Rps rps) {
        this.rps = rps;
    }

    @OneToOne(mappedBy="apuracaoLocacaoContrato", fetch=FetchType.LAZY)
    @Cascade(value={org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.REFRESH})
    public NotaContratoLocacao getNotaContratoLocacao() {
        return this.notaContratoLocacao;
    }

    public void setNotaContratoLocacao(NotaContratoLocacao notaContratoLocacao) {
        this.notaContratoLocacao = notaContratoLocacao;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_GRUPO_APURACAO", foreignKey=@ForeignKey(name="FK_APUR_LOCAC_CONTRATO_GR_APURA"))
    public GrupoApuracaoLocacao getGrupoApuracao() {
        return this.grupoApuracao;
    }

    public void setGrupoApuracao(GrupoApuracaoLocacao grupoApuracao) {
        this.grupoApuracao = grupoApuracao;
    }

    @OneToMany(mappedBy="apuracaoLocacaoContrato", fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN, org.hibernate.annotations.CascadeType.ALL})
    public List<Titulo> getTitulos() {
        return this.titulos;
    }

    public void setTitulos(List<Titulo> titulos) {
        this.titulos = titulos;
    }

    @OneToMany(mappedBy="apuracaoLocacaoContrato", fetch=FetchType.LAZY)
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN, org.hibernate.annotations.CascadeType.ALL})
    public List<ApuracaoLocacaoContratoFuncao> getApuracaoLocacaoContratoFuncao() {
        return this.apuracaoLocacaoContratoFuncao;
    }

    public void setApuracaoLocacaoContratoFuncao(List<ApuracaoLocacaoContratoFuncao> apuracaoLocacaoContratoFuncao) {
        this.apuracaoLocacaoContratoFuncao = apuracaoLocacaoContratoFuncao;
    }

    @OneToMany(mappedBy="apuracaoLocacaoContrato", fetch=FetchType.LAZY)
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN, org.hibernate.annotations.CascadeType.ALL})
    public List<ApuracaoLocacaoContratoArmazem> getApuracaoLocacaoControleArmazem() {
        return this.apuracaoLocacaoControleArmazem;
    }

    public void setApuracaoLocacaoControleArmazem(List<ApuracaoLocacaoContratoArmazem> apuracaoLocacaoControleArmazem) {
        this.apuracaoLocacaoControleArmazem = apuracaoLocacaoControleArmazem;
    }
}

