/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.ItemReinf2010;
import com.touchcomp.basementor.model.vo.ItemReinf2020;
import com.touchcomp.basementor.model.vo.ItemReinf4010;
import com.touchcomp.basementor.model.vo.ItemReinf4020;
import com.touchcomp.basementor.model.vo.ItemReinf4020NaoIdentificado;
import com.touchcomp.basementor.model.vo.ItemReinf4040;
import com.touchcomp.basementor.model.vo.ItemReinf4099;
import com.touchcomp.basementor.model.vo.TitulosApuracaoReinf;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Version;
import org.hibernate.annotations.Cascade;

@Entity
@Table(name="APURACAO_REINF")
public class ApuracaoReinf
implements InterfaceVO {
    private Long identificador;
    private Empresa empresa;
    private Date dataCadastro;
    private Timestamp dataAtualizacao;
    private Date periodo;
    private List<ItemReinf2020> itens2020;
    private List<ItemReinf2010> itens2010 = new ArrayList<ItemReinf2010>();
    private List<ItemReinf4010> itensReinf4010;
    private List<ItemReinf4020> itensReinf4020;
    private List<ItemReinf4040> itensReinf4040;
    private List<ItemReinf4020NaoIdentificado> itensReinf4020NI;
    private List<TitulosApuracaoReinf> titulosApuracaoReinf;
    private ItemReinf4099 itemReinf4099;
    private Short filtrarNotasRetidas = 0;

    public ApuracaoReinf() {
        this.itens2020 = new ArrayList<ItemReinf2020>();
        this.itensReinf4010 = new ArrayList<ItemReinf4010>();
        this.itensReinf4020 = new ArrayList<ItemReinf4020>();
        this.itensReinf4040 = new ArrayList<ItemReinf4040>();
        this.itensReinf4020NI = new ArrayList<ItemReinf4020NaoIdentificado>();
        this.titulosApuracaoReinf = new ArrayList<TitulosApuracaoReinf>();
    }

    @Id
    @Column(nullable=false, unique=true, name="ID_APURACAO_REINF")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_APURACAO_REINF")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_APURACAO_REINF_EMP"))
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_CADASTRO")
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @Version
    @Column(name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="PERIODO")
    public Date getPeriodo() {
        return this.periodo;
    }

    public void setPeriodo(Date periodo) {
        this.periodo = periodo;
    }

    @OneToMany(fetch=FetchType.LAZY, mappedBy="apuracaoReinf", cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH, CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.DELETE_ORPHAN, org.hibernate.annotations.CascadeType.ALL})
    public List<ItemReinf2020> getItens2020() {
        return this.itens2020;
    }

    public void setItens2020(List<ItemReinf2020> itens2020) {
        this.itens2020 = itens2020;
    }

    @OneToMany(fetch=FetchType.LAZY, mappedBy="apuracaoReinf", cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH, CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.DELETE_ORPHAN, org.hibernate.annotations.CascadeType.ALL})
    public List<ItemReinf2010> getItens2010() {
        return this.itens2010;
    }

    public void setItens2010(List<ItemReinf2010> itens2010) {
        this.itens2010 = itens2010;
    }

    @OneToMany(fetch=FetchType.LAZY, mappedBy="apuracaoReinf", cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH, CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.DELETE_ORPHAN, org.hibernate.annotations.CascadeType.ALL})
    public List<ItemReinf4010> getItensReinf4010() {
        return this.itensReinf4010;
    }

    public void setItensReinf4010(List<ItemReinf4010> itensReinf4010) {
        this.itensReinf4010 = itensReinf4010;
    }

    @OneToMany(fetch=FetchType.LAZY, mappedBy="apuracaoReinf", cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH, CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.DELETE_ORPHAN, org.hibernate.annotations.CascadeType.ALL})
    public List<ItemReinf4020> getItensReinf4020() {
        return this.itensReinf4020;
    }

    public void setItensReinf4020(List<ItemReinf4020> itensReinf4020) {
        this.itensReinf4020 = itensReinf4020;
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getIdentificador()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    @Column(name="FILTRAR_NOTAS_RETIDAS")
    public Short getFiltrarNotasRetidas() {
        return this.filtrarNotasRetidas;
    }

    public void setFiltrarNotasRetidas(Short filtrarNotasRetidas) {
        this.filtrarNotasRetidas = filtrarNotasRetidas;
    }

    @OneToMany(fetch=FetchType.LAZY, mappedBy="apuracaoReinf", cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH, CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.DELETE_ORPHAN, org.hibernate.annotations.CascadeType.ALL})
    public List<ItemReinf4040> getItensReinf4040() {
        return this.itensReinf4040;
    }

    public void setItensReinf4040(List<ItemReinf4040> itensReinf4040) {
        this.itensReinf4040 = itensReinf4040;
    }

    @OneToMany(fetch=FetchType.LAZY, mappedBy="apuracao", cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH, CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.DELETE_ORPHAN, org.hibernate.annotations.CascadeType.ALL})
    public List<ItemReinf4020NaoIdentificado> getItensReinf4020NI() {
        return this.itensReinf4020NI;
    }

    public void setItensReinf4020NI(List<ItemReinf4020NaoIdentificado> itensReinf4020NI) {
        this.itensReinf4020NI = itensReinf4020NI;
    }

    @OneToMany(fetch=FetchType.LAZY, mappedBy="apuracaoReinf", cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH, CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.DELETE_ORPHAN, org.hibernate.annotations.CascadeType.ALL})
    public List<TitulosApuracaoReinf> getTitulosApuracaoReinf() {
        return this.titulosApuracaoReinf;
    }

    public void setTitulosApuracaoReinf(List<TitulosApuracaoReinf> titulosApuracaoReinf) {
        this.titulosApuracaoReinf = titulosApuracaoReinf;
    }

    @OneToOne(fetch=FetchType.LAZY, mappedBy="apuracaoReinf", cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH, CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.DELETE_ORPHAN, org.hibernate.annotations.CascadeType.ALL})
    public ItemReinf4099 getItemReinf4099() {
        return this.itemReinf4099;
    }

    public void setItemReinf4099(ItemReinf4099 itemReinf4099) {
        this.itemReinf4099 = itemReinf4099;
    }
}

