/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.Colaborador;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Version;
import org.hibernate.annotations.Generated;
import org.hibernate.annotations.GenerationTime;

@Entity
@Table(name="ARQUIVO_NIS")
public class ArquivoNIS
implements InterfaceVO {
    private Long identificador;
    private Date dataCadastro;
    private Timestamp dataAtualizacao;
    private Empresa empresa;
    private Date dataEmissao;
    private Date dataAdmissaoInicial;
    private Date dataAdmissaoFinal;
    private Short nrSequencial = 1;
    private Short tipoRemessa = 0;
    private List<Colaborador> colaborador = new ArrayList<Colaborador>();
    private Short enviarDadosTituloEleitor = 0;
    private Short enviarDadosRG = 0;

    @Id
    @Column(nullable=false, name="ID_ARQUIVO_NIS")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_ARQUIVO_NIS")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_CADASTRO")
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @Version
    @Column(name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @JoinColumn(name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_ARQUIVO_NIS_EMPRESA"))
    @ManyToOne(fetch=FetchType.LAZY)
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_EMISSAO")
    public Date getDataEmissao() {
        return this.dataEmissao;
    }

    public void setDataEmissao(Date dataEmissao) {
        this.dataEmissao = dataEmissao;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_ADMISSAO_INICIAL")
    public Date getDataAdmissaoInicial() {
        return this.dataAdmissaoInicial;
    }

    public void setDataAdmissaoInicial(Date dataAdmissaoInicial) {
        this.dataAdmissaoInicial = dataAdmissaoInicial;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_ADMISSAO_FINAL")
    public Date getDataAdmissaoFinal() {
        return this.dataAdmissaoFinal;
    }

    public void setDataAdmissaoFinal(Date dataAdmissaoFinal) {
        this.dataAdmissaoFinal = dataAdmissaoFinal;
    }

    @Column(name="NR_SEQUENCIAL")
    @Generated(value=GenerationTime.ALWAYS)
    public Short getNrSequencial() {
        return this.nrSequencial;
    }

    public void setNrSequencial(Short nrSequencial) {
        this.nrSequencial = nrSequencial;
    }

    @Column(name="TIPO_REMESSA")
    public Short getTipoRemessa() {
        return this.tipoRemessa;
    }

    public void setTipoRemessa(Short tipoRemessa) {
        this.tipoRemessa = tipoRemessa;
    }

    @OneToMany(fetch=FetchType.LAZY)
    @JoinTable(name="arquivo_nis_colaborador", joinColumns={@JoinColumn(name="id_arquivo_nis")}, inverseJoinColumns={@JoinColumn(name="ID_COLABORADOR")})
    public List<Colaborador> getColaborador() {
        return this.colaborador;
    }

    public void setColaborador(List<Colaborador> colaborador) {
        this.colaborador = colaborador;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getNrSequencial()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @Column(name="ENVIAR_DADOS_TITULO_ELEITOR")
    public Short getEnviarDadosTituloEleitor() {
        return this.enviarDadosTituloEleitor;
    }

    public void setEnviarDadosTituloEleitor(Short enviarDadosTituloEleitor) {
        this.enviarDadosTituloEleitor = enviarDadosTituloEleitor;
    }

    @Column(name="ENVIAR_DADOS_RG")
    public Short getEnviarDadosRG() {
        return this.enviarDadosRG;
    }

    public void setEnviarDadosRG(Short enviarDadosRG) {
        this.enviarDadosRG = enviarDadosRG;
    }
}

