/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.ChequeTerceiros;
import com.touchcomp.basementor.model.vo.ContaValores;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.ModeloLancBancario;
import com.touchcomp.basementor.model.vo.MovimentoBancario;
import com.touchcomp.basementor.model.vo.Usuario;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;

@Entity
@Table(name="BAIXA_CHEQUE_TERC")
public class BaixaChequeTerceiros
implements InterfaceVO {
    private Long identificador;
    private String observacao;
    private Date dataCadastro;
    private Date dataBaixa;
    private ChequeTerceiros chequeTerceiros;
    private Usuario usuario;
    private MovimentoBancario movimentoFinanceiro;
    private Empresa empresa;
    private ModeloLancBancario modeloLancBancario;
    private ContaValores contaValor;
    private Short gerarMovFinanceiro = 1;
    private Double valorBaixa = 0.0;

    @Id
    @Column(nullable=false, name="ID_BAIXA_CHEQUE_TERC")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_BAIXA_CHEQUE_TERC")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @Column(name="OBSERVACAO", length=300)
    public String getObservacao() {
        return this.observacao;
    }

    public void setObservacao(String observacao) {
        this.observacao = observacao;
    }

    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="DATA_CADASTRO")
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_CHEQUE_TERCEIROS", foreignKey=@ForeignKey(name="FK_BAIXA_CHEQUE_TERC_CH"))
    public ChequeTerceiros getChequeTerceiros() {
        return this.chequeTerceiros;
    }

    public void setChequeTerceiros(ChequeTerceiros chequeTerceiros) {
        this.chequeTerceiros = chequeTerceiros;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_USUARIO", foreignKey=@ForeignKey(name="FK_BAIXA_CHEQUE_TERC_USU"))
    public Usuario getUsuario() {
        return this.usuario;
    }

    public void setUsuario(Usuario usuario) {
        this.usuario = usuario;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_MOVIMENTO_FINANCEIRO", foreignKey=@ForeignKey(name="FK_BAIXA_CHEQUE_TERC_MOV"))
    @Cascade(value={CascadeType.ALL, CascadeType.DELETE_ORPHAN})
    public MovimentoBancario getMovimentoFinanceiro() {
        return this.movimentoFinanceiro;
    }

    public void setMovimentoFinanceiro(MovimentoBancario movimentoFinanceiro) {
        this.movimentoFinanceiro = movimentoFinanceiro;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_BAIXA_CHEQUE_TERC_EMP"))
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="DATA_BAIXA")
    public Date getDataBaixa() {
        return this.dataBaixa;
    }

    public void setDataBaixa(Date dataBaixa) {
        this.dataBaixa = dataBaixa;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_MODELO_LANC_BANCARIO", foreignKey=@ForeignKey(name="FK_BAIXA_CHEQUE_TERC_MOD_LANC"))
    public ModeloLancBancario getModeloLancBancario() {
        return this.modeloLancBancario;
    }

    public void setModeloLancBancario(ModeloLancBancario modeloLancBancario) {
        this.modeloLancBancario = modeloLancBancario;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_CONTA_VALOR", foreignKey=@ForeignKey(name="FK_BAIXA_CHEQUE_TERC_CONT_VA"))
    public ContaValores getContaValor() {
        return this.contaValor;
    }

    public void setContaValor(ContaValores contaValor) {
        this.contaValor = contaValor;
    }

    @Column(name="GERAR_MOV_FINANCEIRO")
    public Short getGerarMovFinanceiro() {
        return this.gerarMovFinanceiro;
    }

    public void setGerarMovFinanceiro(Short gerarMovFinanceiro) {
        this.gerarMovFinanceiro = gerarMovFinanceiro;
    }

    @Column(name="VALOR_BAIXA")
    public Double getValorBaixa() {
        return this.valorBaixa;
    }

    public void setValorBaixa(Double valorBaixa) {
        this.valorBaixa = valorBaixa;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getObservacao()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }
}

