/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.FeriasColaborador;
import com.touchcomp.basementor.model.vo.MovimentoFolha;
import com.touchcomp.basementor.model.vo.Recisao;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;

@Entity
@Table(name="BASE_INSS_ESCALONADA")
public class BaseInssEscalonada
implements InterfaceVO {
    private Long identificador;
    private Double baseInss;
    private Double aliquota;
    private Double valor;
    private FeriasColaborador ferias;
    private Recisao recisao;
    private MovimentoFolha movimentoFolha;
    private String origem;

    public BaseInssEscalonada() {
        this.baseInss = 0.0;
        this.aliquota = 0.0;
        this.valor = 0.0;
    }

    public BaseInssEscalonada(String origem) {
        this.origem = origem;
        this.baseInss = 0.0;
        this.aliquota = 0.0;
        this.valor = 0.0;
    }

    @Id
    @Column(nullable=false, unique=true, name="ID_BASE_INSS_ESCALONADA")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_BASE_INSS_ESCALONADA")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @Column(name="BASE_INSS", precision=15, scale=2)
    public Double getBaseInss() {
        return this.baseInss;
    }

    public void setBaseInss(Double baseInss) {
        this.baseInss = baseInss;
    }

    @Column(name="ALIQUOTA", precision=15, scale=2)
    public Double getAliquota() {
        return this.aliquota;
    }

    public void setAliquota(Double aliquota) {
        this.aliquota = aliquota;
    }

    @Column(name="VALOR", precision=15, scale=2)
    public Double getValor() {
        return this.valor;
    }

    public void setValor(Double valor) {
        this.valor = valor;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_FERIAS", foreignKey=@ForeignKey(name="FK_BASE_INSS_ESCALONADA_1"))
    public FeriasColaborador getFerias() {
        return this.ferias;
    }

    public void setFerias(FeriasColaborador ferias) {
        this.ferias = ferias;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_RECISAO", foreignKey=@ForeignKey(name="FK_BASE_INSS_ESCALONADA_2"))
    public Recisao getRecisao() {
        return this.recisao;
    }

    public void setRecisao(Recisao recisao) {
        this.recisao = recisao;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_MOVIMENTO_FOLHA", foreignKey=@ForeignKey(name="FK_BASE_INSS_ESCALONADA_3"))
    public MovimentoFolha getMovimentoFolha() {
        return this.movimentoFolha;
    }

    public void setMovimentoFolha(MovimentoFolha movimentoFolha) {
        this.movimentoFolha = movimentoFolha;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getIdentificador()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @Column(name="ORIGEM", length=50)
    public String getOrigem() {
        return this.origem;
    }

    public void setOrigem(String origem) {
        this.origem = origem;
    }
}

