/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.InstituicaoValores;
import com.touchcomp.basementor.model.vo.MovimentoFolha;
import com.touchcomp.basementor.model.vo.RelacaoDependenciaPensao;
import com.touchcomp.basementor.model.vo.TipoPagamentoPensao;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;

@Entity
@Table(name="BENEFICIARIO_PENSAO_FOLHA")
public class BeneficiarioPensaoFolha
implements InterfaceVO {
    private Long identificador;
    private Date dataCadastro;
    private MovimentoFolha movimentoFolha;
    private String nome;
    private String cpf;
    private Date dataNascimento;
    private RelacaoDependenciaPensao dependenciaPensao;
    private Short ativo = 0;
    private String agencia;
    private String conta;
    private String operacao;
    private Double percentualPensao = 0.0;
    private TipoPagamentoPensao tipoPagamentoPensao;
    private Double valorFixoPensao = 0.0;
    private InstituicaoValores banco;

    @Id
    @Column(nullable=false, unique=true, name="ID_BENEFICIO_PENSAO_ALIMENTICIA")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_BEN_PENSAO_FOLHA")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_CADASTRO")
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @Column(name="NOME", length=600)
    public String getNome() {
        return this.nome;
    }

    public void setNome(String nome) {
        this.nome = nome;
    }

    @Column(name="CPF", length=60)
    public String getCpf() {
        return this.cpf;
    }

    public void setCpf(String cpf) {
        this.cpf = cpf;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_NASCIMENTO")
    public Date getDataNascimento() {
        return this.dataNascimento;
    }

    public void setDataNascimento(Date dataNascimento) {
        this.dataNascimento = dataNascimento;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_DEPENDENCIA_PENSAO", foreignKey=@ForeignKey(name="FK_BENEFICIARIO_PENSAO_F_DEP_PE"))
    public RelacaoDependenciaPensao getDependenciaPensao() {
        return this.dependenciaPensao;
    }

    public void setDependenciaPensao(RelacaoDependenciaPensao dependenciaPensao) {
        this.dependenciaPensao = dependenciaPensao;
    }

    @Column(name="ATIVO")
    public Short getAtivo() {
        return this.ativo;
    }

    public void setAtivo(Short ativo) {
        this.ativo = ativo;
    }

    @Column(name="AGENCIA", length=60)
    public String getAgencia() {
        return this.agencia;
    }

    public void setAgencia(String agencia) {
        this.agencia = agencia;
    }

    @Column(name="CONTA", length=60)
    public String getConta() {
        return this.conta;
    }

    public void setConta(String conta) {
        this.conta = conta;
    }

    @Column(name="OPERACAO", length=60)
    public String getOperacao() {
        return this.operacao;
    }

    public void setOperacao(String operacao) {
        this.operacao = operacao;
    }

    @Column(name="PERCENTUAL_PENSAO", precision=15, scale=2)
    public Double getPercentualPensao() {
        return this.percentualPensao;
    }

    public void setPercentualPensao(Double percentualPensao) {
        this.percentualPensao = percentualPensao;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_TP_PAGAMENTO_PENSAO", foreignKey=@ForeignKey(name="FK_BENEFICIARIO_PENSAO_F_TP_PAG"))
    public TipoPagamentoPensao getTipoPagamentoPensao() {
        return this.tipoPagamentoPensao;
    }

    public void setTipoPagamentoPensao(TipoPagamentoPensao tipoPagamentoPensao) {
        this.tipoPagamentoPensao = tipoPagamentoPensao;
    }

    @Column(name="VALOR_FIXO_PENSAO", precision=15, scale=2)
    public Double getValorFixoPensao() {
        return this.valorFixoPensao;
    }

    public void setValorFixoPensao(Double valorFixoPensao) {
        this.valorFixoPensao = valorFixoPensao;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_INSTITUICAO_VALORES", foreignKey=@ForeignKey(name="FK_BENEFICIARIO_PENSAO_F_INST_V"))
    public InstituicaoValores getBanco() {
        return this.banco;
    }

    public void setBanco(InstituicaoValores banco) {
        this.banco = banco;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_MOVIMENTO_FOLHA", foreignKey=@ForeignKey(name="FK_BENEFICIARIO_PENSAO_F_M_FOL"))
    public MovimentoFolha getMovimentoFolha() {
        return this.movimentoFolha;
    }

    public void setMovimentoFolha(MovimentoFolha movimentoFolha) {
        this.movimentoFolha = movimentoFolha;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0} - {1}", (Object[])new Object[]{this.getIdentificador(), this.getNome()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }
}

