/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.CarteiraCobranca;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.LoteContabil;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.Date;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Version;
import org.hibernate.annotations.Cascade;

@Entity
@Table(name="BORDERO_FINANCEIRO")
@Inheritance(strategy=InheritanceType.JOINED)
public class BorderoFinanceiro
implements InterfaceVO {
    private Long identificador;
    private Empresa empresa;
    private Timestamp dataAtualizacao;
    private Date dataBordero;
    private CarteiraCobranca carteiraCobranca;
    private Date dataCadastro;
    private CarteiraCobranca carteiraOrigem;
    private LoteContabil loteContabil;

    @Id
    @Column(name="ID_BORDERO_FINANCEIRO")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_BORDERO_FINANCEIRO")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @Column(name="DATA_BORDERO")
    @Temporal(value=TemporalType.DATE)
    public Date getDataBordero() {
        return this.dataBordero;
    }

    public void setDataBordero(Date dataBordero) {
        this.dataBordero = dataBordero;
    }

    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="ID_CARTEIRA_COBRANCA", foreignKey=@ForeignKey(name="FK_BORDERO_FINANCEIRO_CART_COB"))
    public CarteiraCobranca getCarteiraCobranca() {
        return this.carteiraCobranca;
    }

    public void setCarteiraCobranca(CarteiraCobranca carteiraCobranca) {
        this.carteiraCobranca = carteiraCobranca;
    }

    @Column(name="DATA_CADASTRO")
    @Temporal(value=TemporalType.DATE)
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_BORDERO_FINANCEIRO_EMPRESA"))
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    @Version
    @Column(name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @JoinColumn(name="ID_CARTEIRA_ORIGEM", foreignKey=@ForeignKey(name="FK_BORDERO_FINANCEIRO_CAT_ORIG"))
    @ManyToOne(fetch=FetchType.LAZY)
    public CarteiraCobranca getCarteiraOrigem() {
        return this.carteiraOrigem;
    }

    public void setCarteiraOrigem(CarteiraCobranca carteiraOrigem) {
        this.carteiraOrigem = carteiraOrigem;
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0} - {1} - {2}", (Object[])new Object[]{"BORDERO", this.getCarteiraCobranca() != null ? this.getCarteiraCobranca().getNome() : this.getCarteiraCobranca(), this.getDataBordero()});
    }

    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    @JoinColumn(name="ID_LOTE_CONTABIL", foreignKey=@ForeignKey(name="FK_BORDERO_FINANCEIRO_LOTE_CONT"))
    public LoteContabil getLoteContabil() {
        return this.loteContabil;
    }

    public void setLoteContabil(LoteContabil loteContabil) {
        this.loteContabil = loteContabil;
    }
}

