/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.AtualizacaoSalarial;
import com.touchcomp.basementor.model.vo.AtualizacaoValoresVT;
import com.touchcomp.basementor.model.vo.Colaborador;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.FornecedoraTicketAlimentacao;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Version;

@Entity
@Table(name="CADASTRO_BENEFICIO_REF_CESTA")
public class CadastroBeneficioRefeicaoCesta
implements InterfaceVO {
    private Long identificador;
    private Date dataCadastro;
    private Timestamp dataAtualizacao;
    private Empresa empresa;
    private Double valorVale = 0.0;
    private Double valorTotalFixo = 0.0;
    private Double valorSomadoArquivo = 0.0;
    private Double valorCestaBasica = 0.0;
    private Short naoValidarDias = 0;
    private Short tipoTicket = 0;
    private Short somarCestaBasicaAlimentacao = 0;
    private Short descontarFolha = 0;
    private Short recebeCestaBasica = 0;
    private FornecedoraTicketAlimentacao fornecedor;
    private Colaborador colaborador;
    private Short informarValorManual = 0;
    private AtualizacaoSalarial atualizacaoSalarial;
    private Date periodoBeneficio;
    private Double percDescontoVA = 0.0;
    private Double valorDescVA = 0.0;
    private Double diasApuracaoVA = 0.0;
    private Double valorDescontoFixo = 0.0;
    private Double limiteFaltas = 0.0;
    private AtualizacaoValoresVT atualizacaoVt;

    @Id
    @Column(nullable=false, unique=true, name="ID_BENEFICIO_REF_CESTA")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_BENEFICIO_REF_CESTA")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_CADASTRO")
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @Version
    @Column(name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_CADASTRO_BENEFICIO_EMPRESA"))
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getIdentificador()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @Column(name="VALOR_VALE", precision=15, scale=2)
    public Double getValorVale() {
        return this.valorVale;
    }

    public void setValorVale(Double valorVale) {
        this.valorVale = valorVale;
    }

    @Column(name="VALOR_TOTAL_FIXO", precision=15, scale=2)
    public Double getValorTotalFixo() {
        return this.valorTotalFixo;
    }

    public void setValorTotalFixo(Double valorTotalFixo) {
        this.valorTotalFixo = valorTotalFixo;
    }

    @Column(name="VALOR_SOMADO_ARQUIVO", precision=15, scale=2)
    public Double getValorSomadoArquivo() {
        return this.valorSomadoArquivo;
    }

    public void setValorSomadoArquivo(Double valorSomadoArquivo) {
        this.valorSomadoArquivo = valorSomadoArquivo;
    }

    @Column(name="VALOR_CESTA_BASICA", precision=15, scale=2)
    public Double getValorCestaBasica() {
        return this.valorCestaBasica;
    }

    public void setValorCestaBasica(Double valorCestaBasica) {
        this.valorCestaBasica = valorCestaBasica;
    }

    @Column(name="NAO_VALIDAR_DIAS")
    public Short getNaoValidarDias() {
        return this.naoValidarDias;
    }

    public void setNaoValidarDias(Short naoValidarDias) {
        this.naoValidarDias = naoValidarDias;
    }

    @Column(name="TIPO_TICKET")
    public Short getTipoTicket() {
        return this.tipoTicket;
    }

    public void setTipoTicket(Short tipoTicket) {
        this.tipoTicket = tipoTicket;
    }

    @Column(name="SOMAR_CESTA_BASICA_ALIMENTACAO")
    public Short getSomarCestaBasicaAlimentacao() {
        return this.somarCestaBasicaAlimentacao;
    }

    public void setSomarCestaBasicaAlimentacao(Short somarCestaBasicaAlimentacao) {
        this.somarCestaBasicaAlimentacao = somarCestaBasicaAlimentacao;
    }

    @Column(name="DESCONTAR_FOLHA")
    public Short getDescontarFolha() {
        return this.descontarFolha;
    }

    public void setDescontarFolha(Short descontarFolha) {
        this.descontarFolha = descontarFolha;
    }

    @Column(name="RECEBE_CESTA_BASICA")
    public Short getRecebeCestaBasica() {
        return this.recebeCestaBasica;
    }

    public void setRecebeCestaBasica(Short recebeCestaBasica) {
        this.recebeCestaBasica = recebeCestaBasica;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_FORNECEDOR_TICKET", foreignKey=@ForeignKey(name="FK_CADASTRO_BENEFICIO_FORNECEDO"))
    public FornecedoraTicketAlimentacao getFornecedor() {
        return this.fornecedor;
    }

    public void setFornecedor(FornecedoraTicketAlimentacao fornecedor) {
        this.fornecedor = fornecedor;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_COLABORADOR", foreignKey=@ForeignKey(name="FK_CADASTRO_BENEFICIO_COLABORAD"))
    public Colaborador getColaborador() {
        return this.colaborador;
    }

    public void setColaborador(Colaborador colaborador) {
        this.colaborador = colaborador;
    }

    @Column(name="INFORMAR_VALOR_MANUAL")
    public Short getInformarValorManual() {
        return this.informarValorManual;
    }

    public void setInformarValorManual(Short informarValorManual) {
        this.informarValorManual = informarValorManual;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_ATUALIZACAO_SALARIAL", foreignKey=@ForeignKey(name="FK_ATUALIZACAO_SALARIAL_BEN"))
    public AtualizacaoSalarial getAtualizacaoSalarial() {
        return this.atualizacaoSalarial;
    }

    public void setAtualizacaoSalarial(AtualizacaoSalarial atualizacaoSalarial) {
        this.atualizacaoSalarial = atualizacaoSalarial;
    }

    @Column(name="PERIODO_BENEFICIO")
    @Temporal(value=TemporalType.DATE)
    public Date getPeriodoBeneficio() {
        return this.periodoBeneficio;
    }

    public void setPeriodoBeneficio(Date periodoBeneficio) {
        this.periodoBeneficio = periodoBeneficio;
    }

    @Column(name="PERC_DESCONTO_VA", precision=15, scale=4)
    public Double getPercDescontoVA() {
        return this.percDescontoVA;
    }

    public void setPercDescontoVA(Double percDescontoVA) {
        this.percDescontoVA = percDescontoVA;
    }

    @Column(name="VALOR_DESCONTO_VA", precision=15, scale=4)
    public Double getValorDescVA() {
        return this.valorDescVA;
    }

    public void setValorDescVA(Double valorDescVA) {
        this.valorDescVA = valorDescVA;
    }

    @Column(name="DIAS_APURACAO_VA", precision=15, scale=4)
    public Double getDiasApuracaoVA() {
        return this.diasApuracaoVA;
    }

    public void setDiasApuracaoVA(Double diasApuracaoVA) {
        this.diasApuracaoVA = diasApuracaoVA;
    }

    @Column(name="VALOR_DESCONTO_FIXO", precision=15, scale=4)
    public Double getValorDescontoFixo() {
        return this.valorDescontoFixo;
    }

    public void setValorDescontoFixo(Double valorDescontoFixo) {
        this.valorDescontoFixo = valorDescontoFixo;
    }

    @Column(name="LIMITE_FALTAS", precision=15, scale=4)
    public Double getLimiteFaltas() {
        return this.limiteFaltas;
    }

    public void setLimiteFaltas(Double limiteFaltas) {
        this.limiteFaltas = limiteFaltas;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_ATUALIZACAO_VT", foreignKey=@ForeignKey(name="FK_ATUALIZACAO_VT_BENEFICIO"))
    public AtualizacaoValoresVT getAtualizacaoVt() {
        return this.atualizacaoVt;
    }

    public void setAtualizacaoVt(AtualizacaoValoresVT atualizacaoVt) {
        this.atualizacaoVt = atualizacaoVt;
    }
}

