/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.DesligamentoCaged;
import com.touchcomp.basementor.model.vo.DesligamentoRais;
import com.touchcomp.basementor.model.vo.EmpresaTipoRescisao;
import com.touchcomp.basementor.model.vo.EsocMotivoDesligamento;
import com.touchcomp.basementor.model.vo.MovimentoSefip;
import com.touchcomp.basementor.model.vo.TipoCalculoEvento;
import com.touchcomp.basementor.model.vo.TipoRecisaoContratual;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.hibernate.annotations.Cascade;

@Entity
@Table(name="CADASTRO_RECISAO")
public class CadastroRecisao
implements InterfaceVO {
    private Long identificador;
    private TipoRecisaoContratual recisao;
    private List<TipoCalculoEvento> eventos;
    private DesligamentoCaged desligamentoCaged;
    private MovimentoSefip movimentoSefip;
    private Short FgtsRecolhidoGrrf = 0;
    private DesligamentoRais desligamentoRais;
    private Short possuiMultaFgts = 0;
    private Short pedidoDemissao = 0;
    private String codigoMovimentacao;
    private String codigoSaqueFgts;
    private List<EmpresaTipoRescisao> empresas = new ArrayList<EmpresaTipoRescisao>();
    private Short filtrarEmpresa = 0;
    private String descricao;
    private Short comumAcordo = 0;
    private EsocMotivoDesligamento esocMotivoDesligamento;

    public CadastroRecisao() {
        this.eventos = new ArrayList<TipoCalculoEvento>();
    }

    @Id
    @Column(nullable=false, unique=true, name="ID_CADASTRO_RECISAO")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_CADASTRO_RECISAO")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @OneToMany(fetch=FetchType.LAZY, targetEntity=TipoCalculoEvento.class)
    @JoinTable(name="TIPO_RECISAO_EVENTOS", joinColumns={@JoinColumn(name="ID_CADASTRO_RECISAO")}, inverseJoinColumns={@JoinColumn(name="ID_TIPO_CALCULO_EVENTO")})
    public List<TipoCalculoEvento> getEventos() {
        return this.eventos;
    }

    public void setEventos(List<TipoCalculoEvento> eventos) {
        this.eventos = eventos;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0} - {1}", (Object[])new Object[]{this.getRecisao() != null ? this.getRecisao().getCodigo() : "", this.getRecisao() != null ? this.getRecisao().getDescricao() : ""});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_TIPO_RECISAO", foreignKey=@ForeignKey(name="FK_CADASTRO_RECISAO_TIPO"))
    public TipoRecisaoContratual getRecisao() {
        return this.recisao;
    }

    public void setRecisao(TipoRecisaoContratual recisao) {
        this.recisao = recisao;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_DESLIGAMENTO_CAGED", foreignKey=@ForeignKey(name="FK_CADASTRO_RECISAO_DESL_CAGED"))
    public DesligamentoCaged getDesligamentoCaged() {
        return this.desligamentoCaged;
    }

    public void setDesligamentoCaged(DesligamentoCaged desligamentoCaged) {
        this.desligamentoCaged = desligamentoCaged;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_MOVIMENTO_SEFIP", foreignKey=@ForeignKey(name="FK_CADASTRO_RECISAO_SEFIP"))
    public MovimentoSefip getMovimentoSefip() {
        return this.movimentoSefip;
    }

    public void setMovimentoSefip(MovimentoSefip movimentoSefip) {
        this.movimentoSefip = movimentoSefip;
    }

    @Column(name="FGTS_RECOLHIDO_GRRF")
    public Short getFgtsRecolhidoGrrf() {
        return this.FgtsRecolhidoGrrf;
    }

    public void setFgtsRecolhidoGrrf(Short FgtsRecolhidoGrrf) {
        this.FgtsRecolhidoGrrf = FgtsRecolhidoGrrf;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_DESLIGAMENTO_RAIS", foreignKey=@ForeignKey(name="FK_CADASTRO_RECISAO_DESL_RAIS"))
    public DesligamentoRais getDesligamentoRais() {
        return this.desligamentoRais;
    }

    public void setDesligamentoRais(DesligamentoRais desligamentoRais) {
        this.desligamentoRais = desligamentoRais;
    }

    @Column(name="POSSUI_MULTA_FGTS")
    public Short getPossuiMultaFgts() {
        return this.possuiMultaFgts;
    }

    public void setPossuiMultaFgts(Short possuiMultaFgts) {
        this.possuiMultaFgts = possuiMultaFgts;
    }

    @Column(name="PEDIDO_DEMISSAO")
    public Short getPedidoDemissao() {
        return this.pedidoDemissao;
    }

    public void setPedidoDemissao(Short pedidoDemissao) {
        this.pedidoDemissao = pedidoDemissao;
    }

    @Column(name="CODIGO_MOVIMENTACAO", length=2)
    public String getCodigoMovimentacao() {
        return this.codigoMovimentacao;
    }

    public void setCodigoMovimentacao(String codigoMovimentacao) {
        this.codigoMovimentacao = codigoMovimentacao;
    }

    @Column(name="CODIGO_SAQUE_FGTS", length=5)
    public String getCodigoSaqueFgts() {
        return this.codigoSaqueFgts;
    }

    public void setCodigoSaqueFgts(String codigoSaqueFgts) {
        this.codigoSaqueFgts = codigoSaqueFgts;
    }

    @OneToMany(fetch=FetchType.LAZY, mappedBy="cadastroRescisao", cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH, CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.DELETE_ORPHAN, org.hibernate.annotations.CascadeType.ALL})
    public List<EmpresaTipoRescisao> getEmpresas() {
        return this.empresas;
    }

    public void setEmpresas(List<EmpresaTipoRescisao> empresas) {
        this.empresas = empresas;
    }

    @Column(name="FILTRAR_EMPRESA")
    public Short getFiltrarEmpresa() {
        return this.filtrarEmpresa;
    }

    public void setFiltrarEmpresa(Short filtarEmpresa) {
        this.filtrarEmpresa = filtarEmpresa;
    }

    @Column(name="DESCRICAO", length=100)
    public String getDescricao() {
        return this.descricao;
    }

    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    @Column(name="COMUM_ACORDO")
    public Short getComumAcordo() {
        return this.comumAcordo;
    }

    public void setComumAcordo(Short comumAcordo) {
        this.comumAcordo = comumAcordo;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(nullable=false, name="ID_ESOC_MOTIVO_DESLIGAMENTO", foreignKey=@ForeignKey(name="FK_RESCISAO_COLAB_ESOC_MOT"))
    public EsocMotivoDesligamento getEsocMotivoDesligamento() {
        return this.esocMotivoDesligamento;
    }

    public void setEsocMotivoDesligamento(EsocMotivoDesligamento esocMotivoDesligamento) {
        this.esocMotivoDesligamento = esocMotivoDesligamento;
    }
}

