/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.BaixaTituloAntecipado;
import com.touchcomp.basementor.model.vo.CondicoesPagamento;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.Pessoa;
import com.touchcomp.basementor.model.vo.PlanoConta;
import com.touchcomp.basementor.model.vo.PlanoContaGerencial;
import com.touchcomp.basementor.model.vo.Titulo;
import com.touchcomp.basementor.model.vo.Usuario;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Version;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;

@Entity
@Table(name="CANC_ANTEC_TITULOS")
public class CancAntecTitulos
implements InterfaceVO {
    private Long identificador;
    private Date dataCadastro;
    private Timestamp dataAtualizacao;
    private Empresa empresa;
    private Usuario usuario;
    private List<BaixaTituloAntecipado> baixaTitAntCanc = new ArrayList<BaixaTituloAntecipado>();
    private List<Titulo> titulosDevolver = new ArrayList<Titulo>();
    private CondicoesPagamento condicaoPagamento;
    private String observacao;
    private Date dataDevolucao;
    private Short pagRec = 0;
    private Pessoa pessoa;
    private String parcelas;
    private PlanoConta planoContaDest;
    private PlanoContaGerencial planoContaGer;

    @Id
    @Column(nullable=false, unique=true, name="ID_CANC_ANTEC_TITULOS")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_CANC_ANTEC_TITULOS")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @Column(nullable=false, name="DATA_CADASTRO")
    @Temporal(value=TemporalType.DATE)
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @Version
    @Column(name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(nullable=false, name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_CANC_ANTEC_TIT_EMPRESA"))
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(nullable=false, name="ID_USUARIO", foreignKey=@ForeignKey(name="FK_CANC_ANTEC_TIT_USUARIO"))
    public Usuario getUsuario() {
        return this.usuario;
    }

    public void setUsuario(Usuario usuario) {
        this.usuario = usuario;
    }

    @OneToMany(mappedBy="cancAntecTitulos")
    @Cascade(value={CascadeType.ALL, CascadeType.DELETE_ORPHAN})
    public List<BaixaTituloAntecipado> getBaixaTituloAntCanc() {
        return this.baixaTitAntCanc;
    }

    public void setBaixaTituloAntCanc(List<BaixaTituloAntecipado> baixaTitAntCanc) {
        this.baixaTitAntCanc = baixaTitAntCanc;
    }

    @OneToMany(mappedBy="cancAntecTitulos")
    @Cascade(value={CascadeType.ALL, CascadeType.DELETE_ORPHAN})
    public List<Titulo> getTitulosDevolver() {
        return this.titulosDevolver;
    }

    public void setTitulosDevolver(List<Titulo> titulosDevolver) {
        this.titulosDevolver = titulosDevolver;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(nullable=false, name="ID_CONDICOES_PAGAMENTO", foreignKey=@ForeignKey(name="FK_CANC_ANTEC_TIT_COND_PAG"))
    public CondicoesPagamento getCondicaoPagamento() {
        return this.condicaoPagamento;
    }

    public void setCondicaoPagamento(CondicoesPagamento condicaoPagamento) {
        this.condicaoPagamento = condicaoPagamento;
    }

    @Column(name="OBSERVACAO", length=1000)
    public String getObservacao() {
        return this.observacao;
    }

    public void setObservacao(String observacao) {
        this.observacao = observacao;
    }

    @Column(nullable=false, name="DATA_DEVOLUCAO")
    @Temporal(value=TemporalType.DATE)
    public Date getDataDevolucao() {
        return this.dataDevolucao;
    }

    public void setDataDevolucao(Date dataDevolucao) {
        this.dataDevolucao = dataDevolucao;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0} - {1}", (Object[])new Object[]{this.getIdentificador(), this.getObservacao()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @Column(nullable=false, name="PAG_REC")
    public Short getPagRec() {
        return this.pagRec;
    }

    public void setPagRec(Short pagRec) {
        this.pagRec = pagRec;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(nullable=false, name="ID_PESSOA", foreignKey=@ForeignKey(name="FK_CANC_ANTEC_TIT_PESSOA"))
    public Pessoa getPessoa() {
        return this.pessoa;
    }

    public void setPessoa(Pessoa pessoa) {
        this.pessoa = pessoa;
    }

    @Column(name="PARCELAS", length=200)
    public String getParcelas() {
        return this.parcelas;
    }

    public void setParcelas(String parcelas) {
        this.parcelas = parcelas;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(nullable=false, name="ID_PC_CONTABIL", foreignKey=@ForeignKey(name="FK_CANC_ANTEC_TIT_PC_CONT"))
    public PlanoConta getPlanoContaDest() {
        return this.planoContaDest;
    }

    public void setPlanoContaDest(PlanoConta planoContaDest) {
        this.planoContaDest = planoContaDest;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(nullable=false, name="ID_PC_GERENCIAL", foreignKey=@ForeignKey(name="FK_CANC_ANTEC_TIT_PC_GER"))
    public PlanoContaGerencial getPlanoContaGer() {
        return this.planoContaGer;
    }

    public void setPlanoContaGer(PlanoContaGerencial planoContaGer) {
        this.planoContaGer = planoContaGer;
    }
}

