/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.BusinessIntelligence;
import com.touchcomp.basementor.model.vo.ContaValores;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.InstituicaoValores;
import com.touchcomp.basementor.model.vo.PlanoConta;
import com.touchcomp.basementor.model.vo.SituacaoCobranca;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.UniqueConstraint;
import javax.persistence.Version;
import org.hibernate.annotations.Generated;
import org.hibernate.annotations.GenerationTime;

@Entity
@Table(name="CARTEIRA_COBRANCA", uniqueConstraints={@UniqueConstraint(name="UNQ1_CARTEIRA_COBRANCA_NOME", columnNames={"NOME"})})
public class CarteiraCobranca
implements InterfaceVO {
    private Long identificador;
    private String nome;
    private String codigoCarteira;
    private Short diasCompensacao;
    private Short diasToleranciaVencimento;
    private ContaValores contaValor;
    private SituacaoCobranca situacaoCobranca;
    private PlanoConta planoConta;
    private Double vrLimite;
    private Date dataVencContrato;
    private Empresa empresa;
    private Date dataCadastro;
    private Short ativo;
    private Timestamp dataAtualizacao;
    private String instrucaoBoleto1;
    private String instrucaoBoleto2;
    private String instrucaoBoleto3;
    private String instrucaoBoleto4;
    private String localPagamento;
    private String nossoNumeroInicial;
    private String variacaoCarteira;
    private Date dataInNossoNumero;
    private Short pagamentoCnab;
    private BusinessIntelligence biVincCarteiraCobranca;
    private BusinessIntelligence biVincCartCobEnvioMassa;
    private InstituicaoValores instValorRespEmissaoBoleto;
    private Short enviarBoletoJuntoNFe;
    private Short usarAgenciaValorBeneficiario;

    public CarteiraCobranca() {
        this.vrLimite = 0.0;
        this.diasCompensacao = 0;
        this.diasToleranciaVencimento = 0;
        this.ativo = 1;
        this.nossoNumeroInicial = "1";
        this.pagamentoCnab = 0;
        this.enviarBoletoJuntoNFe = 1;
        this.usarAgenciaValorBeneficiario = 0;
    }

    public CarteiraCobranca(Long identificador, String nome, String situacao, String nomeBanco) {
        this.situacaoCobranca = new SituacaoCobranca();
        this.setIdentificador(identificador);
        this.setNome(nome);
        this.situacaoCobranca.setNome(situacao);
    }

    @Id
    @Column(name="ID_CARTEIRA_COBRANCA")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_CARTEIRA_COBRANCA")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long idCateira) {
        this.identificador = idCateira;
    }

    @Column(unique=true, name="NOME", length=40)
    public String getNome() {
        return this.nome;
    }

    public void setNome(String nome) {
        this.nome = nome;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_CONTA_VALOR", foreignKey=@ForeignKey(name="FK_CARTEIRA_COBRANCA_CON_VALORE"))
    public ContaValores getContaValor() {
        return this.contaValor;
    }

    public void setContaValor(ContaValores contaValor) {
        this.contaValor = contaValor;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_SITUACAO_COBRANCA", foreignKey=@ForeignKey(name="FK_CARTEIRA_COBRANCA_SITUACAO_C"))
    public SituacaoCobranca getSituacaoCobranca() {
        return this.situacaoCobranca;
    }

    public void setSituacaoCobranca(SituacaoCobranca sitFinanceira) {
        this.situacaoCobranca = sitFinanceira;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_PLANO_CONTA", foreignKey=@ForeignKey(name="FK_CARTEIRA_COBRANCA_PLANO_CONT"))
    public PlanoConta getPlanoConta() {
        return this.planoConta;
    }

    public void setPlanoConta(PlanoConta conta) {
        this.planoConta = conta;
    }

    @Column(nullable=true, name="VR_LIMITE", precision=12, scale=2)
    public Double getVrLimite() {
        return this.vrLimite;
    }

    public void setVrLimite(Double limite) {
        this.vrLimite = limite;
    }

    @Column(nullable=true, name="DATA_VENCIMENTO_CONTRATO")
    @Temporal(value=TemporalType.DATE)
    public Date getDataCadastroVencContrato() {
        return this.dataVencContrato;
    }

    public void setDataCadastroVencContrato(Date data) {
        this.dataVencContrato = data;
    }

    @Column(name="DATA_CADASTRO")
    @Temporal(value=TemporalType.DATE)
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_CARTEIRA_COBRANCA_EMPRESA"))
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0} - {1}", (Object[])new Object[]{this.getIdentificador(), this.getNome()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @Column(name="ATIVO")
    public Short getAtivo() {
        return this.ativo;
    }

    public void setAtivo(Short ativo) {
        this.ativo = ativo;
    }

    @Version
    @Generated(value=GenerationTime.ALWAYS)
    @Column(nullable=false, updatable=false, insertable=false, name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @Column(name="DIAS_CONPENSACAO")
    public Short getDiasCompensacao() {
        return this.diasCompensacao;
    }

    public void setDiasCompensacao(Short diasCompensacao) {
        this.diasCompensacao = diasCompensacao;
    }

    @Column(name="DIAS_TOLERANCIA_VENC")
    public Short getDiasToleranciaVencimento() {
        return this.diasToleranciaVencimento;
    }

    public void setDiasToleranciaVencimento(Short diasToleranciaVencimento) {
        this.diasToleranciaVencimento = diasToleranciaVencimento;
    }

    @Column(name="CODIGO_CARTEIRA", length=5)
    public String getCodigoCarteira() {
        return this.codigoCarteira;
    }

    public void setCodigoCarteira(String codigoCarteira) {
        this.codigoCarteira = codigoCarteira;
    }

    @Column(name="INSTRUCAO_BOLETO1", length=100)
    public String getInstrucaoBoleto1() {
        return this.instrucaoBoleto1;
    }

    public void setInstrucaoBoleto1(String instrucaoBoleto1) {
        this.instrucaoBoleto1 = instrucaoBoleto1;
    }

    @Column(name="INSTRUCAO_BOLETO2", length=100)
    public String getInstrucaoBoleto2() {
        return this.instrucaoBoleto2;
    }

    public void setInstrucaoBoleto2(String instrucaoBoleto2) {
        this.instrucaoBoleto2 = instrucaoBoleto2;
    }

    @Column(name="INSTRUCAO_BOLETO3", length=100)
    public String getInstrucaoBoleto3() {
        return this.instrucaoBoleto3;
    }

    public void setInstrucaoBoleto3(String instrucaoBoleto3) {
        this.instrucaoBoleto3 = instrucaoBoleto3;
    }

    @Column(name="INSTRUCAO_BOLETO4", length=100)
    public String getInstrucaoBoleto4() {
        return this.instrucaoBoleto4;
    }

    public void setInstrucaoBoleto4(String instrucaoBoleto4) {
        this.instrucaoBoleto4 = instrucaoBoleto4;
    }

    @Column(name="LOCAL_PAGAMENTO", length=100)
    public String getLocalPagamento() {
        return this.localPagamento;
    }

    public void setLocalPagamento(String localPagamento) {
        this.localPagamento = localPagamento;
    }

    @Column(name="NOSSO_NUMERO_INICIAL", length=50)
    public String getNossoNumeroInicial() {
        return this.nossoNumeroInicial;
    }

    public void setNossoNumeroInicial(String nossoNumeroInicial) {
        this.nossoNumeroInicial = nossoNumeroInicial;
    }

    @Column(name="DATA_IN_NOSSO_NUMERO")
    @Temporal(value=TemporalType.DATE)
    public Date getDataInNossoNumero() {
        return this.dataInNossoNumero;
    }

    public void setDataInNossoNumero(Date dataInNossoNumero) {
        this.dataInNossoNumero = dataInNossoNumero;
    }

    @Column(name="VARIACAO_CARTEIRA", length=5)
    public String getVariacaoCarteira() {
        return this.variacaoCarteira;
    }

    public void setVariacaoCarteira(String variacaoCarteira) {
        this.variacaoCarteira = variacaoCarteira;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_BI_VINC_COBR", foreignKey=@ForeignKey(name="FK_CARTEIRA_COBRANCA_BI"))
    public BusinessIntelligence getBiVincCarteiraCobranca() {
        return this.biVincCarteiraCobranca;
    }

    public void setBiVincCarteiraCobranca(BusinessIntelligence biVincCarteiraCobranca) {
        this.biVincCarteiraCobranca = biVincCarteiraCobranca;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_BI_VINC_COBR_ENVIO_MASSA", foreignKey=@ForeignKey(name="FK_CART_COB_BI_VINC_ENVIO_MASSA"))
    public BusinessIntelligence getBiVincCartCobEnvioMassa() {
        return this.biVincCartCobEnvioMassa;
    }

    public void setBiVincCartCobEnvioMassa(BusinessIntelligence biVincCartCobEnvioMassa) {
        this.biVincCartCobEnvioMassa = biVincCartCobEnvioMassa;
    }

    @Column(name="PAGAMENTO_CNAB")
    public Short getPagamentoCnab() {
        return this.pagamentoCnab;
    }

    public void setPagamentoCnab(Short pagamentoCnab) {
        this.pagamentoCnab = pagamentoCnab;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_INST_VALOR_RESP_EMISSAO_BOL", foreignKey=@ForeignKey(name="FK_CART_COB_INST_VALOR_RESP_EMI"))
    public InstituicaoValores getInstValorRespEmissaoBoleto() {
        return this.instValorRespEmissaoBoleto;
    }

    public void setInstValorRespEmissaoBoleto(InstituicaoValores instValorRespEmissaoBoleto) {
        this.instValorRespEmissaoBoleto = instValorRespEmissaoBoleto;
    }

    @Column(name="ENVIAR_BOLETO_JUNTO_NFE")
    public Short getEnviarBoletoJuntoNFe() {
        return this.enviarBoletoJuntoNFe;
    }

    public void setEnviarBoletoJuntoNFe(Short enviarBoletoJuntoNFe) {
        this.enviarBoletoJuntoNFe = enviarBoletoJuntoNFe;
    }

    @Column(name="USAR_AGENCIA_VALOR_BENEFICIARIO")
    public Short getUsarAgenciaValorBeneficiario() {
        return this.usarAgenciaValorBeneficiario;
    }

    public void setUsarAgenciaValorBeneficiario(Short usarAgenciaValorBeneficiario) {
        this.usarAgenciaValorBeneficiario = usarAgenciaValorBeneficiario;
    }
}

