/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.constants.ConstantsTipoCobrancaApuracao;
import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.Cliente;
import com.touchcomp.basementor.model.vo.LogDadosFinanceirosCliente;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import com.touchcomp.basementortools.tools.vo.equals.IdProperty;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Version;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.Generated;
import org.hibernate.annotations.GenerationTime;

@Entity
@Table(name="CLIENTE_FINANCEIRO")
@IdProperty(name="idCliente")
public class ClienteFinanceiro
implements InterfaceVO {
    private Long idCliente;
    private Integer habilParaCompra = 0;
    private Double limiteCredito = 0.0;
    private Double limiteCreditoFinanceiro = 0.0;
    private Date dataLiberacaoCredito;
    private Integer diasVigorLimiteCred = 0;
    private String observacao;
    private Cliente cliente;
    private Timestamp dataAtualizacao;
    private Short naoAvaliarFinanceiro = 0;
    private List<LogDadosFinanceirosCliente> logDadosFinanceiros = new ArrayList<LogDadosFinanceirosCliente>();
    private Short tipoCobrancaApuracao = ConstantsTipoCobrancaApuracao.NAO_GERAR_TITULO;
    private Short tipoCobrancaApuracaoCredor = ConstantsTipoCobrancaApuracao.GERAR_ARQUIVO_X8;

    @OneToOne(mappedBy="financeiro", fetch=FetchType.LAZY)
    public Cliente getCliente() {
        return this.cliente;
    }

    @Id
    @Column(name="ID_CLIENTE_FINANCEIRO")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_CLIENTE_FINANCEIRO")
    public Long getIdCliente() {
        return this.idCliente;
    }

    @Column(nullable=false, name="HABIL_PARA_COMPRA")
    public Integer getHabilParaCompra() {
        return this.habilParaCompra;
    }

    @Column(name="LIMITE_CREDITO", precision=12, scale=2)
    public Double getLimiteCredito() {
        return this.limiteCredito;
    }

    @Column(name="DATA_LIBERACAO_CREDITO")
    @Temporal(value=TemporalType.DATE)
    public Date getDataLiberacaoCredito() {
        return this.dataLiberacaoCredito;
    }

    @Column(name="DIAS_VIGOR_LIMITE_CRED")
    public Integer getDiasVigorLimiteCred() {
        return this.diasVigorLimiteCred;
    }

    @Column(name="OBSERVACAO", length=500)
    public String getObservacao() {
        return this.observacao;
    }

    public void setIdCliente(Long idCliente) {
        this.idCliente = idCliente;
    }

    public void setHabilParaCompra(Integer habilParaCompra) {
        this.habilParaCompra = habilParaCompra;
    }

    public void setLimiteCredito(Double limiteCredito) {
        this.limiteCredito = limiteCredito;
    }

    public void setDataLiberacaoCredito(Date dataLiberacaoCredito) {
        this.dataLiberacaoCredito = dataLiberacaoCredito;
    }

    public void setDiasVigorLimiteCred(Integer diasVigorLimiteCred) {
        this.diasVigorLimiteCred = diasVigorLimiteCred;
    }

    public void setCliente(Cliente cliente) {
        this.cliente = cliente;
    }

    public void setObservacao(String observacao) {
        this.observacao = observacao;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getIdCliente()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdCliente());
    }

    @Version
    @Generated(value=GenerationTime.ALWAYS)
    @Column(nullable=false, updatable=false, insertable=false, name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @Column(name="NAO_AVALIAR_FINANCEIRO")
    public Short getNaoAvaliarFinanceiro() {
        return this.naoAvaliarFinanceiro;
    }

    public void setNaoAvaliarFinanceiro(Short naoAvaliarFinanceiro) {
        this.naoAvaliarFinanceiro = naoAvaliarFinanceiro;
    }

    @Column(name="LIMITE_CREDITO_FINANCEIRO", precision=15, scale=2)
    public Double getLimiteCreditoFinanceiro() {
        return this.limiteCreditoFinanceiro;
    }

    public void setLimiteCreditoFinanceiro(Double limiteCreditoFinanceiro) {
        this.limiteCreditoFinanceiro = limiteCreditoFinanceiro;
    }

    @OneToMany(mappedBy="clienteFinanceiro", fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN, org.hibernate.annotations.CascadeType.ALL})
    public List<LogDadosFinanceirosCliente> getLogDadosFinanceiros() {
        return this.logDadosFinanceiros;
    }

    public void setLogDadosFinanceiros(List<LogDadosFinanceirosCliente> logDadosFinanceiros) {
        this.logDadosFinanceiros = logDadosFinanceiros;
    }

    @Column(name="TIPO_COBRANCA_APURACAO")
    public Short getTipoCobrancaApuracao() {
        return this.tipoCobrancaApuracao;
    }

    public void setTipoCobrancaApuracao(Short tipoCobrancaApuracao) {
        this.tipoCobrancaApuracao = tipoCobrancaApuracao;
    }

    @Column(name="TIPO_COBRANCA_APURACAO_CREDOR")
    public Short getTipoCobrancaApuracaoCredor() {
        return this.tipoCobrancaApuracaoCredor;
    }

    public void setTipoCobrancaApuracaoCredor(Short tipoCobrancaApuracaoCredor) {
        this.tipoCobrancaApuracaoCredor = tipoCobrancaApuracaoCredor;
    }
}

