/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.constants.enums.componentefrete.EnumConstComponenteFreteTipoComponente;
import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.UniqueConstraint;
import javax.persistence.Version;

@Entity
@Table(name="COMPONENTE_FRETE", uniqueConstraints={@UniqueConstraint(name="UNQ1_COMPONENTE_FRETE_DESCRICAO", columnNames={"DESCRICAO"})})
public class ComponenteFrete
implements InterfaceVO {
    private Long identificador;
    private String descricao;
    private Date dataCadastro;
    private Timestamp dataAtualizacao;
    private Short informarManualmente = 0;
    private Short calcularImposto = 1;
    private Short ativo = 1;
    private Short tipoComponente = EnumConstComponenteFreteTipoComponente.OUTROS.getEnumId();

    @Id
    @Column(nullable=false, name="ID_COMPONENTE_FRETE")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_COMPONENTE_FRETE")
    public Long getIdentificador() {
        return this.identificador;
    }

    @Version
    @Column(name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    @Column(name="DATA_CADASTRO")
    @Temporal(value=TemporalType.DATE)
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    @Column(nullable=false, name="DESCRICAO", length=60)
    public String getDescricao() {
        return this.descricao;
    }

    @Column(name="INFORMAR_MANUALMENTE")
    public Short getInformarManualmente() {
        return this.informarManualmente;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    public void setInformarManualmente(Short informarManualmente) {
        this.informarManualmente = informarManualmente;
    }

    @Column(name="CALCULAR_IMPOSTO")
    public Short getCalcularImposto() {
        return this.calcularImposto;
    }

    public void setCalcularImposto(Short calcularImposto) {
        this.calcularImposto = calcularImposto;
    }

    @Column(name="ATIVO")
    public Short getAtivo() {
        return this.ativo;
    }

    public void setAtivo(Short ativo) {
        this.ativo = ativo;
    }

    @Column(name="TIPO_COMPONENTE")
    public Short getTipoComponente() {
        return this.tipoComponente;
    }

    public void setTipoComponente(Short tipoComponente) {
        this.tipoComponente = tipoComponente;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getDescricao()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }
}

