/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.ComponenteFrete;
import com.touchcomp.basementor.model.vo.ConfigImpCteXMLCompFrete;
import com.touchcomp.basementor.model.vo.ConfigImpCteXMLPercDesc;
import com.touchcomp.basementor.model.vo.ConfigImpCteXMLPlaca;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.UnidadeFatCliente;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;

@Entity
@Table(name="CONFIGURACAO_IMP_CTE_XML")
public class ConfiguracaoImpCteXML
implements InterfaceVO {
    private Long identificador;
    private List<ConfigImpCteXMLCompFrete> componentesFrete = new ArrayList<ConfigImpCteXMLCompFrete>();
    private List<ConfigImpCteXMLPlaca> placas = new ArrayList<ConfigImpCteXMLPlaca>();
    private List<ConfigImpCteXMLPercDesc> percDesc = new ArrayList<ConfigImpCteXMLPercDesc>();
    private Short modoArredondamento = 0;
    private Short arredondarCadaOperacao = 0;
    private Date dataCadastro;
    private String descricao;
    private Empresa empresa;
    private ComponenteFrete compFrete;
    private List<UnidadeFatCliente> tomadores = new ArrayList<UnidadeFatCliente>();

    @Id
    @Column(nullable=false, name="ID_CONFIGURACAO_IMP_CTE_XML")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_CONFIGURACAO_IMP_CTE_XML")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @OneToMany(mappedBy="confImpCteXML")
    @Cascade(value={CascadeType.ALL, CascadeType.DELETE_ORPHAN})
    public List<ConfigImpCteXMLCompFrete> getComponentesFrete() {
        return this.componentesFrete;
    }

    public void setComponentesFrete(List<ConfigImpCteXMLCompFrete> componentesFrete) {
        this.componentesFrete = componentesFrete;
    }

    @OneToMany(mappedBy="confImpCteXML")
    @Cascade(value={CascadeType.ALL, CascadeType.DELETE_ORPHAN})
    public List<ConfigImpCteXMLPlaca> getPlacas() {
        return this.placas;
    }

    public void setPlacas(List<ConfigImpCteXMLPlaca> placas) {
        this.placas = placas;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_CADASTRO")
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_CONFIG_IMP_CTE_XML_EMP"))
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0} - {1}", (Object[])new Object[]{this.getCompFrete(), this.getPlacas()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @JoinColumn(name="ID_COMP_FRETE", foreignKey=@ForeignKey(name="FK_CONFIG_IMP_CTE_XML_COMP_FRET"))
    @ManyToOne(fetch=FetchType.LAZY)
    public ComponenteFrete getCompFrete() {
        return this.compFrete;
    }

    public void setCompFrete(ComponenteFrete compFrete) {
        this.compFrete = compFrete;
    }

    @OneToMany
    @JoinTable(name="conf_imp_cte_xml_unid_fat", joinColumns={@JoinColumn(name="id_configuracao_imp_ctexml")}, inverseJoinColumns={@JoinColumn(name="id_unidade_fat_cliente")})
    public List<UnidadeFatCliente> getTomadores() {
        return this.tomadores;
    }

    public void setTomadores(List<UnidadeFatCliente> tomadores) {
        this.tomadores = tomadores;
    }

    @Column(name="DESCRICAO", length=100)
    public String getDescricao() {
        return this.descricao;
    }

    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    @OneToMany(mappedBy="confImpCteXML")
    @Cascade(value={CascadeType.ALL, CascadeType.DELETE_ORPHAN})
    public List<ConfigImpCteXMLPercDesc> getPercDesc() {
        return this.percDesc;
    }

    public void setPercDesc(List<ConfigImpCteXMLPercDesc> percDesc) {
        this.percDesc = percDesc;
    }

    @Column(name="MODO_ARREDONDAMENTO")
    public Short getModoArredondamento() {
        return this.modoArredondamento;
    }

    public void setModoArredondamento(Short modoArredondamento) {
        this.modoArredondamento = modoArredondamento;
    }

    @Column(name="ARREDONDAR_CADA_OPERACAO")
    public Short getArredondarCadaOperacao() {
        return this.arredondarCadaOperacao;
    }

    public void setArredondarCadaOperacao(Short arredondarCadaOperacao) {
        this.arredondarCadaOperacao = arredondarCadaOperacao;
    }
}

