/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.CentroCusto;
import com.touchcomp.basementor.model.vo.ContratoLocacaoSindicato;
import com.touchcomp.basementor.model.vo.Funcao;
import com.touchcomp.basementor.model.vo.ItemContratoLocacao;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;

@Entity
@Table(name="CONTRATO_LOCACAO_FUNCAO")
public class ContratoLocacaoFuncao
implements InterfaceVO {
    private Long identificador;
    private Double valorTotal = 0.0;
    private Date dataInicial;
    private Date dataFinal;
    private Short statusAtivo = 1;
    private ItemContratoLocacao itemContratoLocacao;
    private Integer quantidade = 0;
    private Funcao funcao;
    private String descricao;
    private Double valorUnitario = 0.0;
    private List<ContratoLocacaoSindicato> sindicatos = new ArrayList<ContratoLocacaoSindicato>();
    private CentroCusto centroCusto;
    private Double valorCusto = 0.0;

    @Id
    @Column(nullable=false, name="ID_CONTRATO_LOCACAO_FUNCAO")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_CONTRATO_LOCACAO_FUNCAO")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @Column(nullable=false, name="VALOR_TOTAL", precision=15, scale=6)
    public Double getValorTotal() {
        return this.valorTotal;
    }

    public void setValorTotal(Double valorTotal) {
        this.valorTotal = valorTotal;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_INICIAL")
    public Date getDataInicial() {
        return this.dataInicial;
    }

    public void setDataInicial(Date dataInicial) {
        this.dataInicial = dataInicial;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_FINAL")
    public Date getDataFinal() {
        return this.dataFinal;
    }

    public void setDataFinal(Date dataFinal) {
        this.dataFinal = dataFinal;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getIdentificador()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @Column(name="STATUS_ATIVO")
    public Short getStatusAtivo() {
        return this.statusAtivo;
    }

    public void setStatusAtivo(Short statusAtivo) {
        this.statusAtivo = statusAtivo;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_ITEM_CONTRATO_LOCACAO", foreignKey=@ForeignKey(name="FK_CONTRATO_LOC_FUNC_ITEM_CONTR"))
    public ItemContratoLocacao getItemContratoLocacao() {
        return this.itemContratoLocacao;
    }

    public void setItemContratoLocacao(ItemContratoLocacao itemContratoLocacao) {
        this.itemContratoLocacao = itemContratoLocacao;
    }

    @Column(nullable=false, name="QUANTIDADE")
    public Integer getQuantidade() {
        return this.quantidade;
    }

    public void setQuantidade(Integer quantidade) {
        this.quantidade = quantidade;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_FUNCAO", foreignKey=@ForeignKey(name="FK_CONTRATO_LOC_FUNCAO_FUNCAO"))
    public Funcao getFuncao() {
        return this.funcao;
    }

    public void setFuncao(Funcao funcao) {
        this.funcao = funcao;
    }

    @Column(name="DESCRICAO", length=100)
    public String getDescricao() {
        return this.descricao;
    }

    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    @Column(nullable=false, name="VALOR_UNITARIO", precision=15, scale=6)
    public Double getValorUnitario() {
        return this.valorUnitario;
    }

    public void setValorUnitario(Double valorUnitario) {
        this.valorUnitario = valorUnitario;
    }

    @OneToMany(mappedBy="contratoLocacaoFuncao")
    @Cascade(value={CascadeType.DELETE_ORPHAN, CascadeType.ALL})
    public List<ContratoLocacaoSindicato> getSindicatos() {
        return this.sindicatos;
    }

    public void setSindicatos(List<ContratoLocacaoSindicato> sindicatos) {
        this.sindicatos = sindicatos;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_CENTRO_CUSTO", foreignKey=@ForeignKey(name="FK_CONTRATO_LOC_FUNCAO_CC"))
    public CentroCusto getCentroCusto() {
        return this.centroCusto;
    }

    public void setCentroCusto(CentroCusto centroCusto) {
        this.centroCusto = centroCusto;
    }

    @Column(nullable=false, name="VALOR_CUSTO", precision=15, scale=6)
    public Double getValorCusto() {
        return this.valorCusto;
    }

    public void setValorCusto(Double valorCusto) {
        this.valorCusto = valorCusto;
    }
}

