/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.Pessoa;
import com.touchcomp.basementor.model.vo.TipoApontamentoKM;
import com.touchcomp.basementor.model.vo.Veiculo;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Version;

@Entity
@Table(name="CONTROLE_DESLOCAMENTO_VEIC")
public class ControleDeslocamentoVeicular
implements InterfaceVO {
    private Long identificador;
    private Date dataCadastro;
    private Veiculo veiculo;
    private Pessoa pessoa;
    private Date dataDeslocamento;
    private Double kmInicial = 0.0;
    private Double kmFinal = 0.0;
    private String observacao;
    private TipoApontamentoKM tipoApontamentoKM;
    private Timestamp dataAtualizacao;

    @Id
    @Column(nullable=false, name="ID_CONTROLE_DESLOCAMENTO_VEIC")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_CONTROLE_DESLOCAMENTO_VEIC")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_CADASTRO")
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_VEICULO", foreignKey=@ForeignKey(name="FK_CONTROLE_DESLOC_VEIC_VEICULO"))
    public Veiculo getVeiculo() {
        return this.veiculo;
    }

    public void setVeiculo(Veiculo veiculo) {
        this.veiculo = veiculo;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_PESSOA", foreignKey=@ForeignKey(name="FK_CONTROLE_DESLOC_VEIC_PESSOA"))
    public Pessoa getPessoa() {
        return this.pessoa;
    }

    public void setPessoa(Pessoa pessoa) {
        this.pessoa = pessoa;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_DESLOCAMENTO")
    public Date getDataDeslocamento() {
        return this.dataDeslocamento;
    }

    public void setDataDeslocamento(Date dataDeslocamento) {
        this.dataDeslocamento = dataDeslocamento;
    }

    @Column(name="KM_INICIAL", precision=15, scale=2)
    public Double getKmInicial() {
        return this.kmInicial;
    }

    public void setKmInicial(Double kmInicial) {
        this.kmInicial = kmInicial;
    }

    @Column(nullable=false, name="KM_FINAL", precision=15, scale=2)
    public Double getKmFinal() {
        return this.kmFinal;
    }

    public void setKmFinal(Double kmFinal) {
        this.kmFinal = kmFinal;
    }

    @Column(name="OBSERVACAO", length=1000)
    public String getObservacao() {
        return this.observacao;
    }

    public void setObservacao(String observacao) {
        this.observacao = observacao;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_TIPO_APONTAMENTO_KM", foreignKey=@ForeignKey(name="FK_CONTROLE_DESLOC_VEIC_TP_APON"))
    public TipoApontamentoKM getTipoApontamentoKM() {
        return this.tipoApontamentoKM;
    }

    public void setTipoApontamentoKM(TipoApontamentoKM tipoApontamentoKM) {
        this.tipoApontamentoKM = tipoApontamentoKM;
    }

    @Version
    @Column(name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getIdentificador()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }
}

