/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.IndicadorEstoqueSped;
import com.touchcomp.basementor.model.vo.Pessoa;
import com.touchcomp.basementor.model.vo.Produto;
import com.touchcomp.basementor.model.vo.SpedFiscal;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;

@Entity
@Table(name="CORRECAO_ESTOQUE_SPED")
public class CorrecaoEstoqueSped
implements InterfaceVO {
    private Long identificador;
    private Produto produto;
    private Double qtdDiferenca = 0.0;
    private Short informadoManual = 0;
    private Pessoa parceiro;
    private SpedFiscal spedFiscal;
    private IndicadorEstoqueSped indicadorEstoqueSped;

    @Id
    @Column(name="ID_CORRECAO_ESTOQUE_SPED")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_CORRECAO_ESTOQUE_SPED")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_PRODUTO", foreignKey=@ForeignKey(name="FK_CORRECAO_EST_SPED_PRODUTO"))
    public Produto getProduto() {
        return this.produto;
    }

    public void setProduto(Produto produto) {
        this.produto = produto;
    }

    @Column(name="QTD_DIFERENCA", precision=15, scale=3)
    public Double getQtdDiferenca() {
        return this.qtdDiferenca;
    }

    public void setQtdDiferenca(Double qtdDiferenca) {
        this.qtdDiferenca = qtdDiferenca;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_PARCEIRO", foreignKey=@ForeignKey(name="FK_CORRECAO_EST_SPED_PARCEIRO"))
    public Pessoa getParceiro() {
        return this.parceiro;
    }

    public void setParceiro(Pessoa parceiro) {
        this.parceiro = parceiro;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}-{1}", (Object[])new Object[]{this.getIndicadorEstoqueSped(), this.getProduto()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_SPED_FISCAL", foreignKey=@ForeignKey(name="FK_CORRECAO_EST_SPED_SPED_FISC"))
    public SpedFiscal getSpedFiscal() {
        return this.spedFiscal;
    }

    public void setSpedFiscal(SpedFiscal spedFiscal) {
        this.spedFiscal = spedFiscal;
    }

    @Column(name="INFORMADO_MANUAL")
    public Short getInformadoManual() {
        return this.informadoManual;
    }

    public void setInformadoManual(Short informadoManual) {
        this.informadoManual = informadoManual;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_INDICADOR_SPED", foreignKey=@ForeignKey(name="FK_CORRECAO_EST_SPED_IND_ESTOQU"))
    public IndicadorEstoqueSped getIndicadorEstoqueSped() {
        return this.indicadorEstoqueSped;
    }

    public void setIndicadorEstoqueSped(IndicadorEstoqueSped indicadorEstoqueSped) {
        this.indicadorEstoqueSped = indicadorEstoqueSped;
    }
}

