/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.EstadoCivil;
import com.touchcomp.basementor.model.vo.Funcao;
import com.touchcomp.basementor.model.vo.GrauInstrucao;
import com.touchcomp.basementor.model.vo.Nacionalidade;
import com.touchcomp.basementor.model.vo.Pessoa;
import com.touchcomp.basementor.model.vo.TipoDeficiencia;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Version;

@Entity
@Table(name="CURRICULO_COLABORADOR")
public class CurriculoColaborador
implements InterfaceVO {
    private Long identificador;
    private Date dataCadastro;
    private Empresa empresa;
    private Pessoa pessoa;
    private Funcao funcao;
    private Timestamp dataAtualizacao;
    private Double pretencaoSalarial = 0.0;
    private Long numeroFilhos = 0L;
    private GrauInstrucao grauInstrucao;
    private EstadoCivil estadoCivil;
    private Nacionalidade nacionalidadeColaborador;
    private TipoDeficiencia tipoDeficiencia;
    private String nomeMae;
    private Short sexo = 0;
    private Short disponibilidadeViagem = 0;
    private Short habilitacao = 0;
    private String cursoTreinamento;
    private String experiencia;
    private String observacoes;
    private String linguas;
    private String empregosAnteriores;

    @Id
    @Column(name="ID_CURRICULO_COLABORADOR")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_CURRICULO_COLABORADOR")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_CADASTRO")
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_CURRICULO_COLAB_EMPRESA"))
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_PESSOA", foreignKey=@ForeignKey(name="FK_CURRICULO_COLAB_PESSOA"))
    public Pessoa getPessoa() {
        return this.pessoa;
    }

    public void setPessoa(Pessoa pessoa) {
        this.pessoa = pessoa;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_FUNCAO", foreignKey=@ForeignKey(name="FK_CURRICULO_COLAB_FUNCAO"))
    public Funcao getFuncao() {
        return this.funcao;
    }

    public void setFuncao(Funcao funcao) {
        this.funcao = funcao;
    }

    @Version
    @Column(name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @Column(nullable=false, name="PRETENCAO_SALARIAL", precision=15, scale=2)
    public Double getPretencaoSalarial() {
        return this.pretencaoSalarial;
    }

    public void setPretencaoSalarial(Double pretencaoSalarial) {
        this.pretencaoSalarial = pretencaoSalarial;
    }

    @Column(name="NUMERO_FILHOS")
    public Long getNumeroFilhos() {
        return this.numeroFilhos;
    }

    public void setNumeroFilhos(Long numeroFilhos) {
        this.numeroFilhos = numeroFilhos;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_GRAU_INSTRUCAO", foreignKey=@ForeignKey(name="FK_CURRICULO_COLAB_GRAU_INSTRU"))
    public GrauInstrucao getGrauInstrucao() {
        return this.grauInstrucao;
    }

    public void setGrauInstrucao(GrauInstrucao grauInstrucao) {
        this.grauInstrucao = grauInstrucao;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_ESTADO_CIVIL", foreignKey=@ForeignKey(name="FK_CURRICULO_COLAB_ESTADO_CIVIL"))
    public EstadoCivil getEstadoCivil() {
        return this.estadoCivil;
    }

    public void setEstadoCivil(EstadoCivil estadoCivil) {
        this.estadoCivil = estadoCivil;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_NACIONALIDADE", foreignKey=@ForeignKey(name="FK_CURRICULO_COLAB_NACIONALIDA"))
    public Nacionalidade getNacionalidadeColaborador() {
        return this.nacionalidadeColaborador;
    }

    public void setNacionalidadeColaborador(Nacionalidade nacionalidadeColaborador) {
        this.nacionalidadeColaborador = nacionalidadeColaborador;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_DEFICIENCIA", foreignKey=@ForeignKey(name="FK_CURRICULO_COLAB_DEFICIENCIA"))
    public TipoDeficiencia getTipoDeficiencia() {
        return this.tipoDeficiencia;
    }

    public void setTipoDeficiencia(TipoDeficiencia tipoDeficiencia) {
        this.tipoDeficiencia = tipoDeficiencia;
    }

    @Column(name="NOME_MAE", length=200)
    public String getNomeMae() {
        return this.nomeMae;
    }

    public void setNomeMae(String nomeMae) {
        this.nomeMae = nomeMae;
    }

    @Column(name="SEXO")
    public Short getSexo() {
        return this.sexo;
    }

    public void setSexo(Short sexo) {
        this.sexo = sexo;
    }

    @Column(name="DISPONIBILIDADE_VIAGEM")
    public Short getDisponibilidadeViagem() {
        return this.disponibilidadeViagem;
    }

    public void setDisponibilidadeViagem(Short disponibilidadeViagem) {
        this.disponibilidadeViagem = disponibilidadeViagem;
    }

    @Column(name="HABILITACAO")
    public Short getHabilitacao() {
        return this.habilitacao;
    }

    public void setHabilitacao(Short habilitacao) {
        this.habilitacao = habilitacao;
    }

    @Column(name="CURSO_TREINAMENTO", length=500)
    public String getCursoTreinamento() {
        return this.cursoTreinamento;
    }

    public void setCursoTreinamento(String cursoTreinamento) {
        this.cursoTreinamento = cursoTreinamento;
    }

    @Column(name="EXPERIENCIA", length=500)
    public String getExperiencia() {
        return this.experiencia;
    }

    public void setExperiencia(String experiencia) {
        this.experiencia = experiencia;
    }

    @Column(name="OBSERVACOES", length=500)
    public String getObservacoes() {
        return this.observacoes;
    }

    public void setObservacoes(String observacoes) {
        this.observacoes = observacoes;
    }

    @Column(name="LINGUAS", length=500)
    public String getLinguas() {
        return this.linguas;
    }

    public void setLinguas(String linguas) {
        this.linguas = linguas;
    }

    @Column(name="EMPREGOS_ANTERIORES", length=500)
    public String getEmpregosAnteriores() {
        return this.empregosAnteriores;
    }

    public void setEmpregosAnteriores(String empregosAnteriores) {
        this.empregosAnteriores = empregosAnteriores;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getIdentificador(), this.getPessoa() != null ? this.getPessoa().getNome() : this.getPessoa()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }
}

