/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.DadosFiscaisUFNcmFCP;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.PlanoConta;
import com.touchcomp.basementor.model.vo.UnidadeFederativa;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.UniqueConstraint;
import javax.persistence.Version;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;
import org.hibernate.annotations.Generated;
import org.hibernate.annotations.GenerationTime;

@Entity
@Table(name="DADOS_FISCAIS_UF", uniqueConstraints={@UniqueConstraint(name="UNQ1_DADOS_FISCAIS_UF", columnNames={"ID_UF", "ID_EMPRESA"})})
public class DadosFiscaisUF
implements InterfaceVO {
    private Long identificador;
    private Date dataCadastro;
    private Timestamp dataAtualizacao;
    private Empresa empresa;
    private UnidadeFederativa uf;
    private Short inscritoEstado = 0;
    private String inscricaoEstadual;
    private Short calcularFCP = 0;
    private Double aliquotaFCP = 0.0;
    private List<DadosFiscaisUFNcmFCP> ncmsFCP = new ArrayList<DadosFiscaisUFNcmFCP>();
    private PlanoConta planoContaIcmsDifal;
    private PlanoConta planoContaFundoPobreza;

    @Id
    @Column(nullable=false, name="ID_DADOS_FISCAIS_UF")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_DADOS_FISCAIS_UF")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @Column(nullable=false, name="DATA_CADASTRO")
    @Temporal(value=TemporalType.DATE)
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @Version
    @Generated(value=GenerationTime.ALWAYS)
    @Column(nullable=false, updatable=false, insertable=false, name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(nullable=false, name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_DADOS_FISCAIS_UF_EMPRESA"))
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(nullable=false, name="ID_UF", foreignKey=@ForeignKey(name="FK_DADOS_FISCAIS_UF_UF"))
    public UnidadeFederativa getUf() {
        return this.uf;
    }

    public void setUf(UnidadeFederativa uf) {
        this.uf = uf;
    }

    @Column(name="INSCRITO_ESTADO")
    public Short getInscritoEstado() {
        return this.inscritoEstado;
    }

    public void setInscritoEstado(Short inscritoEstado) {
        this.inscritoEstado = inscritoEstado;
    }

    @Column(name="INSCRICAO_ESTADUAL", length=18)
    public String getInscricaoEstadual() {
        return this.inscricaoEstadual;
    }

    public void setInscricaoEstadual(String inscricaoEstadual) {
        this.inscricaoEstadual = inscricaoEstadual;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return this.getUf() != null ? ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getUf()}) : ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getIdentificador()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @Column(nullable=true, name="CALCULAR_FCP")
    public Short getCalcularFCP() {
        return this.calcularFCP;
    }

    public void setCalcularFCP(Short calcularFCP) {
        this.calcularFCP = calcularFCP;
    }

    @Column(name="ALIQUOTA_FCP", precision=15, scale=2)
    public Double getAliquotaFCP() {
        return this.aliquotaFCP;
    }

    public void setAliquotaFCP(Double aliquotaFCP) {
        this.aliquotaFCP = aliquotaFCP;
    }

    @OneToMany(mappedBy="dadosFiscaisUF", fetch=FetchType.LAZY)
    @Cascade(value={CascadeType.ALL, CascadeType.DELETE_ORPHAN})
    public List<DadosFiscaisUFNcmFCP> getNcmsFCP() {
        return this.ncmsFCP;
    }

    public void setNcmsFCP(List<DadosFiscaisUFNcmFCP> ncmsFCP) {
        this.ncmsFCP = ncmsFCP;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_PC_ICMS_DIFAL", foreignKey=@ForeignKey(name="FK_DADOS_FISC_UF_PC_ICMS_DIFAL"))
    public PlanoConta getPlanoContaIcmsDifal() {
        return this.planoContaIcmsDifal;
    }

    public void setPlanoContaIcmsDifal(PlanoConta planoContaIcmsDifal) {
        this.planoContaIcmsDifal = planoContaIcmsDifal;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_PC_FUNDO_POBREZA", foreignKey=@ForeignKey(name="FK_DADOS_FISC_UF_PC_FCP"))
    public PlanoConta getPlanoContaFundoPobreza() {
        return this.planoContaFundoPobreza;
    }

    public void setPlanoContaFundoPobreza(PlanoConta planoContaFundoPobreza) {
        this.planoContaFundoPobreza = planoContaFundoPobreza;
    }
}

