/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.Cfop;
import com.touchcomp.basementor.model.vo.NotaFiscalPropria;
import com.touchcomp.basementor.model.vo.TipoFrete;
import com.touchcomp.basementor.model.vo.Transportador;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;

@Entity
@Table(name="DADOS_TRANS_NF_PR", uniqueConstraints={@UniqueConstraint(name="UNQ_DADOS_TRANS_NF_PR_0", columnNames={"ID_DADOS_TRANS_NF_PR", "ID_NOTA_PROPRIA"})})
public class DadosTransNfPropria
implements InterfaceVO {
    private Long identificador;
    private String inscricaoAntt;
    private String placaReboque1;
    private String placaReboque2;
    private String inscricaoAnttReboque1;
    private String inscricaoAnttReboque2;
    private Double aliquotaIcmsTrans = 0.0;
    private Double valorServicoTrans = 0.0;
    private TipoFrete tipoFrete;
    private Double valorBcIcmsServicoTrans = 0.0;
    private Cfop cfop;
    private Transportador transportador;
    private Double valorIcmsTrans = 0.0;
    private String ufPlacaReboque1;
    private String ufPlacaReboque2;
    private NotaFiscalPropria notaFiscalPropria;
    private Transportador redespacho;
    private String placaVeiculo;
    private String ufPlacaVeiculo;

    @Id
    @Column(nullable=false, name="ID_DADOS_TRANS_NF_PR")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_DADOS_TRANS_NF_PR")
    public Long getIdentificador() {
        return this.identificador;
    }

    @Column(name="INSCRICAO_ANTT", length=20)
    public String getInscricaoAntt() {
        return this.inscricaoAntt;
    }

    @Column(name="PLACA_REBOQUE1", length=8)
    public String getPlacaReboque1() {
        return this.placaReboque1;
    }

    @Column(name="PLACA_REBOQUE2", length=8)
    public String getPlacaReboque2() {
        return this.placaReboque2;
    }

    @Column(name="INSCRICAO_ANTT_REBOQUE1", length=20)
    public String getInscricaoAnttReboque1() {
        return this.inscricaoAnttReboque1;
    }

    @Column(name="INSCRICAO_ANTT_REBOQUE2", length=20)
    public String getInscricaoAnttReboque2() {
        return this.inscricaoAnttReboque2;
    }

    @Column(name="ALIQUOTA_ICMS_TRANS", precision=12, scale=2)
    public Double getAliquotaIcmsTrans() {
        return this.aliquotaIcmsTrans;
    }

    @Column(name="VALOR_SERVICO_TRANS", precision=12, scale=2)
    public Double getValorServicoTrans() {
        return this.valorServicoTrans;
    }

    @JoinColumn(nullable=false, name="ID_TIPO_FRETE", foreignKey=@ForeignKey(name="FK_DADOS_TRANS_NF_PR_FRETE"))
    @ManyToOne(fetch=FetchType.LAZY)
    public TipoFrete getTipoFrete() {
        return this.tipoFrete;
    }

    @Column(name="VALOR_BC_ICMS_TRANS", precision=12, scale=2)
    public Double getValorBcIcmsServicoTrans() {
        return this.valorBcIcmsServicoTrans;
    }

    @JoinColumn(name="ID_CFOP", foreignKey=@ForeignKey(name="FK_DADOS_TRANS_NF_PR_CFOP"))
    @ManyToOne(fetch=FetchType.LAZY)
    public Cfop getCfop() {
        return this.cfop;
    }

    @JoinColumn(name="ID_TRANSPORTADOR", foreignKey=@ForeignKey(name="FK_DADOS_TRANS_NF_PR_T"))
    @ManyToOne(fetch=FetchType.LAZY)
    public Transportador getTransportador() {
        return this.transportador;
    }

    @Column(name="VALOR_ICMS_TRANS", precision=12, scale=2)
    public Double getValorIcmsTrans() {
        return this.valorIcmsTrans;
    }

    @Column(name="UF_PLACA_REBOQUE1", length=2)
    public String getUfPlacaReboque1() {
        return this.ufPlacaReboque1;
    }

    @Column(name="UF_PLACA_REBOQUE2", length=2)
    public String getUfPlacaReboque2() {
        return this.ufPlacaReboque2;
    }

    @JoinColumn(nullable=false, name="ID_NOTA_PROPRIA", foreignKey=@ForeignKey(name="FK_DADOS_TRANS_NF_PR_NP"))
    @OneToOne(targetEntity=NotaFiscalPropria.class, fetch=FetchType.LAZY)
    public NotaFiscalPropria getNotaFiscalPropria() {
        return this.notaFiscalPropria;
    }

    @JoinColumn(name="ID_TRANS_REDESPACHO", foreignKey=@ForeignKey(name="FK_DADOS_TRANS_NF_PR_TRD"))
    @ManyToOne(fetch=FetchType.LAZY)
    public Transportador getRedespacho() {
        return this.redespacho;
    }

    @Column(name="PLACA_VEICULO", length=8)
    public String getPlacaVeiculo() {
        return this.placaVeiculo;
    }

    @Column(name="UF_PLACA_VEICULO", length=2)
    public String getUfPlacaVeiculo() {
        return this.ufPlacaVeiculo;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    public void setInscricaoAntt(String inscricaoAntt) {
        this.inscricaoAntt = inscricaoAntt;
    }

    public void setPlacaReboque1(String placaReboque1) {
        if (placaReboque1 != null) {
            placaReboque1 = placaReboque1.toUpperCase();
        }
        this.placaReboque1 = placaReboque1;
    }

    public void setPlacaReboque2(String placaReboque2) {
        if (placaReboque2 != null) {
            placaReboque2 = placaReboque2.toUpperCase();
        }
        this.placaReboque2 = placaReboque2;
    }

    public void setInscricaoAnttReboque1(String inscricaoAnttReboque1) {
        this.inscricaoAnttReboque1 = inscricaoAnttReboque1;
    }

    public void setInscricaoAnttReboque2(String inscricaoAnttReboque2) {
        this.inscricaoAnttReboque2 = inscricaoAnttReboque2;
    }

    public void setAliquotaIcmsTrans(Double aliquotaIcmsTrans) {
        this.aliquotaIcmsTrans = aliquotaIcmsTrans;
    }

    public void setValorServicoTrans(Double valorServicoTrans) {
        this.valorServicoTrans = valorServicoTrans;
    }

    public void setTipoFrete(TipoFrete tipoFrete) {
        this.tipoFrete = tipoFrete;
    }

    public void setValorBcIcmsServicoTrans(Double valorBcIcmsServicoTrans) {
        this.valorBcIcmsServicoTrans = valorBcIcmsServicoTrans;
    }

    public void setCfop(Cfop cfop) {
        this.cfop = cfop;
    }

    public void setTransportador(Transportador transportador) {
        this.transportador = transportador;
    }

    public void setValorIcmsTrans(Double valorIcmsTrans) {
        this.valorIcmsTrans = valorIcmsTrans;
    }

    public void setUfPlacaReboque1(String ufPlacaReboque1) {
        this.ufPlacaReboque1 = ufPlacaReboque1;
    }

    public void setUfPlacaReboque2(String ufPlacaReboque2) {
        this.ufPlacaReboque2 = ufPlacaReboque2;
    }

    public void setNotaFiscalPropria(NotaFiscalPropria notaFiscalPropria) {
        this.notaFiscalPropria = notaFiscalPropria;
    }

    public void setRedespacho(Transportador redespacho) {
        this.redespacho = redespacho;
    }

    public void setPlacaVeiculo(String placaVeiculo) {
        if (placaVeiculo != null) {
            placaVeiculo = placaVeiculo.toUpperCase();
        }
        this.placaVeiculo = placaVeiculo;
    }

    public void setUfPlacaVeiculo(String ufPlacaVeiculo) {
        this.ufPlacaVeiculo = ufPlacaVeiculo;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getIdentificador()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }
}

