/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.AdicoesImportacao;
import com.touchcomp.basementor.model.vo.ItemNotaImportacao;
import com.touchcomp.basementor.model.vo.Pessoa;
import com.touchcomp.basementor.model.vo.UnidadeFederativa;
import com.touchcomp.basementor.model.vo.ViaTransporteDetImportacaoItem;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;

@Entity
@Table(name="DET_IMPORTACAO_ITEM")
public class DetImportacaoItem
implements InterfaceVO {
    private Long identificador;
    private String numDocImportacao;
    private String localDesembaraco;
    private Date dataRegDocImp;
    private UnidadeFederativa ufDesembaraco;
    private Date dataDesembaraco;
    private Pessoa exportador;
    private List<AdicoesImportacao> adicoesImportacao = new ArrayList<AdicoesImportacao>();
    private ItemNotaImportacao itemNotaImportacao;
    private ViaTransporteDetImportacaoItem viaTransporteDetImportacaoItem;
    private Double valorAFRMM = 0.0;
    private Short tipoIntermedio = 0;
    private Pessoa adquirenteEncomendante;

    @Id
    @Column(nullable=false, name="ID_DET_IMPORTACAO_ITEM")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_DET_IMPORTACAO_ITEM")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @Column(name="NUM_DOC_IMPORTACAO", length=20)
    public String getNumDocImportacao() {
        return this.numDocImportacao;
    }

    public void setNumDocImportacao(String numDocImportacao) {
        this.numDocImportacao = numDocImportacao;
    }

    @Column(name="DATA_REG_IMPORTACAO")
    @Temporal(value=TemporalType.DATE)
    public Date getDataRegDocImp() {
        return this.dataRegDocImp;
    }

    public void setDataRegDocImp(Date dataRegDocImp) {
        this.dataRegDocImp = dataRegDocImp;
    }

    @JoinColumn(name="ID_UF_DESEMBARACO", foreignKey=@ForeignKey(name="FK_DET_IMPORTACAO_ITEM_UF"))
    @ManyToOne(fetch=FetchType.LAZY)
    public UnidadeFederativa getUfDesembaraco() {
        return this.ufDesembaraco;
    }

    public void setUfDesembaraco(UnidadeFederativa ufDesembaraco) {
        this.ufDesembaraco = ufDesembaraco;
    }

    @Column(name="DATA_DESEMBARACO")
    @Temporal(value=TemporalType.DATE)
    public Date getDataDesembaraco() {
        return this.dataDesembaraco;
    }

    public void setDataDesembaraco(Date dataDesembaraco) {
        this.dataDesembaraco = dataDesembaraco;
    }

    @JoinColumn(name="ID_EXPORTADOR", foreignKey=@ForeignKey(name="FK_DET_IMP_EXPORTADOR_PESSOA"))
    @ManyToOne(fetch=FetchType.LAZY)
    public Pessoa getExportador() {
        return this.exportador;
    }

    public void setExportador(Pessoa exportador) {
        this.exportador = exportador;
    }

    @OneToMany(mappedBy="detImportacaoItem")
    @Cascade(value={CascadeType.ALL, CascadeType.DELETE_ORPHAN})
    public List<AdicoesImportacao> getAdicoesImportacao() {
        return this.adicoesImportacao;
    }

    public void setAdicoesImportacao(List<AdicoesImportacao> adicoesImportacao) {
        this.adicoesImportacao = adicoesImportacao;
    }

    @JoinColumn(name="ID_ITEM_NOTA_IMPORTACAO", foreignKey=@ForeignKey(name="FK_DET_IMPORTACAO_ITEM_NOTA"))
    @ManyToOne(fetch=FetchType.LAZY)
    public ItemNotaImportacao getItemNotaImportacao() {
        return this.itemNotaImportacao;
    }

    public void setItemNotaImportacao(ItemNotaImportacao itemNotaImportacao) {
        this.itemNotaImportacao = itemNotaImportacao;
    }

    @Column(name="LOCAL_DESEMBARACO", length=60)
    public String getLocalDesembaraco() {
        return this.localDesembaraco;
    }

    public void setLocalDesembaraco(String localDesembaraco) {
        this.localDesembaraco = localDesembaraco;
    }

    @JoinColumn(name="ID_VIA_TRANSP_DET_IMPORT_ITEM", foreignKey=@ForeignKey(name="FK_DET_IMPORTACAO_ITEM_VIA_TRAN"))
    @ManyToOne(fetch=FetchType.LAZY)
    public ViaTransporteDetImportacaoItem getViaTransporteDetImportacaoItem() {
        return this.viaTransporteDetImportacaoItem;
    }

    public void setViaTransporteDetImportacaoItem(ViaTransporteDetImportacaoItem viaTransporteDetImportacaoItem) {
        this.viaTransporteDetImportacaoItem = viaTransporteDetImportacaoItem;
    }

    @Column(nullable=false, name="VALOR_AFRMM", precision=15, scale=2)
    public Double getValorAFRMM() {
        return this.valorAFRMM;
    }

    public void setValorAFRMM(Double valorAFRMM) {
        this.valorAFRMM = valorAFRMM;
    }

    @Column(name="TIPO_ITERMEDIO")
    public Short getTipoIntermedio() {
        return this.tipoIntermedio;
    }

    public void setTipoIntermedio(Short tipoIntermedio) {
        this.tipoIntermedio = tipoIntermedio;
    }

    @JoinColumn(name="ID_ADQUIRENTE_ENCOMENDANTE", foreignKey=@ForeignKey(name="FK_DET_IMPORTACAO_ITEM_AD_ENCOM"))
    @ManyToOne(fetch=FetchType.LAZY)
    public Pessoa getAdquirenteEncomendante() {
        return this.adquirenteEncomendante;
    }

    public void setAdquirenteEncomendante(Pessoa adquirenteEncomendante) {
        this.adquirenteEncomendante = adquirenteEncomendante;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0} - Documento de importacao: {1}", (Object[])new Object[]{this.getIdentificador(), this.getNumDocImportacao()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }
}

