/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.ContribOutrasEntidadesFundos;
import com.touchcomp.basementor.model.vo.ContribPrevPatronal;
import com.touchcomp.basementor.model.vo.ContribuicaoPrevSegurados;
import com.touchcomp.basementor.model.vo.DetalhamentoImpostoIrrf;
import com.touchcomp.basementor.model.vo.DetalhamentoImpostosFgts;
import com.touchcomp.basementor.model.vo.DetalhamentoImpostosImp;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.Pessoa;
import com.touchcomp.basementor.model.vo.QualificacaoPj;
import com.touchcomp.basementor.model.vo.RegimePisCofins;
import com.touchcomp.basementor.model.vo.TributacaoLucro;
import com.touchcomp.basementor.model.vo.UnidadeFederativa;
import com.touchcomp.basementor.model.vo.VariacoesMonetarias;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.UniqueConstraint;
import lombok.Generated;
import org.hibernate.annotations.Cascade;

@Entity
@Table(name="DETALHAMENTO_IMPOSTOS", uniqueConstraints={@UniqueConstraint(name="UNQ1_DETALHAMENTO_IMPOSTOS", columnNames={"PERIODO", "ID_EMPRESA"})})
public class DetalhamentoImpostos
implements InterfaceVO {
    @Id
    @Column(nullable=false, name="ID_DETALHAMENTO_IMPOSTOS")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_DETALHAMENTO_IMPOSTOS")
    private Long identificador;
    @Column(name="PERIODO")
    @Temporal(value=TemporalType.DATE)
    private Date periodo;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(nullable=false, name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_DET_IMP_EMPRESA"))
    private Empresa empresa;
    @Column(name="TOTAL_APURADO", precision=12, scale=2)
    private Double totalApurado = 0.0;
    @Column(name="TOTAL_DEDUCOES", precision=12, scale=2)
    private Double totalDeducoes = 0.0;
    @Column(name="TOTAL_APURADO_LIQ", precision=12, scale=2)
    private Double totalApuradoLiquido = 0.0;
    @Column(name="TOTAL_CPS_PREV_SEG", precision=12, scale=2)
    private Double totalCpsPrevSeg = 0.0;
    @Column(name="TOTAL_CPS_PATRONAL", precision=12, scale=2)
    private Double totalCpsPatronal = 0.0;
    @Column(name="TOTAL_CPS_OUT_ENT", precision=12, scale=2)
    private Double totalCpsOutrasEntidades = 0.0;
    @Column(name="TOTAL_IRRF", precision=12, scale=2)
    private Double totalIrrf = 0.0;
    @Column(name="TOTAL_AGREG_REINF", precision=12, scale=2)
    private Double totalAgregadoReinf = 0.0;
    @Column(name="TOTAL_FGTS", precision=12, scale=2)
    private Double totalFgts = 0.0;
    @Column(name="TOTAL_PIS_FOLHA", precision=12, scale=2)
    private Double totalPisSobreFolha = 0.0;
    @OneToOne(mappedBy="detalhamentoImpostos", fetch=FetchType.LAZY)
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    private ContribuicaoPrevSegurados contPrevSeg;
    @OneToOne(mappedBy="detalhamentoImpostos", fetch=FetchType.LAZY)
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    private ContribPrevPatronal contPrevPatr;
    @OneToOne(mappedBy="detalhamentoImpostos", fetch=FetchType.LAZY)
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    private ContribOutrasEntidadesFundos contOutEntidFund;
    @OneToOne(mappedBy="detalhamentoImpostos", fetch=FetchType.LAZY)
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    private DetalhamentoImpostosFgts totalizadoresFgts;
    @OneToOne(mappedBy="detalhamentoImpostos", fetch=FetchType.LAZY)
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    private DetalhamentoImpostoIrrf totalizadoresIrrf;
    @Column(name="BALANCO_LUCRO_REAL")
    private Short balancoLucroReal = EnumConstantsMentorSimNao.NAO.getValue();
    @Column(name="REGISTRO_CRC", length=13)
    private String registroCRC;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_UF_EXPEDICAO_CRC", foreignKey=@ForeignKey(name="FK_DET_IMPOSTOS_UF"))
    private UnidadeFederativa ufExpedicaoCrc;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_PESSOA", foreignKey=@ForeignKey(name="FK_DET_IMPOSTOS_PESSOA"))
    private Pessoa pessoa;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_QUALIFICAO_PJ", foreignKey=@ForeignKey(name="FK_DET_IMPOSTOS_QUAL_PJ"))
    private QualificacaoPj qualificacaoPj;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_TRIBUTACAO_LUCRO", foreignKey=@ForeignKey(name="FK_DET_IMPOSTOS_TRIB_LUC"))
    private TributacaoLucro tributacaoLucro;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_REGIME_PIS_COFINS", foreignKey=@ForeignKey(name="FK_DET_IMPOSTOS_REG_PC"))
    private RegimePisCofins regimePisCofins;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_VARIACOES_MONETARIAS", foreignKey=@ForeignKey(name="FK_DET_IMPOSTOS_VAR_MON"))
    private VariacoesMonetarias variacoesMonetarias;
    @OneToMany(mappedBy="detalhamentoImpostos", fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN, org.hibernate.annotations.CascadeType.ALL})
    private List<DetalhamentoImpostosImp> impostos = new ArrayList<DetalhamentoImpostosImp>();

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getIdentificador()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @Generated
    public Long getIdentificador() {
        return this.identificador;
    }

    @Generated
    public Date getPeriodo() {
        return this.periodo;
    }

    @Generated
    public Empresa getEmpresa() {
        return this.empresa;
    }

    @Generated
    public Double getTotalApurado() {
        return this.totalApurado;
    }

    @Generated
    public Double getTotalDeducoes() {
        return this.totalDeducoes;
    }

    @Generated
    public Double getTotalApuradoLiquido() {
        return this.totalApuradoLiquido;
    }

    @Generated
    public Double getTotalCpsPrevSeg() {
        return this.totalCpsPrevSeg;
    }

    @Generated
    public Double getTotalCpsPatronal() {
        return this.totalCpsPatronal;
    }

    @Generated
    public Double getTotalCpsOutrasEntidades() {
        return this.totalCpsOutrasEntidades;
    }

    @Generated
    public Double getTotalIrrf() {
        return this.totalIrrf;
    }

    @Generated
    public Double getTotalAgregadoReinf() {
        return this.totalAgregadoReinf;
    }

    @Generated
    public Double getTotalFgts() {
        return this.totalFgts;
    }

    @Generated
    public Double getTotalPisSobreFolha() {
        return this.totalPisSobreFolha;
    }

    @Generated
    public ContribuicaoPrevSegurados getContPrevSeg() {
        return this.contPrevSeg;
    }

    @Generated
    public ContribPrevPatronal getContPrevPatr() {
        return this.contPrevPatr;
    }

    @Generated
    public ContribOutrasEntidadesFundos getContOutEntidFund() {
        return this.contOutEntidFund;
    }

    @Generated
    public DetalhamentoImpostosFgts getTotalizadoresFgts() {
        return this.totalizadoresFgts;
    }

    @Generated
    public DetalhamentoImpostoIrrf getTotalizadoresIrrf() {
        return this.totalizadoresIrrf;
    }

    @Generated
    public Short getBalancoLucroReal() {
        return this.balancoLucroReal;
    }

    @Generated
    public String getRegistroCRC() {
        return this.registroCRC;
    }

    @Generated
    public UnidadeFederativa getUfExpedicaoCrc() {
        return this.ufExpedicaoCrc;
    }

    @Generated
    public Pessoa getPessoa() {
        return this.pessoa;
    }

    @Generated
    public QualificacaoPj getQualificacaoPj() {
        return this.qualificacaoPj;
    }

    @Generated
    public TributacaoLucro getTributacaoLucro() {
        return this.tributacaoLucro;
    }

    @Generated
    public RegimePisCofins getRegimePisCofins() {
        return this.regimePisCofins;
    }

    @Generated
    public VariacoesMonetarias getVariacoesMonetarias() {
        return this.variacoesMonetarias;
    }

    @Generated
    public List<DetalhamentoImpostosImp> getImpostos() {
        return this.impostos;
    }

    @Generated
    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @Generated
    public void setPeriodo(Date periodo) {
        this.periodo = periodo;
    }

    @Generated
    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    @Generated
    public void setTotalApurado(Double totalApurado) {
        this.totalApurado = totalApurado;
    }

    @Generated
    public void setTotalDeducoes(Double totalDeducoes) {
        this.totalDeducoes = totalDeducoes;
    }

    @Generated
    public void setTotalApuradoLiquido(Double totalApuradoLiquido) {
        this.totalApuradoLiquido = totalApuradoLiquido;
    }

    @Generated
    public void setTotalCpsPrevSeg(Double totalCpsPrevSeg) {
        this.totalCpsPrevSeg = totalCpsPrevSeg;
    }

    @Generated
    public void setTotalCpsPatronal(Double totalCpsPatronal) {
        this.totalCpsPatronal = totalCpsPatronal;
    }

    @Generated
    public void setTotalCpsOutrasEntidades(Double totalCpsOutrasEntidades) {
        this.totalCpsOutrasEntidades = totalCpsOutrasEntidades;
    }

    @Generated
    public void setTotalIrrf(Double totalIrrf) {
        this.totalIrrf = totalIrrf;
    }

    @Generated
    public void setTotalAgregadoReinf(Double totalAgregadoReinf) {
        this.totalAgregadoReinf = totalAgregadoReinf;
    }

    @Generated
    public void setTotalFgts(Double totalFgts) {
        this.totalFgts = totalFgts;
    }

    @Generated
    public void setTotalPisSobreFolha(Double totalPisSobreFolha) {
        this.totalPisSobreFolha = totalPisSobreFolha;
    }

    @Generated
    public void setContPrevSeg(ContribuicaoPrevSegurados contPrevSeg) {
        this.contPrevSeg = contPrevSeg;
    }

    @Generated
    public void setContPrevPatr(ContribPrevPatronal contPrevPatr) {
        this.contPrevPatr = contPrevPatr;
    }

    @Generated
    public void setContOutEntidFund(ContribOutrasEntidadesFundos contOutEntidFund) {
        this.contOutEntidFund = contOutEntidFund;
    }

    @Generated
    public void setTotalizadoresFgts(DetalhamentoImpostosFgts totalizadoresFgts) {
        this.totalizadoresFgts = totalizadoresFgts;
    }

    @Generated
    public void setTotalizadoresIrrf(DetalhamentoImpostoIrrf totalizadoresIrrf) {
        this.totalizadoresIrrf = totalizadoresIrrf;
    }

    @Generated
    public void setBalancoLucroReal(Short balancoLucroReal) {
        this.balancoLucroReal = balancoLucroReal;
    }

    @Generated
    public void setRegistroCRC(String registroCRC) {
        this.registroCRC = registroCRC;
    }

    @Generated
    public void setUfExpedicaoCrc(UnidadeFederativa ufExpedicaoCrc) {
        this.ufExpedicaoCrc = ufExpedicaoCrc;
    }

    @Generated
    public void setPessoa(Pessoa pessoa) {
        this.pessoa = pessoa;
    }

    @Generated
    public void setQualificacaoPj(QualificacaoPj qualificacaoPj) {
        this.qualificacaoPj = qualificacaoPj;
    }

    @Generated
    public void setTributacaoLucro(TributacaoLucro tributacaoLucro) {
        this.tributacaoLucro = tributacaoLucro;
    }

    @Generated
    public void setRegimePisCofins(RegimePisCofins regimePisCofins) {
        this.regimePisCofins = regimePisCofins;
    }

    @Generated
    public void setVariacoesMonetarias(VariacoesMonetarias variacoesMonetarias) {
        this.variacoesMonetarias = variacoesMonetarias;
    }

    @Generated
    public void setImpostos(List<DetalhamentoImpostosImp> impostos) {
        this.impostos = impostos;
    }
}

