/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.ItemDiagnosticoOS;
import com.touchcomp.basementor.model.vo.NecessidadeProducao;
import com.touchcomp.basementor.model.vo.OrdemServicoProdSobEnc;
import com.touchcomp.basementor.model.vo.Usuario;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Version;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;

@Entity
@Table(name="DIAGNOSTICO_OS")
public class DiagnosticoOS
implements InterfaceVO {
    private Long identificador;
    private Date dataDiagnostico;
    private Usuario usuario;
    private Date dataCadastro;
    private Timestamp dataAtualizacao;
    private OrdemServicoProdSobEnc ordemServProdSobEnc;
    private Empresa empresa;
    private List<ItemDiagnosticoOS> itemDiagnosticoOS = new ArrayList<ItemDiagnosticoOS>();
    private List<NecessidadeProducao> necessidadeProducao = new ArrayList<NecessidadeProducao>();

    @Id
    @Column(nullable=false, name="ID_DIAGNOSTICO_OS")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_DIAGNOSTICO_OS")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_DIAGNOSTICO")
    public Date getDataDiagnostico() {
        return this.dataDiagnostico;
    }

    public void setDataDiagnostico(Date dataDiagnostico) {
        this.dataDiagnostico = dataDiagnostico;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_USUARIO", foreignKey=@ForeignKey(name="FK_DIAGNOSTICO_OS_USUARIO"))
    public Usuario getUsuario() {
        return this.usuario;
    }

    public void setUsuario(Usuario usuario) {
        this.usuario = usuario;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_CADASTRO")
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @Version
    @Column(name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @OneToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_OS_PROD_SOB_ENCOMENDA", foreignKey=@ForeignKey(name="FK_DIAGNOSTICO_OS_OS_PROD_SOB_E"))
    public OrdemServicoProdSobEnc getOrdemServProdSobEnc() {
        return this.ordemServProdSobEnc;
    }

    public void setOrdemServProdSobEnc(OrdemServicoProdSobEnc ordemServProdSobEnc) {
        this.ordemServProdSobEnc = ordemServProdSobEnc;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getIdentificador()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_DIAGNOSTICO_OS_EMPRESA"))
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    @OneToMany(mappedBy="diagnosticoOS", fetch=FetchType.LAZY)
    @Cascade(value={CascadeType.ALL, CascadeType.DELETE_ORPHAN})
    public List<ItemDiagnosticoOS> getItemDiagnosticoOS() {
        return this.itemDiagnosticoOS;
    }

    public void setItemDiagnosticoOS(List<ItemDiagnosticoOS> itemDiagnosticoOS) {
        this.itemDiagnosticoOS = itemDiagnosticoOS;
    }

    @OneToMany(mappedBy="diagnosticoOS", fetch=FetchType.LAZY)
    @Cascade(value={CascadeType.ALL, CascadeType.DELETE_ORPHAN})
    public List<NecessidadeProducao> getNecessidadeProducao() {
        return this.necessidadeProducao;
    }

    public void setNecessidadeProducao(List<NecessidadeProducao> necessidadeProducao) {
        this.necessidadeProducao = necessidadeProducao;
    }
}

