/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.CentroCusto;
import com.touchcomp.basementor.model.vo.Embalagem;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.ItemEmbalagemProducao;
import com.touchcomp.basementor.model.vo.OrdemServicoProdLinhaProd;
import com.touchcomp.basementor.model.vo.Usuario;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import javax.persistence.Version;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.Generated;
import org.hibernate.annotations.GenerationTime;

@Entity
@Table(name="EMBALAGEM_PRODUCAO")
public class EmbalagemProducao
implements InterfaceVO {
    private Long identificador;
    private Short lacraEmbalagem = 0;
    private Double pesoBruto = 0.0;
    private Double pesoLiquido = 0.0;
    private Double volume = 0.0;
    private Short opcaoCaixa = 0;
    private Double volumeUtilizado = 0.0;
    private Usuario usuario;
    private Date dataCadastro;
    private Empresa empresa;
    private List<ItemEmbalagemProducao> itemEmbalagemProducao = new ArrayList<ItemEmbalagemProducao>();
    private Embalagem embalagem;
    private String codigoBarras;
    private List<OrdemServicoProdLinhaProd> ordemServico = new ArrayList<OrdemServicoProdLinhaProd>();
    private Date dataAbertura;
    private Date dataFechamento;
    private Double qtdTotalItens = 0.0;
    private CentroCusto centroCusto;
    private Timestamp dataAtualizacao;

    @Id
    @Column(nullable=false, unique=true, name="ID_EMBALAGEM_PRODUCAO")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_EMBALAGEM_PRODUCAO")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @Column(name="LACRA_EMBALAGEM")
    public Short getLacraEmbalagem() {
        return this.lacraEmbalagem;
    }

    public void setLacraEmbalagem(Short lacraEmbalagem) {
        this.lacraEmbalagem = lacraEmbalagem;
    }

    @Column(name="PESO_BRUTO", precision=15, scale=2)
    public Double getPesoBruto() {
        return this.pesoBruto;
    }

    public void setPesoBruto(Double pesoBruto) {
        this.pesoBruto = pesoBruto;
    }

    @Column(name="PESO_LIQUIDO", precision=15, scale=2)
    public Double getPesoLiquido() {
        return this.pesoLiquido;
    }

    public void setPesoLiquido(Double pesoLiquido) {
        this.pesoLiquido = pesoLiquido;
    }

    @Column(nullable=false, name="VOLUME", precision=15, scale=2)
    public Double getVolume() {
        return this.volume;
    }

    public void setVolume(Double volume) {
        this.volume = volume;
    }

    @Column(name="VOLUME_UTILIZADO", precision=15, scale=2)
    public Double getVolumeUtilizado() {
        return this.volumeUtilizado;
    }

    public void setVolumeUtilizado(Double volumeUtilizado) {
        this.volumeUtilizado = volumeUtilizado;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_USUARIO", foreignKey=@ForeignKey(name="FK_EMBALAGEM_PRODUCAO_USUARIO"))
    public Usuario getUsuario() {
        return this.usuario;
    }

    public void setUsuario(Usuario usuario) {
        this.usuario = usuario;
    }

    @OneToMany(fetch=FetchType.LAZY, mappedBy="embalagemProducao", cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN, org.hibernate.annotations.CascadeType.ALL})
    public List<ItemEmbalagemProducao> getItemEmbalagemProducao() {
        return this.itemEmbalagemProducao;
    }

    public void setItemEmbalagemProducao(List itemEmbalagemProducao) {
        this.itemEmbalagemProducao = itemEmbalagemProducao;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_EMBALAGEM", foreignKey=@ForeignKey(name="FK_EMBALAGEM_PRODUCAO_EMBALAGEM"))
    public Embalagem getEmbalagem() {
        return this.embalagem;
    }

    public void setEmbalagem(Embalagem embalagem) {
        this.embalagem = embalagem;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getEmbalagem()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @Column(name="OPCAO_CAIXA")
    public Short getOpcaoCaixa() {
        return this.opcaoCaixa;
    }

    public void setOpcaoCaixa(Short opcaoCaixa) {
        this.opcaoCaixa = opcaoCaixa;
    }

    @Column(name="DATA_CADASTRO")
    @Temporal(value=TemporalType.DATE)
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_EMBALAGEM_PRODUCAO_EMPRESA"))
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    @Column(name="CODIGO_BARRAS", length=20)
    @Generated(value=GenerationTime.INSERT)
    public String getCodigoBarras() {
        return this.codigoBarras;
    }

    public void setCodigoBarras(String codigoBarras) {
        this.codigoBarras = codigoBarras;
    }

    @Transient
    @OneToMany(targetEntity=OrdemServicoProdLinhaProd.class, cascade={CascadeType.MERGE}, fetch=FetchType.LAZY)
    @JoinTable(name="EMBALAGEM_PROD_ORDENS_SERVICO", joinColumns={@JoinColumn(name="ID_EMBALAGEM_PRODUCAO")}, inverseJoinColumns={@JoinColumn(name="ID_ORDEM_SERVICO_PRODUCAO")})
    public List<OrdemServicoProdLinhaProd> getOrdemServico() {
        return this.ordemServico;
    }

    public void setOrdemServico(List<OrdemServicoProdLinhaProd> ordemServico) {
        this.ordemServico = ordemServico;
    }

    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="DATA_ABERTURA")
    public Date getDataAbertura() {
        return this.dataAbertura;
    }

    public void setDataAbertura(Date dataAbertura) {
        this.dataAbertura = dataAbertura;
    }

    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="DATA_ENCERRAMENTO")
    public Date getDataFechamento() {
        return this.dataFechamento;
    }

    public void setDataFechamento(Date dataFechamento) {
        this.dataFechamento = dataFechamento;
    }

    @Column(nullable=false, name="QTD_TOTAL_ITENS", precision=15, scale=2)
    public Double getQtdTotalItens() {
        return this.qtdTotalItens;
    }

    public void setQtdTotalItens(Double qtdTotalItens) {
        this.qtdTotalItens = qtdTotalItens;
    }

    @JoinColumn(name="ID_CENTRO_CUSTO", foreignKey=@ForeignKey(name="FK_EMBALAGEM_PRODUCAO_CC"))
    @ManyToOne(fetch=FetchType.LAZY)
    public CentroCusto getCentroCusto() {
        return this.centroCusto;
    }

    public void setCentroCusto(CentroCusto centroCusto) {
        this.centroCusto = centroCusto;
    }

    @Version
    @Column(name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }
}

