/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.Pessoa;
import com.touchcomp.basementor.model.vo.PlanoConta;
import com.touchcomp.basementor.model.vo.PlanoContaGerencial;
import com.touchcomp.basementor.model.vo.UnidadeFederativa;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.UniqueConstraint;
import org.hibernate.annotations.Fetch;
import org.hibernate.annotations.FetchMode;

@Entity
@Table(name="EMPRESA_CONTABILIDADE", uniqueConstraints={@UniqueConstraint(name="UNQ1_EMPRESA_CONTABILIDADE", columnNames={"ID_EMPRESA"})})
public class EmpresaContabilidade
implements InterfaceVO {
    private Long identificador;
    private String crc;
    private Empresa empresa;
    private String cnpjContabilidade;
    private PlanoContaGerencial planoChequeTerceirosGerencial;
    private PlanoContaGerencial planoFaltaPagamentoGerencial;
    private PlanoContaGerencial planoDevGerenRecebimento;
    private PlanoContaGerencial planoDevGerenPagamento;
    private Pessoa pessoa;
    private Short lancMovimentoBancario = 0;
    private Short lancBaixaTitulos = 0;
    private Short lancNotaPropria = 0;
    private Short lancNotaTerceiros = 0;
    private Short alterarLancGeradoMentor = 0;
    private Short gerarLancamentosCupons = 0;
    private UnidadeFederativa ufExpedicaoCrc;
    private Date dataValidadeCrc;
    private Short opcaoGerarTitulos = 0;
    private Short diaIrrfFolha = 0;
    private Pessoa pessoaIrrfFolha;
    private PlanoConta planoContaIrrfFolha;
    private PlanoContaGerencial planoIrrfGerencialFolha;
    private Short diaInssFolha = 0;
    private Pessoa pessoaInssFolha;
    private PlanoConta planoContaInssFolha;
    private PlanoContaGerencial planoInssGerencialFolha;
    private Short diaFgtsFolha = 0;
    private Pessoa pessoaFgtsFolha;
    private PlanoConta planoContaFgtsFolha;
    private PlanoContaGerencial planoFgtsGerencialFolha;
    private Short diaDarFolha = 0;
    private Pessoa pessoaDarFolha;
    private PlanoConta planoContaDarfFolha;
    private PlanoContaGerencial planoDarfGerencialFolha;
    private Pessoa pessoaGrrf;
    private PlanoConta planoContaGrrf;
    private PlanoContaGerencial planoGrrfGerencial;
    private Short diaPisFolha = 0;
    private Pessoa pessoaPisFolha;
    private PlanoConta planoContaPisFolha;
    private PlanoContaGerencial planoGerencialPisFolha;
    private Short gerarLancamentosAdiantamentosViagens = 0;
    private PlanoContaGerencial pcGerRenegociacaoPag;
    private PlanoContaGerencial pcGerRenegociacaoRec;
    private Short embutirIpiIcmsOutros = 0;
    private Short embutirIcmsStIcmsOutros = 0;
    private Short gerarContabil = 0;
    private Short gerarLancamentoCupomReceita = 0;
    private Short gerarLancamentoCupomDespesa = 0;
    private PlanoConta planoContaTaxaCambialVariacao;
    private PlanoConta planoContaTaxaCambialDespesa;
    private PlanoConta planoContaTaxaCambialReceira;
    private PlanoConta planoContaTaxaCambialVariacaoPag;
    private PlanoConta planoContaTaxaCambialDespesaPag;
    private PlanoConta planoContaTaxaCambialReceitaPag;
    private PlanoConta planoContaTaxaCambialVariacaoAntecipado;
    private PlanoConta planoContaTaxaCambialDespesaAntecipado;
    private PlanoConta planoContaTaxaCambialReceitaAntecipado;
    private PlanoConta planoContaTaxaCambialVariacaoPagAntecipado;
    private PlanoConta planoContaTaxaCambialDespesaPagAntecipado;
    private PlanoConta planoContaTaxaCambialReceitaPagAntecipado;
    private Short integrarNFTerceirosBloqueioNF = 0;
    private PlanoConta planoContaChequeTerceiros;
    private PlanoConta planoContaEstProprio;
    private PlanoConta planoContaEstTercMeu;
    private PlanoConta planoContaEstTercOutros;
    private Short descartarLiquidoRescisao = 0;

    @Id
    @Column(name="ID_EMPRESA_CONTABILIDADE")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_EMPRESA_CONTABILIDADE")
    public Long getIdentificador() {
        return this.identificador;
    }

    @Column(nullable=false, name="CRC_CONTADOR", length=20)
    public String getCrc() {
        return this.crc;
    }

    public void setCrc(String crc) {
        this.crc = crc;
    }

    public void setIdentificador(Long idEmp) {
        this.identificador = idEmp;
    }

    @OneToOne(targetEntity=Empresa.class, fetch=FetchType.EAGER)
    @JoinColumn(name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_EMPRESA_CONT_EMPRESA"))
    @Fetch(value=FetchMode.SELECT)
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="ID_PC_FALTA_PAGAMENTO_GER", foreignKey=@ForeignKey(name="FK_EMPRESA_CONT_PC_FAL_PAGAMENT"))
    public PlanoContaGerencial getPlanoFaltaPagamentoGerencial() {
        return this.planoFaltaPagamentoGerencial;
    }

    public void setPlanoFaltaPagamentoGerencial(PlanoContaGerencial planoContaFaltaPagamentoGerencial) {
        this.planoFaltaPagamentoGerencial = planoContaFaltaPagamentoGerencial;
    }

    @Column(name="LANC_MOVIMENTO_BANCARIO")
    public Short getLancMovimentoBancario() {
        return this.lancMovimentoBancario;
    }

    public void setLancMovimentoBancario(Short lancMovimentoBancario) {
        this.lancMovimentoBancario = lancMovimentoBancario;
    }

    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="ID_PC_DEVOL_GER_RECEBIMENTO", foreignKey=@ForeignKey(name="FK_EMPRESA_CONT_PC_DEV_GER_REC"))
    public PlanoContaGerencial getPlanoDevGerenRecebimento() {
        return this.planoDevGerenRecebimento;
    }

    public void setPlanoDevGerenRecebimento(PlanoContaGerencial planoDevGerenRecebimento) {
        this.planoDevGerenRecebimento = planoDevGerenRecebimento;
    }

    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="ID_PC_DEVOL_GER_PAGAMENTO", foreignKey=@ForeignKey(name="FK_EMPRESA_CONT_PC_DEV_GER_PAG"))
    public PlanoContaGerencial getPlanoDevGerenPagamento() {
        return this.planoDevGerenPagamento;
    }

    public void setPlanoDevGerenPagamento(PlanoContaGerencial planoDevGerenPagamento) {
        this.planoDevGerenPagamento = planoDevGerenPagamento;
    }

    @Column(name="LANC_BAIXA_TITULOS")
    public Short getLancBaixaTitulos() {
        return this.lancBaixaTitulos;
    }

    public void setLancBaixaTitulos(Short lancBaixaTitulos) {
        this.lancBaixaTitulos = lancBaixaTitulos;
    }

    @Column(name="LANC_NOTA_PROPRIA")
    public Short getLancNotaPropria() {
        return this.lancNotaPropria;
    }

    public void setLancNotaPropria(Short lancNotaPropria) {
        this.lancNotaPropria = lancNotaPropria;
    }

    @Column(name="LANC_NOTA_TERCEIROS")
    public Short getLancNotaTerceiros() {
        return this.lancNotaTerceiros;
    }

    public void setLancNotaTerceiros(Short lancNotaTerceiros) {
        this.lancNotaTerceiros = lancNotaTerceiros;
    }

    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="ID_PC_EST_TERC_PROPRIO", foreignKey=@ForeignKey(name="FK_EMPRESA_CONT_PC_EST_TER_PROP"))
    public PlanoConta getPlanoContaEstProprio() {
        return this.planoContaEstProprio;
    }

    public void setPlanoContaEstProprio(PlanoConta planoContaEstProprio) {
        this.planoContaEstProprio = planoContaEstProprio;
    }

    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="ID_PC_EST_TERC_MEU", foreignKey=@ForeignKey(name="FK_EMPRESA_CONT_PC_EST_T_MEU"))
    public PlanoConta getPlanoContaEstTercMeu() {
        return this.planoContaEstTercMeu;
    }

    public void setPlanoContaEstTercMeu(PlanoConta planoContaEstTercMeu) {
        this.planoContaEstTercMeu = planoContaEstTercMeu;
    }

    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="ID_PC_EST_TERC_OUTROS", foreignKey=@ForeignKey(name="FK_EMPRESA_CONT_PC_EST_TERC_OUT"))
    public PlanoConta getPlanoContaEstTercOutros() {
        return this.planoContaEstTercOutros;
    }

    public void setPlanoContaEstTercOutros(PlanoConta planoContaEstTercOutros) {
        this.planoContaEstTercOutros = planoContaEstTercOutros;
    }

    @Column(name="ALTERAR_LANC_GERADO_MENTOR")
    public Short getAlterarLancGeradoMentor() {
        return this.alterarLancGeradoMentor;
    }

    public void setAlterarLancGeradoMentor(Short alterarLancGeradoMentor) {
        this.alterarLancGeradoMentor = alterarLancGeradoMentor;
    }

    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="ID_PESSOA", foreignKey=@ForeignKey(name="FK_EMPRESA_CONT_PESSOA"))
    public Pessoa getPessoa() {
        return this.pessoa;
    }

    public void setPessoa(Pessoa pessoa) {
        this.pessoa = pessoa;
    }

    @Column(name="GERAR_LANC_CUPONS")
    public Short getGerarLancamentosCupons() {
        return this.gerarLancamentosCupons;
    }

    public void setGerarLancamentosCupons(Short gerarLancamentosCupons) {
        this.gerarLancamentosCupons = gerarLancamentosCupons;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_UF_CRC", foreignKey=@ForeignKey(name="FK_EMPRESA_CONT_UF_CRC"))
    public UnidadeFederativa getUfExpedicaoCrc() {
        return this.ufExpedicaoCrc;
    }

    public void setUfExpedicaoCrc(UnidadeFederativa ufExpedicaoCrc) {
        this.ufExpedicaoCrc = ufExpedicaoCrc;
    }

    @Column(name="DATA_VALIDADE_CRC")
    @Temporal(value=TemporalType.DATE)
    public Date getDataValidadeCrc() {
        return this.dataValidadeCrc;
    }

    public void setDataValidadeCrc(Date dataValidadeCrc) {
        this.dataValidadeCrc = dataValidadeCrc;
    }

    @Column(name="DIA_IRRF_FOLHA")
    public Short getDiaIrrfFolha() {
        return this.diaIrrfFolha;
    }

    public void setDiaIrrfFolha(Short diaIrrfFolha) {
        this.diaIrrfFolha = diaIrrfFolha;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_PESSOA_IRRF_FOLHA", foreignKey=@ForeignKey(name="FK_EMPRESA_CONT_PESSOA_IRRF"))
    public Pessoa getPessoaIrrfFolha() {
        return this.pessoaIrrfFolha;
    }

    public void setPessoaIrrfFolha(Pessoa pessoaIrrfFolha) {
        this.pessoaIrrfFolha = pessoaIrrfFolha;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_PLANO_CONTA_IRRF_FOLHA", foreignKey=@ForeignKey(name="FK_EMPRESA_CONT_PC_IRRF_FOL"))
    public PlanoConta getPlanoContaIrrfFolha() {
        return this.planoContaIrrfFolha;
    }

    public void setPlanoContaIrrfFolha(PlanoConta planoContaIrrfFolha) {
        this.planoContaIrrfFolha = planoContaIrrfFolha;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_PLANO_IRRF_GER_FOLHA", foreignKey=@ForeignKey(name="FK_EMPRESA_CONT_PC_G_IRRF_FOL"))
    public PlanoContaGerencial getPlanoIrrfGerencialFolha() {
        return this.planoIrrfGerencialFolha;
    }

    public void setPlanoIrrfGerencialFolha(PlanoContaGerencial planoIrrfGerencialFolha) {
        this.planoIrrfGerencialFolha = planoIrrfGerencialFolha;
    }

    @Column(name="DIA_INSS_FOLHA")
    public Short getDiaInssFolha() {
        return this.diaInssFolha;
    }

    public void setDiaInssFolha(Short diaInssFolha) {
        this.diaInssFolha = diaInssFolha;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_PESSOA_INSS_FOLHA", foreignKey=@ForeignKey(name="FK_EMPRESA_CONT_PESSOA_INSS"))
    public Pessoa getPessoaInssFolha() {
        return this.pessoaInssFolha;
    }

    public void setPessoaInssFolha(Pessoa pessoaInssFolha) {
        this.pessoaInssFolha = pessoaInssFolha;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_PLANO_CONTA_INSS_FOLHA", foreignKey=@ForeignKey(name="FK_EMPRESA_CONT_PC_INSS_FOLHA"))
    public PlanoConta getPlanoContaInssFolha() {
        return this.planoContaInssFolha;
    }

    public void setPlanoContaInssFolha(PlanoConta planoContaInssFolha) {
        this.planoContaInssFolha = planoContaInssFolha;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_PLANO_INSS_GERENCIAL_FOLHA", foreignKey=@ForeignKey(name="FK_PLANO_GEREN_INSS_FOLHA_PAG"))
    public PlanoContaGerencial getPlanoInssGerencialFolha() {
        return this.planoInssGerencialFolha;
    }

    public void setPlanoInssGerencialFolha(PlanoContaGerencial planoInssGerencialFolha) {
        this.planoInssGerencialFolha = planoInssGerencialFolha;
    }

    @Column(name="DIA_FGTS_FOLHA")
    public Short getDiaFgtsFolha() {
        return this.diaFgtsFolha;
    }

    public void setDiaFgtsFolha(Short diaFgtsFolha) {
        this.diaFgtsFolha = diaFgtsFolha;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_PESSOA_FGTS", foreignKey=@ForeignKey(name="FK_EMPRESA_CONT_PESSOA_FGTS"))
    public Pessoa getPessoaFgtsFolha() {
        return this.pessoaFgtsFolha;
    }

    public void setPessoaFgtsFolha(Pessoa pessoaFgtsFolha) {
        this.pessoaFgtsFolha = pessoaFgtsFolha;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_PLANO_CONTA_FGTS", foreignKey=@ForeignKey(name="FK_EMPRESA_CONT_PC_FGTS"))
    public PlanoConta getPlanoContaFgtsFolha() {
        return this.planoContaFgtsFolha;
    }

    public void setPlanoContaFgtsFolha(PlanoConta planoContaFgtsFolha) {
        this.planoContaFgtsFolha = planoContaFgtsFolha;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_PLANO_CONTA_GERENCIAL_FGTS", foreignKey=@ForeignKey(name="FK_EMPRESA_CONT_PC_GER_FGTS"))
    public PlanoContaGerencial getPlanoFgtsGerencialFolha() {
        return this.planoFgtsGerencialFolha;
    }

    public void setPlanoFgtsGerencialFolha(PlanoContaGerencial planoFgtsGerencialFolha) {
        this.planoFgtsGerencialFolha = planoFgtsGerencialFolha;
    }

    @Column(name="DIA_DARF_FOLHA")
    public Short getDiaDarFolha() {
        return this.diaDarFolha;
    }

    public void setDiaDarFolha(Short diaDarFolha) {
        this.diaDarFolha = diaDarFolha;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_PESSOA_DARF", foreignKey=@ForeignKey(name="FK_EMPRESA_CONT_PES_DARF"))
    public Pessoa getPessoaDarFolha() {
        return this.pessoaDarFolha;
    }

    public void setPessoaDarFolha(Pessoa pessoaDarFolha) {
        this.pessoaDarFolha = pessoaDarFolha;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_PLANO_DARF_FOLHA", foreignKey=@ForeignKey(name="FK_EMPRESA_CONT_PC_DARF"))
    public PlanoConta getPlanoContaDarfFolha() {
        return this.planoContaDarfFolha;
    }

    public void setPlanoContaDarfFolha(PlanoConta planoContaDarfFolha) {
        this.planoContaDarfFolha = planoContaDarfFolha;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_PLANO_CONTA_DARF_GERENCIAL_F", foreignKey=@ForeignKey(name="FK_EMPRESA_CONT_PC_GER_DARF"))
    public PlanoContaGerencial getPlanoDarfGerencialFolha() {
        return this.planoDarfGerencialFolha;
    }

    public void setPlanoDarfGerencialFolha(PlanoContaGerencial planoDarfGerencialFolha) {
        this.planoDarfGerencialFolha = planoDarfGerencialFolha;
    }

    @Column(name="CNPJ_CONTABILIDADE", length=14)
    public String getCnpjContabilidade() {
        return this.cnpjContabilidade;
    }

    public void setCnpjContabilidade(String cnpjContabilidade) {
        this.cnpjContabilidade = cnpjContabilidade;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_PESSOA_GRRF", foreignKey=@ForeignKey(name="FK_EMPRESA_CONT_PES_GRRF"))
    public Pessoa getPessoaGrrf() {
        return this.pessoaGrrf;
    }

    public void setPessoaGrrf(Pessoa pessoaGrrf) {
        this.pessoaGrrf = pessoaGrrf;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_PLANO_CONTA_GRRF", foreignKey=@ForeignKey(name="FK_EMPRESA_CONT_PC_GRRF"))
    public PlanoConta getPlanoContaGrrf() {
        return this.planoContaGrrf;
    }

    public void setPlanoContaGrrf(PlanoConta planoContaGrrf) {
        this.planoContaGrrf = planoContaGrrf;
    }

    @JoinColumn(name="ID_PLANO_GRRF_GERENCIAL", foreignKey=@ForeignKey(name="FK_EMPRESA_CONT_PC_GER_GRRF"))
    @ManyToOne(fetch=FetchType.LAZY)
    public PlanoContaGerencial getPlanoGrrfGerencial() {
        return this.planoGrrfGerencial;
    }

    public void setPlanoGrrfGerencial(PlanoContaGerencial planoGrrfGerencial) {
        this.planoGrrfGerencial = planoGrrfGerencial;
    }

    @Column(name="GERAR_LANC_ADIANT_VIAGEM")
    public Short getGerarLancamentosAdiantamentosViagens() {
        return this.gerarLancamentosAdiantamentosViagens;
    }

    public void setGerarLancamentosAdiantamentosViagens(Short gerarLancamentosAdiantamentosViagens) {
        this.gerarLancamentosAdiantamentosViagens = gerarLancamentosAdiantamentosViagens;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_PC_GER_RENEGOCIACAO_PAG", foreignKey=@ForeignKey(name="FK_EMPRESA_CONT_PC_GER_REN_PAG"))
    public PlanoContaGerencial getPcGerRenegociacaoPag() {
        return this.pcGerRenegociacaoPag;
    }

    public void setPcGerRenegociacaoPag(PlanoContaGerencial pcGerRenegociacaoPag) {
        this.pcGerRenegociacaoPag = pcGerRenegociacaoPag;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_PC_GER_RENEGOCIACAO_REC", foreignKey=@ForeignKey(name="FK_EMPRESA_CONT_PC_GER_REN_REC"))
    public PlanoContaGerencial getPcGerRenegociacaoRec() {
        return this.pcGerRenegociacaoRec;
    }

    public void setPcGerRenegociacaoRec(PlanoContaGerencial pcGerRenegociacaoRec) {
        this.pcGerRenegociacaoRec = pcGerRenegociacaoRec;
    }

    @Column(name="DESCARTAR_LIQUIDO_RESCISAO")
    public Short getDescartarLiquidoRescisao() {
        return this.descartarLiquidoRescisao;
    }

    public void setDescartarLiquidoRescisao(Short descartarLiquidoRescisao) {
        this.descartarLiquidoRescisao = descartarLiquidoRescisao;
    }

    @Column(name="EMBUTIR_IPI_ICMS_OUTROS")
    public Short getEmbutirIpiIcmsOutros() {
        return this.embutirIpiIcmsOutros;
    }

    public void setEmbutirIpiIcmsOutros(Short embutirIpiIcmsOutros) {
        this.embutirIpiIcmsOutros = embutirIpiIcmsOutros;
    }

    @Column(name="EMBUTIR_ICMS_ST_ICMS_OUTROS")
    public Short getEmbutirIcmsStIcmsOutros() {
        return this.embutirIcmsStIcmsOutros;
    }

    public void setEmbutirIcmsStIcmsOutros(Short embutirIcmsStIcmsOutros) {
        this.embutirIcmsStIcmsOutros = embutirIcmsStIcmsOutros;
    }

    @Column(name="DIA_PIS_FOLHA")
    public Short getDiaPisFolha() {
        return this.diaPisFolha;
    }

    public void setDiaPisFolha(Short diaPisFolha) {
        this.diaPisFolha = diaPisFolha;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_PESSOA_PIS_FOLHA", foreignKey=@ForeignKey(name="FK_PESSOA_PIS_FOLHA_EMP_CONT"))
    public Pessoa getPessoaPisFolha() {
        return this.pessoaPisFolha;
    }

    public void setPessoaPisFolha(Pessoa pessoaPisFolha) {
        this.pessoaPisFolha = pessoaPisFolha;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_PLANO_CONTA_PIS_FOLHA", foreignKey=@ForeignKey(name="FK_PC_PIS_FOLHA_EMP_CONT"))
    public PlanoConta getPlanoContaPisFolha() {
        return this.planoContaPisFolha;
    }

    public void setPlanoContaPisFolha(PlanoConta planoContaPisFolha) {
        this.planoContaPisFolha = planoContaPisFolha;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_PLANO_GERENCIAL_PIS_FOLHA", foreignKey=@ForeignKey(name="FK_PLANO_GEREN_PIS_FOLHA_EMP_CO"))
    public PlanoContaGerencial getPlanoGerencialPisFolha() {
        return this.planoGerencialPisFolha;
    }

    public void setPlanoGerencialPisFolha(PlanoContaGerencial planoGerencialPisFolha) {
        this.planoGerencialPisFolha = planoGerencialPisFolha;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getIdentificador()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @Column(name="OPCAO_GERACAO_TITULO")
    public Short getOpcaoGerarTitulos() {
        return this.opcaoGerarTitulos;
    }

    public void setOpcaoGerarTitulos(Short opcaoGerarTitulos) {
        this.opcaoGerarTitulos = opcaoGerarTitulos;
    }

    @Column(name="GERAR_LANCAMENTO_CUPOM_RECEITA")
    public Short getGerarLancamentoCupomReceita() {
        return this.gerarLancamentoCupomReceita;
    }

    public void setGerarLancamentoCupomReceita(Short gerarLancamentoCupomReceita) {
        this.gerarLancamentoCupomReceita = gerarLancamentoCupomReceita;
    }

    @Column(name="GERAR_LANCAMENTO_CUPOM_DESPESA")
    public Short getGerarLancamentoCupomDespesa() {
        return this.gerarLancamentoCupomDespesa;
    }

    public void setGerarLancamentoCupomDespesa(Short gerarLancamentoCupomDespesa) {
        this.gerarLancamentoCupomDespesa = gerarLancamentoCupomDespesa;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_PC_TAXA_CAMBIAL_VARIACAO", foreignKey=@ForeignKey(name="FK_EMP_CONT_PC_TAXA_CAM_VARIACA"))
    public PlanoConta getPlanoContaTaxaCambialVariacao() {
        return this.planoContaTaxaCambialVariacao;
    }

    public void setPlanoContaTaxaCambialVariacao(PlanoConta planoContaTaxaCambialVariacao) {
        this.planoContaTaxaCambialVariacao = planoContaTaxaCambialVariacao;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_PC_TAXA_CAMBIAL_RECEITA", foreignKey=@ForeignKey(name="FK_EMP_CONT_PC_TAXA_CAM_RECEITA"))
    public PlanoConta getPlanoContaTaxaCambialReceita() {
        return this.planoContaTaxaCambialReceira;
    }

    public void setPlanoContaTaxaCambialReceita(PlanoConta planoContaTaxaCambialReceira) {
        this.planoContaTaxaCambialReceira = planoContaTaxaCambialReceira;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_PC_TAXA_CAMBIAL_DESESPESA", foreignKey=@ForeignKey(name="FK_EMP_CONT_PC_TAXA_CAM_DESESPE"))
    public PlanoConta getPlanoContaTaxaCambialDespesa() {
        return this.planoContaTaxaCambialDespesa;
    }

    public void setPlanoContaTaxaCambialDespesa(PlanoConta planoContaTaxaCambialDespesa) {
        this.planoContaTaxaCambialDespesa = planoContaTaxaCambialDespesa;
    }

    @Column(name="INTEGRAR_NF_TERC_BLOQUEIO_NF")
    public Short getIntegrarNFTerceirosBloqueioNF() {
        return this.integrarNFTerceirosBloqueioNF;
    }

    public void setIntegrarNFTerceirosBloqueioNF(Short integrarNFTerceirosBloqueioNF) {
        this.integrarNFTerceirosBloqueioNF = integrarNFTerceirosBloqueioNF;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_PC_TAXA_CAMBIAL_VARIACAO_PAG", foreignKey=@ForeignKey(name="FK_EMP_CONT_PC_TX_CAMB_VAR_PAG"))
    public PlanoConta getPlanoContaTaxaCambialVariacaoPag() {
        return this.planoContaTaxaCambialVariacaoPag;
    }

    public void setPlanoContaTaxaCambialVariacaoPag(PlanoConta planoContaTaxaCambialVariacaoPag) {
        this.planoContaTaxaCambialVariacaoPag = planoContaTaxaCambialVariacaoPag;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_PC_TAXA_CAMBIAL_RECEITA_PAG", foreignKey=@ForeignKey(name="FK_EMP_CONT_PC_TX_CAMB_REC_PAG"))
    public PlanoConta getPlanoContaTaxaCambialReceitaPag() {
        return this.planoContaTaxaCambialReceitaPag;
    }

    public void setPlanoContaTaxaCambialReceitaPag(PlanoConta planoContaTaxaCambialReceitaPag) {
        this.planoContaTaxaCambialReceitaPag = planoContaTaxaCambialReceitaPag;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_PC_TAXA_CAMBIAL_DESPESA_PAG", foreignKey=@ForeignKey(name="FK_EMP_CONT_PC_TX_CAMB_DESP_PAG"))
    public PlanoConta getPlanoContaTaxaCambialDespesaPag() {
        return this.planoContaTaxaCambialDespesaPag;
    }

    public void setPlanoContaTaxaCambialDespesaPag(PlanoConta planoContaTaxaCambialDespesaPag) {
        this.planoContaTaxaCambialDespesaPag = planoContaTaxaCambialDespesaPag;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_PC_TAXA_CAMB_VARIACAO_ANT", foreignKey=@ForeignKey(name="FK_EMP_CONT_PC_TX_CAMB_VAR_ANT"))
    public PlanoConta getPlanoContaTaxaCambialVariacaoAntecipado() {
        return this.planoContaTaxaCambialVariacaoAntecipado;
    }

    public void setPlanoContaTaxaCambialVariacaoAntecipado(PlanoConta planoContaTaxaCambialVariacaoAntecipado) {
        this.planoContaTaxaCambialVariacaoAntecipado = planoContaTaxaCambialVariacaoAntecipado;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_PC_TAXA_CAMBIAL_DESPESA_ANT", foreignKey=@ForeignKey(name="FK_EMP_CONT_PC_TX_CAMB_DESP_ANT"))
    public PlanoConta getPlanoContaTaxaCambialDespesaAntecipado() {
        return this.planoContaTaxaCambialDespesaAntecipado;
    }

    public void setPlanoContaTaxaCambialDespesaAntecipado(PlanoConta planoContaTaxaCambialDespesaAntecipado) {
        this.planoContaTaxaCambialDespesaAntecipado = planoContaTaxaCambialDespesaAntecipado;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_PC_TAXA_CAMBIAL_RECEITA_ANT", foreignKey=@ForeignKey(name="FK_EMP_CONT_PC_TX_CAMB_REC_ANT"))
    public PlanoConta getPlanoContaTaxaCambialReceitaAntecipado() {
        return this.planoContaTaxaCambialReceitaAntecipado;
    }

    public void setPlanoContaTaxaCambialReceitaAntecipado(PlanoConta planoContaTaxaCambialReceitaAntecipado) {
        this.planoContaTaxaCambialReceitaAntecipado = planoContaTaxaCambialReceitaAntecipado;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_PC_TAXA_CAMBIAL_VAR_PAG_ANT", foreignKey=@ForeignKey(name="FK_EMP_CONT_PC_TX_C_VAR_PAG_ANT"))
    public PlanoConta getPlanoContaTaxaCambialVariacaoPagAntecipado() {
        return this.planoContaTaxaCambialVariacaoPagAntecipado;
    }

    public void setPlanoContaTaxaCambialVariacaoPagAntecipado(PlanoConta planoContaTaxaCambialVariacaoPagAntecipado) {
        this.planoContaTaxaCambialVariacaoPagAntecipado = planoContaTaxaCambialVariacaoPagAntecipado;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_PC_TAXA_CAMB_DESP_PAG_ANT", foreignKey=@ForeignKey(name="FK_EMP_CONT_PC_TX_C_DES_PAG_ANT"))
    public PlanoConta getPlanoContaTaxaCambialDespesaPagAntecipado() {
        return this.planoContaTaxaCambialDespesaPagAntecipado;
    }

    public void setPlanoContaTaxaCambialDespesaPagAntecipado(PlanoConta planoContaTaxaCambialDespesaPagAntecipado) {
        this.planoContaTaxaCambialDespesaPagAntecipado = planoContaTaxaCambialDespesaPagAntecipado;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_PC_TAXA_CAMB_RECEIT_PAG_ANT", foreignKey=@ForeignKey(name="FK_EMP_CONT_PC_TX_C_REC_PAG_ANT"))
    public PlanoConta getPlanoContaTaxaCambialReceitaPagAntecipado() {
        return this.planoContaTaxaCambialReceitaPagAntecipado;
    }

    public void setPlanoContaTaxaCambialReceitaPagAntecipado(PlanoConta planoContaTaxaCambialReceitaPagAntecipado) {
        this.planoContaTaxaCambialReceitaPagAntecipado = planoContaTaxaCambialReceitaPagAntecipado;
    }

    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="ID_PLANO_CONTA_CHEQUE_TERCEIROS", foreignKey=@ForeignKey(name="FK_EMPRESA_CONT_PC_CONTA_CH_TER"))
    public PlanoConta getPlanoContaChequeTerceiros() {
        return this.planoContaChequeTerceiros;
    }

    public void setPlanoContaChequeTerceiros(PlanoConta planoContaChequeTerceiros) {
        this.planoContaChequeTerceiros = planoContaChequeTerceiros;
    }
}

