/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.EsocTipoContratoHorario;
import com.touchcomp.basementor.model.vo.EsocTipoJornadaTrabalho;
import com.touchcomp.basementor.model.vo.HorarioTrabalho;
import com.touchcomp.basementor.model.vo.InfoHorarioTrabalho;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.hibernate.annotations.Cascade;

@Entity
@Table(name="ESOC_CADASTRO_HORARIO")
public class EsocCadastroHorario
implements InterfaceVO {
    private Long identificador;
    private HorarioTrabalho horario;
    private Short permiteFlexibilidade = 1;
    private Short intervaloHorarioFixo = 1;
    private List<InfoHorarioTrabalho> listaHorario = new ArrayList<InfoHorarioTrabalho>();
    private Short escalaRevezamento = 0;
    private Double horasTrabalhadasRevezamento = 0.0;
    private Double horasFolgasRevezamento = 0.0;
    private Short escalaDiferenciada = 0;
    private String descricaoEscalaDiferenciada;
    private EsocTipoJornadaTrabalho tipoJornada;
    private EsocTipoContratoHorario esocTipoContrato;
    private InfoHorarioTrabalho infoHorario;
    private Date dataInicio;
    private Short ativo = 1;
    private Short informarJornada = 0;
    private Short possuiHoraNoturna = 0;

    @Id
    @Column(nullable=false, unique=true, name="ID_ESOC_CAD_HORARIO")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_ESOC_CAD_HORARIO")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @OneToOne(mappedBy="esocCadastroHorario")
    public HorarioTrabalho getHorario() {
        return this.horario;
    }

    public void setHorario(HorarioTrabalho horario) {
        this.horario = horario;
    }

    @Column(name="PERMITE_FLEXIBILIDADE")
    public Short getPermiteFlexibilidade() {
        return this.permiteFlexibilidade;
    }

    public void setPermiteFlexibilidade(Short permiteFlexibilidade) {
        this.permiteFlexibilidade = permiteFlexibilidade;
    }

    @Column(name="INTERVALO_HORARIO_FIXO")
    public Short getIntervaloHorarioFixo() {
        return this.intervaloHorarioFixo;
    }

    public void setIntervaloHorarioFixo(Short intervaloHorarioFixo) {
        this.intervaloHorarioFixo = intervaloHorarioFixo;
    }

    @OneToMany(fetch=FetchType.LAZY, mappedBy="esocCadastroHorario", cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH, CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.DELETE_ORPHAN, org.hibernate.annotations.CascadeType.ALL})
    public List<InfoHorarioTrabalho> getListaHorario() {
        return this.listaHorario;
    }

    public void setListaHorario(List<InfoHorarioTrabalho> listaHorario) {
        this.listaHorario = listaHorario;
    }

    @Column(name="ESCALA_REVEZAMENTO")
    public Short getEscalaRevezamento() {
        return this.escalaRevezamento;
    }

    public void setEscalaRevezamento(Short escalaRevezamento) {
        this.escalaRevezamento = escalaRevezamento;
    }

    @Column(name="HORAS_TRABALHADAS_REVEZAMENTO", precision=15, scale=2)
    public Double getHorasTrabalhadasRevezamento() {
        return this.horasTrabalhadasRevezamento;
    }

    public void setHorasTrabalhadasRevezamento(Double horasTrabalhadasRevezamento) {
        this.horasTrabalhadasRevezamento = horasTrabalhadasRevezamento;
    }

    @Column(name="HORAS_FOLGAS_REVEZAMENTO", precision=15, scale=2)
    public Double getHorasFolgasRevezamento() {
        return this.horasFolgasRevezamento;
    }

    public void setHorasFolgasRevezamento(Double horasFolgasRevezamento) {
        this.horasFolgasRevezamento = horasFolgasRevezamento;
    }

    @Column(name="ESCALA_DIFERENCIADA")
    public Short getEscalaDiferenciada() {
        return this.escalaDiferenciada;
    }

    public void setEscalaDiferenciada(Short escalaDiferenciada) {
        this.escalaDiferenciada = escalaDiferenciada;
    }

    @Column(name="DESCRICAO_ESCALA_DIFERENCIADA", length=500)
    public String getDescricaoEscalaDiferenciada() {
        return this.descricaoEscalaDiferenciada;
    }

    public void setDescricaoEscalaDiferenciada(String descricaoEscalaDiferenciada) {
        this.descricaoEscalaDiferenciada = descricaoEscalaDiferenciada;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_ESOC_TIPO_JORNADA", foreignKey=@ForeignKey(name="FK_ESOC_CADASTRO_HORARIO_2"))
    public EsocTipoJornadaTrabalho getTipoJornada() {
        return this.tipoJornada;
    }

    public void setTipoJornada(EsocTipoJornadaTrabalho tipoJornada) {
        this.tipoJornada = tipoJornada;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_ESOC_TIPO_CONTRATO", foreignKey=@ForeignKey(name="FK_ESOC_CADASTRO_HORARIO_3"))
    public EsocTipoContratoHorario getEsocTipoContrato() {
        return this.esocTipoContrato;
    }

    public void setEsocTipoContrato(EsocTipoContratoHorario esocTipoContrato) {
        this.esocTipoContrato = esocTipoContrato;
    }

    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @JoinColumn(name="ID_INFO_HORARIO_TRABALHO", foreignKey=@ForeignKey(name="FK_ESOC_HORARIO_INFO_H"))
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN, org.hibernate.annotations.CascadeType.ALL})
    public InfoHorarioTrabalho getInfoHorario() {
        return this.infoHorario;
    }

    public void setInfoHorario(InfoHorarioTrabalho infoHorario) {
        this.infoHorario = infoHorario;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getIdentificador()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @Column(name="DATA_INICIO")
    @Temporal(value=TemporalType.DATE)
    public Date getDataInicio() {
        return this.dataInicio;
    }

    public void setDataInicio(Date dataInicio) {
        this.dataInicio = dataInicio;
    }

    @Column(name="ATIVO")
    public Short getAtivo() {
        return this.ativo;
    }

    public void setAtivo(Short ativo) {
        this.ativo = ativo;
    }

    @Column(name="INFORMAR_JORNADA")
    public Short getInformarJornada() {
        return this.informarJornada;
    }

    public void setInformarJornada(Short informarJornada) {
        this.informarJornada = informarJornada;
    }

    @Column(name="possui_hora_noturna")
    public Short getPossuiHoraNoturna() {
        return this.possuiHoraNoturna;
    }

    public void setPossuiHoraNoturna(Short possuiHoraNoturna) {
        this.possuiHoraNoturna = possuiHoraNoturna;
    }
}

