/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.constants.enums.rh.EnumIndicativoApuracao;
import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.interfaces.InterfaceVOEsocial;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.EsocPreEvento;
import com.touchcomp.basementor.model.vo.GrupoEmpresa;
import com.touchcomp.basementor.model.vo.Pessoa;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Version;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;

@Entity
@Table(name="ESOC_FECHA_EVENTO_PERIODICO")
public class EsocFechamentoEventosPeriodicos
implements InterfaceVO,
InterfaceVOEsocial {
    private Long identificador;
    private Empresa empresa;
    private Date dataCadastro;
    private Timestamp dataAtualizacao;
    private GrupoEmpresa grupoEmpresa;
    private Pessoa pessoaResponsavel;
    private Short possuiInformacaoRemunecao = 0;
    private Short possuiInformacaoRedimentos = 0;
    private Short possuiInformacaoAquisicaoRural = 0;
    private Short possuiInformacaoComercializacaoProdutos = 0;
    private Short possuiContratacaoAvulsos = 0;
    private Short possuiDesoneracaoFolha = 0;
    private Date primeiroPeriodoSemMovimento;
    private Date periodoReferencia;
    private List<EsocPreEvento> preEventosEsocial;
    private Short indicativoApuracao = EnumIndicativoApuracao.FOLHA_MENSAL.getEnumId();

    public EsocFechamentoEventosPeriodicos() {
        this.preEventosEsocial = new ArrayList<EsocPreEvento>();
    }

    @Id
    @Column(nullable=false, unique=true, name="ID_ESOC_FECH_EVENTO_PERIOD")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_ESOC_FECH_EVENTO_PERIODICO")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_ESOC_FECH_EVENTOS_EMPRESA"))
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    @Column(name="DATA_CADASTRO")
    @Temporal(value=TemporalType.DATE)
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @Version
    @Column(name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_GRUPO_EMPRESA", foreignKey=@ForeignKey(name="FK_GRUPO_EMPRESA_FEC_EVET_PERIO"))
    public GrupoEmpresa getGrupoEmpresa() {
        return this.grupoEmpresa;
    }

    public void setGrupoEmpresa(GrupoEmpresa grupoEmpresa) {
        this.grupoEmpresa = grupoEmpresa;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_PESSOAL_RESPONSAVEL", foreignKey=@ForeignKey(name="FK_PESSOA_RESPONSAVEL_ESOC_FEC"))
    public Pessoa getPessoaResponsavel() {
        return this.pessoaResponsavel;
    }

    public void setPessoaResponsavel(Pessoa pessoaResponsavel) {
        this.pessoaResponsavel = pessoaResponsavel;
    }

    @Column(name="POSSUI_INF_REMUNERACAO")
    public Short getPossuiInformacaoRemunecao() {
        return this.possuiInformacaoRemunecao;
    }

    public void setPossuiInformacaoRemunecao(Short possuiInformacaoRemunecao) {
        this.possuiInformacaoRemunecao = possuiInformacaoRemunecao;
    }

    @Column(name="POSSUI_INF_RENDIMENTOS")
    public Short getPossuiInformacaoRedimentos() {
        return this.possuiInformacaoRedimentos;
    }

    public void setPossuiInformacaoRedimentos(Short possuiInformacaoRedimentos) {
        this.possuiInformacaoRedimentos = possuiInformacaoRedimentos;
    }

    @Column(name="POSSUI_INF_AQUISI_RURAL")
    public Short getPossuiInformacaoAquisicaoRural() {
        return this.possuiInformacaoAquisicaoRural;
    }

    public void setPossuiInformacaoAquisicaoRural(Short possuiInformacaoAquisicaoRural) {
        this.possuiInformacaoAquisicaoRural = possuiInformacaoAquisicaoRural;
    }

    @Column(name="POSSUI_INF_COMERC_PRODUTOS")
    public Short getPossuiInformacaoComercializacaoProdutos() {
        return this.possuiInformacaoComercializacaoProdutos;
    }

    public void setPossuiInformacaoComercializacaoProdutos(Short possuiInformacaoComercializacaoProdutos) {
        this.possuiInformacaoComercializacaoProdutos = possuiInformacaoComercializacaoProdutos;
    }

    @Column(name="POSSUI_CONTRATACAO_AVULSOS")
    public Short getPossuiContratacaoAvulsos() {
        return this.possuiContratacaoAvulsos;
    }

    public void setPossuiContratacaoAvulsos(Short possuiContratacaoAvulsos) {
        this.possuiContratacaoAvulsos = possuiContratacaoAvulsos;
    }

    @Column(name="POSSUI_DESONERACAO_FOLHA")
    public Short getPossuiDesoneracaoFolha() {
        return this.possuiDesoneracaoFolha;
    }

    public void setPossuiDesoneracaoFolha(Short possuiDesoneracaoFolha) {
        this.possuiDesoneracaoFolha = possuiDesoneracaoFolha;
    }

    @Column(name="PRIMEIRO_PERIODO_SEM_MOVIMENTO")
    @Temporal(value=TemporalType.DATE)
    public Date getPrimeiroPeriodoSemMovimento() {
        return this.primeiroPeriodoSemMovimento;
    }

    public void setPrimeiroPeriodoSemMovimento(Date primeiroPeriodoSemMovimento) {
        this.primeiroPeriodoSemMovimento = primeiroPeriodoSemMovimento;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getIdentificador()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @Column(name="PERIODO_REFERENCIA")
    @Temporal(value=TemporalType.DATE)
    public Date getPeriodoReferencia() {
        return this.periodoReferencia;
    }

    public void setPeriodoReferencia(Date periodoReferencia) {
        this.periodoReferencia = periodoReferencia;
    }

    @Override
    @OneToMany(mappedBy="fechamentoEventos")
    @Cascade(value={CascadeType.DELETE_ORPHAN, CascadeType.ALL})
    public List<EsocPreEvento> getPreEventosEsocial() {
        return this.preEventosEsocial;
    }

    public void setPreEventosEsocial(List<EsocPreEvento> preEventosEsocial) {
        this.preEventosEsocial = preEventosEsocial;
    }

    @Column(name="INDICATIVO_APURACAO")
    public Short getIndicativoApuracao() {
        return this.indicativoApuracao;
    }

    public void setIndicativoApuracao(Short indicativoApuracao) {
        this.indicativoApuracao = indicativoApuracao;
    }
}

