/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.interfaces.InterfaceVOEsocial;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.EsocExtensaoDecisaoRubrica;
import com.touchcomp.basementor.model.vo.EsocPreEvento;
import com.touchcomp.basementor.model.vo.TabelaProcessosEsoc;
import com.touchcomp.basementor.model.vo.TipoCalculoEvento;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Version;

@Entity
@Table(name="ESOC_TABELA_PROCESSO_ORIGEM")
public class EsocTabelaProcessoOrigem
implements InterfaceVO,
InterfaceVOEsocial {
    private Long identificador;
    private Timestamp dataAtualizacao;
    private Date dataCadastro;
    private Empresa empresa;
    private TipoCalculoEvento tipoCalculoEvento;
    private Short processoInss = 0;
    private Short processoFgts = 0;
    private Short processoIrrf = 0;
    private TabelaProcessosEsoc tabelaProcesso;
    private String descricao;
    private EsocExtensaoDecisaoRubrica extensaoDecisaoRubrica;
    private List<EsocPreEvento> preEventosEsocial = new ArrayList<EsocPreEvento>();
    private Date dataInicioValidade;
    private Date dataFinalValidade;

    @Id
    @Column(nullable=false, unique=true, name="ID_ESOC_TAB_PROC_ORIGEM")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_ESOC_TAB_PROC_ORIGEM")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @Version
    @Column(name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_CADASTRO")
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_ESOC_TAB_PROCESSO_ORIG_EMPRE"))
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_TIPO_CALCULO_EVENTO", foreignKey=@ForeignKey(name="FK_TIPO_CALCULO_EVENTO_TAB_PROC"))
    public TipoCalculoEvento getTipoCalculoEvento() {
        return this.tipoCalculoEvento;
    }

    public void setTipoCalculoEvento(TipoCalculoEvento tipoCalculoEvento) {
        this.tipoCalculoEvento = tipoCalculoEvento;
    }

    @Column(name="PROCESSO_INSS")
    public Short getProcessoInss() {
        return this.processoInss;
    }

    public void setProcessoInss(Short processoInss) {
        this.processoInss = processoInss;
    }

    @Column(name="PROCESSO_FGTS")
    public Short getProcessoFgts() {
        return this.processoFgts;
    }

    public void setProcessoFgts(Short processoFgts) {
        this.processoFgts = processoFgts;
    }

    @Column(name="PROCESSO_IRRF")
    public Short getProcessoIrrf() {
        return this.processoIrrf;
    }

    public void setProcessoIrrf(Short processoIrrf) {
        this.processoIrrf = processoIrrf;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_TABELA_PROCESSO_ESOC", foreignKey=@ForeignKey(name="FK_TAB_PROCESSO_PROC_ORIGEM"))
    public TabelaProcessosEsoc getTabelaProcesso() {
        return this.tabelaProcesso;
    }

    public void setTabelaProcesso(TabelaProcessosEsoc tabelaProcesso) {
        this.tabelaProcesso = tabelaProcesso;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getIdentificador()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @Column(name="DESCRICAO", length=100)
    public String getDescricao() {
        return this.descricao;
    }

    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_ESOC_EXTENSAO_DECISAO_RUB", foreignKey=@ForeignKey(name="FK_ESOC_EXTENSAO_DEC_RUB_TAB"))
    public EsocExtensaoDecisaoRubrica getExtensaoDecisaoRubrica() {
        return this.extensaoDecisaoRubrica;
    }

    public void setExtensaoDecisaoRubrica(EsocExtensaoDecisaoRubrica extensaoDecisaoRubrica) {
        this.extensaoDecisaoRubrica = extensaoDecisaoRubrica;
    }

    @Override
    @OneToMany(mappedBy="tabelaProcessoOrigem")
    public List<EsocPreEvento> getPreEventosEsocial() {
        return this.preEventosEsocial;
    }

    public void setPreEventosEsocial(List<EsocPreEvento> preEventosEsocial) {
        this.preEventosEsocial = preEventosEsocial;
    }

    @Column(name="DATA_INICIO_VALIDADE")
    @Temporal(value=TemporalType.DATE)
    public Date getDataInicioValidade() {
        return this.dataInicioValidade;
    }

    public void setDataInicioValidade(Date dataInicioValidade) {
        this.dataInicioValidade = dataInicioValidade;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_FINAL_VALIDADE")
    public Date getDataFinalValidade() {
        return this.dataFinalValidade;
    }

    public void setDataFinalValidade(Date dataFinalValidade) {
        this.dataFinalValidade = dataFinalValidade;
    }
}

