/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.AlteracaoEstoqueTerceiros;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.GradeItemNotaFiscalPropria;
import com.touchcomp.basementor.model.vo.GradeItemNotaTerceiros;
import com.touchcomp.basementor.model.vo.ItemRequisicao;
import com.touchcomp.basementor.model.vo.NaturezaOperacao;
import com.touchcomp.basementor.model.vo.Pessoa;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.hibernate.annotations.Cascade;

@Entity
@Table(name="ESTOQUE_TERCEIROS")
public class EstoqueTerceiros
implements InterfaceVO {
    private Long identificador;
    private ItemRequisicao itemRequisicao;
    private Pessoa pessoaParceiro;
    private Short desativaMovTerceiros = 0;
    private NaturezaOperacao naturezaOperacao;
    private Date data;
    private Empresa empresa;
    private EstoqueTerceiros estoqueTerceirosMae;
    private List<EstoqueTerceiros> estoqueTercFilhos;
    private List<AlteracaoEstoqueTerceiros> alteracaoEstoqueTerceiros = new ArrayList<AlteracaoEstoqueTerceiros>();
    private GradeItemNotaFiscalPropria gradeItemNotaPropria;
    private GradeItemNotaTerceiros gradeItemNotaTerceiros;
    private Double quantidade = 0.0;

    public EstoqueTerceiros() {
        this.estoqueTercFilhos = new ArrayList<EstoqueTerceiros>();
    }

    @Id
    @Column(nullable=false, name="ID_ESTOQUE_TERCEIROS")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_ESTOQUE_TERCEIROS")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @JoinColumn(name="ID_ITEM_REQUISICAO", foreignKey=@ForeignKey(name="FK_ESTOQUE_TERC_ITEM_REQUISICAO"))
    @OneToOne(targetEntity=ItemRequisicao.class, fetch=FetchType.LAZY)
    public ItemRequisicao getItemRequisicao() {
        return this.itemRequisicao;
    }

    public void setItemRequisicao(ItemRequisicao itemRequisicao) {
        this.itemRequisicao = itemRequisicao;
    }

    @JoinColumn(name="ID_PESSOA_PARCEIRO", foreignKey=@ForeignKey(name="FK_ESTOQUE_TERC_PESSOA"))
    @ManyToOne(fetch=FetchType.LAZY)
    public Pessoa getPessoaParceiro() {
        return this.pessoaParceiro;
    }

    public void setPessoaParceiro(Pessoa pessoaParceiro) {
        this.pessoaParceiro = pessoaParceiro;
    }

    @Column(name="DESATIVA_MOV_TERCEIROS")
    public Short getDesativaMovTerceiros() {
        return this.desativaMovTerceiros;
    }

    public void setDesativaMovTerceiros(Short desativaMovTerceiros) {
        this.desativaMovTerceiros = desativaMovTerceiros;
    }

    @JoinColumn(name="ID_NATUREZA_OPERACAO", foreignKey=@ForeignKey(name="FK_ESTOQUE_TERC_NATUREZA_OPERAC"))
    @ManyToOne(fetch=FetchType.LAZY)
    public NaturezaOperacao getNaturezaOperacao() {
        return this.naturezaOperacao;
    }

    public void setNaturezaOperacao(NaturezaOperacao naturezaOperacao) {
        this.naturezaOperacao = naturezaOperacao;
    }

    @Column(name="DATA")
    @Temporal(value=TemporalType.DATE)
    public Date getData() {
        return this.data;
    }

    public void setData(Date data) {
        this.data = data;
    }

    @JoinColumn(name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_ESTOQUE_TERC_EMPRESA"))
    @ManyToOne(fetch=FetchType.LAZY)
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    @JoinColumn(name="ID_ESTOQUE_TERC_MAE", foreignKey=@ForeignKey(name="FK_ESTOQUE_TERC_ESTOQU_TERC_MAE"))
    @ManyToOne(fetch=FetchType.LAZY)
    public EstoqueTerceiros getEstoqueTerceirosMae() {
        return this.estoqueTerceirosMae;
    }

    public void setEstoqueTerceirosMae(EstoqueTerceiros estoqueTerceirosMae) {
        this.estoqueTerceirosMae = estoqueTerceirosMae;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getIdentificador()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @OneToMany(mappedBy="estoqueTerceirosMae")
    public List<EstoqueTerceiros> getEstoqueTercFilhos() {
        return this.estoqueTercFilhos;
    }

    public void setEstoqueTercFilhos(List<EstoqueTerceiros> estoqueTercFilhos) {
        this.estoqueTercFilhos = estoqueTercFilhos;
    }

    @OneToMany(mappedBy="estoqueTerceiros", fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN, org.hibernate.annotations.CascadeType.ALL})
    public List<AlteracaoEstoqueTerceiros> getAlteracaoEstoqueTerceiros() {
        return this.alteracaoEstoqueTerceiros;
    }

    public void setAlteracaoEstoqueTerceiros(List<AlteracaoEstoqueTerceiros> alteracaoEstoqueTerceiros) {
        this.alteracaoEstoqueTerceiros = alteracaoEstoqueTerceiros;
    }

    @JoinColumn(name="ID_GRADE_ITEM_NOTA_PROPRIA", foreignKey=@ForeignKey(name="FK_ESTOQUE_TERC_GRADE_ITEM_NP"))
    @OneToOne(fetch=FetchType.LAZY)
    public GradeItemNotaFiscalPropria getGradeItemNotaPropria() {
        return this.gradeItemNotaPropria;
    }

    public void setGradeItemNotaPropria(GradeItemNotaFiscalPropria gradeItemNotaPropria) {
        this.gradeItemNotaPropria = gradeItemNotaPropria;
    }

    @JoinColumn(name="ID_GRADE_ITEM_NOTA_TERCEIROS", foreignKey=@ForeignKey(name="FK_ESTOQUE_TERC_GRADE_ITEM_NT"))
    @OneToOne(fetch=FetchType.LAZY)
    public GradeItemNotaTerceiros getGradeItemNotaTerceiros() {
        return this.gradeItemNotaTerceiros;
    }

    public void setGradeItemNotaTerceiros(GradeItemNotaTerceiros gradeItemNotaTerceiros) {
        this.gradeItemNotaTerceiros = gradeItemNotaTerceiros;
    }

    @Column(name="QUANTIDADE", precision=15, scale=6)
    public Double getQuantidade() {
        return this.quantidade;
    }

    public void setQuantidade(Double quantidade) {
        this.quantidade = quantidade;
    }
}

