/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.CalculoInssEmpresa;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.LogExclusaoFechamentoPeriodo;
import com.touchcomp.basementor.model.vo.Titulo;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.hibernate.annotations.Cascade;

@Entity
@Table(name="FECHAMENTO_PERIODO_FOLHA")
public class FechamentoPeriodo
implements InterfaceVO {
    private Long identificador;
    private Empresa empresa;
    private Date dataCadastro;
    private List<Titulo> titulos = new ArrayList<Titulo>();
    private Timestamp dataAtualizacao;
    private CalculoInssEmpresa calculoInss;
    private LogExclusaoFechamentoPeriodo logExclusaoFechamentoPeriodo;
    private Short ativo = EnumConstantsMentorSimNao.SIM.getValue();

    @Id
    @Column(nullable=false, unique=true, name="ID_FECHAMENTO_PERIODO_FOLHA")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_FECHAMENTO_FOLHA")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_FECH_PERIODO_FOLHA_EMP"))
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    @Column(name="DATA_CADASTRO")
    @Temporal(value=TemporalType.DATE)
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @OneToMany(mappedBy="fechamentoFolha", fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public List<Titulo> getTitulos() {
        return this.titulos;
    }

    public void setTitulos(List<Titulo> titulos) {
        this.titulos = titulos;
    }

    @Column(name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_CALCULO_INSS", foreignKey=@ForeignKey(name="FK_FECHAMENTO_PERIODO_INSS"))
    public CalculoInssEmpresa getCalculoInss() {
        return this.calculoInss;
    }

    public void setCalculoInss(CalculoInssEmpresa calculoInss) {
        this.calculoInss = calculoInss;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_LOG_EXCLUSAO_FECHAMENTO", foreignKey=@ForeignKey(name="FK_FECHAMENTO_PERIODO_LOG"))
    @Cascade(value={org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.MERGE})
    public LogExclusaoFechamentoPeriodo getLogExclusaoFechamentoPeriodo() {
        return this.logExclusaoFechamentoPeriodo;
    }

    public void setLogExclusaoFechamentoPeriodo(LogExclusaoFechamentoPeriodo logExclusaoFechamentoPeriodo) {
        this.logExclusaoFechamentoPeriodo = logExclusaoFechamentoPeriodo;
    }

    @Column(nullable=false, name="ATIVO")
    public Short getAtivo() {
        return this.ativo;
    }

    public void setAtivo(Short ativo) {
        this.ativo = ativo;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getCalculoInss()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }
}

