/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.FormulacaoFasesTpProdSped;
import com.touchcomp.basementor.model.vo.ItemFormulacaoFases;
import com.touchcomp.basementor.model.vo.RoteiroProducao;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Version;
import org.hibernate.annotations.Cascade;

@Entity
@Table(name="FORMULACAO_FASES")
public class FormulacaoFases
implements InterfaceVO {
    private Long identificador;
    private String descricao;
    private Empresa empresa;
    private Timestamp dataAtualizacao;
    private Date dataCadastro;
    private RoteiroProducao roteiroProducao;
    private List<ItemFormulacaoFases> itemFormulacaoFases = new ArrayList<ItemFormulacaoFases>();
    private List<FormulacaoFasesTpProdSped> tiposProducaoSped = new ArrayList<FormulacaoFasesTpProdSped>();
    private Short formulacaoLivre = 0;
    private Short principal = 1;
    private Short ativo = 1;
    private String revisao;

    @Id
    @Column(nullable=false, unique=true, name="ID_FORMULACAO_FASES")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_FORMULACAO_FASES")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @Column(name="DESCRICAO", length=200)
    public String getDescricao() {
        return this.descricao;
    }

    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_FORMULACAO_FASES_EMPRESA"))
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    @Version
    @Column(name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(nullable=false, name="DATA_CADASTRO")
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_ROTEIRO_PRODUCAO", foreignKey=@ForeignKey(name="FK_FORMULACAO_FASES_ROT_PROD"))
    public RoteiroProducao getRoteiroProducao() {
        return this.roteiroProducao;
    }

    public void setRoteiroProducao(RoteiroProducao roteiroProducao) {
        this.roteiroProducao = roteiroProducao;
    }

    @OneToMany(fetch=FetchType.LAZY, cascade={CascadeType.ALL}, mappedBy="formulacaoFases")
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE, org.hibernate.annotations.CascadeType.DELETE_ORPHAN, org.hibernate.annotations.CascadeType.ALL})
    public List<ItemFormulacaoFases> getItemFormulacaoFases() {
        return this.itemFormulacaoFases;
    }

    public void setItemFormulacaoFases(List<ItemFormulacaoFases> itemFormulacaoFases) {
        this.itemFormulacaoFases = itemFormulacaoFases;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0} - {1}", (Object[])new Object[]{this.getIdentificador(), this.getDescricao()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @Column(name="FORMULACAO_LIVRE")
    public Short getFormulacaoLivre() {
        return this.formulacaoLivre;
    }

    public void setFormulacaoLivre(Short formulacaoLivre) {
        this.formulacaoLivre = formulacaoLivre;
    }

    @Column(name="PRINCIPAL")
    public Short getPrincipal() {
        return this.principal;
    }

    public void setPrincipal(Short principal) {
        this.principal = principal;
    }

    @Column(name="ATIVO")
    public Short getAtivo() {
        return this.ativo;
    }

    public void setAtivo(Short ativo) {
        this.ativo = ativo;
    }

    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true, mappedBy="formulacaoFases")
    public List<FormulacaoFasesTpProdSped> getTiposProducaoSped() {
        return this.tiposProducaoSped;
    }

    public void setTiposProducaoSped(List<FormulacaoFasesTpProdSped> tiposProducaoSped) {
        this.tiposProducaoSped = tiposProducaoSped;
    }

    @Column(name="REVISAO")
    public String getRevisao() {
        return this.revisao;
    }

    public void setRevisao(String revisao) {
        this.revisao = revisao;
    }
}

