/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.FinalidadeArquivoManad;
import com.touchcomp.basementor.model.vo.IndicadorCentralizacaoEscrituracao;
import com.touchcomp.basementor.model.vo.IndicadorEntradaDados;
import com.touchcomp.basementor.model.vo.Pessoa;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Version;

@Entity
@Table(name="GERACAO_ARQUIVO_MANAD")
public class GeracaoArquivoManad
implements InterfaceVO {
    private Long identificador;
    private Date dataCadastro;
    private Timestamp dataAtualizacao;
    private Empresa empresa;
    private Date periodoInicial;
    private Date periodoFinal;
    private IndicadorEntradaDados indicadorEntradaDados;
    private IndicadorCentralizacaoEscrituracao indicadorCentralizacao;
    private FinalidadeArquivoManad finalidadeArquivoManad;
    private Pessoa pessoaContabilidade;
    private String cpfContador;
    private String crcContador;
    private Date inicioPrestContabilidade;
    private Date fimPrestContabilidade;
    private Pessoa pessoaInformatica;
    private String cpfTecnicoInformatica;
    private String cargoEmpresaInformatica;
    private Date inicioPrestInformatica;
    private Date fimPrestInformatica;

    @Id
    @Column(nullable=false, unique=true, name="ID_GERACAO_ARQUIVO_MANAD")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_GERACAO_ARQUIVO_MANAD")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @Column(name="DATA_CADASTRO")
    @Temporal(value=TemporalType.DATE)
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @Version
    @Column(name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @JoinColumn(name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_GERACAO_ARQUIVO_MANAD_EMPRES"))
    @ManyToOne(fetch=FetchType.LAZY)
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    @Column(name="PERIODO_INICIAL_MANAD")
    @Temporal(value=TemporalType.DATE)
    public Date getPeriodoInicial() {
        return this.periodoInicial;
    }

    public void setPeriodoInicial(Date periodoInicial) {
        this.periodoInicial = periodoInicial;
    }

    @Column(name="PERIODO_FINAL_MANAD")
    @Temporal(value=TemporalType.DATE)
    public Date getPeriodoFinal() {
        return this.periodoFinal;
    }

    public void setPeriodoFinal(Date periodoFinal) {
        this.periodoFinal = periodoFinal;
    }

    @JoinColumn(name="ID_INDICADOR_ENTRADA_DADOS", foreignKey=@ForeignKey(name="FK_GERACAO_ARQUIVO_MANAD_ENTRAD"))
    @ManyToOne(fetch=FetchType.LAZY)
    public IndicadorEntradaDados getIndicadorEntradaDados() {
        return this.indicadorEntradaDados;
    }

    public void setIndicadorEntradaDados(IndicadorEntradaDados indicadorEntradaDados) {
        this.indicadorEntradaDados = indicadorEntradaDados;
    }

    @JoinColumn(name="ID_INDICADOR_ESCRITURACAO", foreignKey=@ForeignKey(name="FK_GERACAO_ARQUIVO_MANAD_ESCRIT"))
    @ManyToOne(fetch=FetchType.LAZY)
    public IndicadorCentralizacaoEscrituracao getIndicadorCentralizacao() {
        return this.indicadorCentralizacao;
    }

    public void setIndicadorCentralizacao(IndicadorCentralizacaoEscrituracao indicadorCentralizacao) {
        this.indicadorCentralizacao = indicadorCentralizacao;
    }

    @JoinColumn(name="ID_FINALIDADE_ARQUIVO_MANAD", foreignKey=@ForeignKey(name="FK_GERACAO_ARQUIVO_MANAD_FINALI"))
    @ManyToOne(fetch=FetchType.LAZY)
    public FinalidadeArquivoManad getFinalidadeArquivoManad() {
        return this.finalidadeArquivoManad;
    }

    public void setFinalidadeArquivoManad(FinalidadeArquivoManad finalidadeArquivoManad) {
        this.finalidadeArquivoManad = finalidadeArquivoManad;
    }

    @JoinColumn(name="ID_PESSOA_CONTABILIDADE", foreignKey=@ForeignKey(name="FK_GERACAO_ARQUIVO_MANAD_CONTAB"))
    @ManyToOne(fetch=FetchType.LAZY)
    public Pessoa getPessoaContabilidade() {
        return this.pessoaContabilidade;
    }

    public void setPessoaContabilidade(Pessoa pessoaContabilidade) {
        this.pessoaContabilidade = pessoaContabilidade;
    }

    @Column(name="CPF_CONTADOR", length=20)
    public String getCpfContador() {
        return this.cpfContador;
    }

    public void setCpfContador(String cpfContador) {
        this.cpfContador = cpfContador;
    }

    @Column(name="CRC_CONTADOR", length=20)
    public String getCrcContador() {
        return this.crcContador;
    }

    public void setCrcContador(String crcContador) {
        this.crcContador = crcContador;
    }

    @Column(name="INICIO_PREST_SERV_CONTABILIDADE")
    @Temporal(value=TemporalType.DATE)
    public Date getInicioPrestContabilidade() {
        return this.inicioPrestContabilidade;
    }

    public void setInicioPrestContabilidade(Date inicioPrestContabilidade) {
        this.inicioPrestContabilidade = inicioPrestContabilidade;
    }

    @Column(name="FIM_PREST_SERV_CONTABILIDADE")
    @Temporal(value=TemporalType.DATE)
    public Date getFimPrestContabilidade() {
        return this.fimPrestContabilidade;
    }

    public void setFimPrestContabilidade(Date fimPrestContabilidade) {
        this.fimPrestContabilidade = fimPrestContabilidade;
    }

    @JoinColumn(name="ID_PESSOA_INFORMATICA", foreignKey=@ForeignKey(name="FK_GERACAO_ARQUIVO_MANAD_INFORM"))
    @ManyToOne(fetch=FetchType.LAZY)
    public Pessoa getPessoaInformatica() {
        return this.pessoaInformatica;
    }

    public void setPessoaInformatica(Pessoa pessoaInformatica) {
        this.pessoaInformatica = pessoaInformatica;
    }

    @Column(name="CPF_TECNICO_INFORMATICA", length=20)
    public String getCpfTecnicoInformatica() {
        return this.cpfTecnicoInformatica;
    }

    public void setCpfTecnicoInformatica(String cpfTecnicoInformatica) {
        this.cpfTecnicoInformatica = cpfTecnicoInformatica;
    }

    @Column(name="CARGO_EMPRESA_INFORMATICA", length=50)
    public String getCargoEmpresaInformatica() {
        return this.cargoEmpresaInformatica;
    }

    public void setCargoEmpresaInformatica(String cargoEmpresaInformatica) {
        this.cargoEmpresaInformatica = cargoEmpresaInformatica;
    }

    @Column(name="INICIO_PREST_SERV_INFORMATICA")
    @Temporal(value=TemporalType.DATE)
    public Date getInicioPrestInformatica() {
        return this.inicioPrestInformatica;
    }

    public void setInicioPrestInformatica(Date inicioPrestInformatica) {
        this.inicioPrestInformatica = inicioPrestInformatica;
    }

    @Column(name="FIM_PREST_SERV_INFORMATICA")
    @Temporal(value=TemporalType.DATE)
    public Date getFimPrestInformatica() {
        return this.fimPrestInformatica;
    }

    public void setFimPrestInformatica(Date fimPrestInformatica) {
        this.fimPrestInformatica = fimPrestInformatica;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getIdentificador()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }
}

