/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.CentroEstoque;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.GradeCor;
import com.touchcomp.basementor.model.vo.ItemComunicadoProducao;
import com.touchcomp.basementor.model.vo.LoteFabricacao;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;

@Entity
@Table(name="GRADE_ITEM_COMUNIC_PROD")
public class GradeItemComunicadoProducao
implements InterfaceVO {
    private Long identificador;
    private Double quantidade;
    private Double quantidadeReferencia;
    private Double valorUnitario;
    private GradeCor gradeCor;
    private LoteFabricacao loteFabricacao;
    private ItemComunicadoProducao itemComunicadoProducao;
    private Date dataMovimentacao;
    private Empresa empresa;
    private CentroEstoque centroEstoque;

    public GradeItemComunicadoProducao() {
        this.setQuantidade(0.0);
        this.setQuantidadeReferencia(0.0);
        this.setValorUnitario(0.0);
        this.quantidade = 0.0;
        this.quantidadeReferencia = 0.0;
        this.valorUnitario = 0.0;
        this.dataMovimentacao = new Date();
    }

    public GradeItemComunicadoProducao(GradeCor g) {
        this.gradeCor = g;
        this.setQuantidade(0.0);
        this.setQuantidadeReferencia(0.0);
        this.setValorUnitario(0.0);
        this.dataMovimentacao = new Date();
    }

    @Id
    @Column(nullable=false, name="ID_GRADE_ITEM_COMUNIC_PROD")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_GRADE_ITEM_COMUNIC_PROD")
    public Long getIdentificador() {
        return this.identificador;
    }

    @Column(nullable=false, name="QUANTIDADE", precision=15, scale=6)
    public Double getQuantidade() {
        return this.quantidade;
    }

    @Column(nullable=false, name="VALOR_UNITARIO", precision=15, scale=6)
    public Double getValorUnitario() {
        return this.valorUnitario;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(nullable=false, name="ID_GRADE_COR", foreignKey=@ForeignKey(name="FK_GRADE_ITEM_COMUNIC_PROD_GC"))
    public GradeCor getGradeCor() {
        return this.gradeCor;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @Cascade(value={CascadeType.MERGE, CascadeType.SAVE_UPDATE})
    @JoinColumn(nullable=false, name="ID_LOTE_FABRICACAO", foreignKey=@ForeignKey(name="FK_GRADE_ITEM_COMUNIC_PROD_LT"))
    public LoteFabricacao getLoteFabricacao() {
        return this.loteFabricacao;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(nullable=false, name="ID_ITEM_COMUNICADO_PRODUCAO", foreignKey=@ForeignKey(name="FK_GRADE_ITEM_COMUNIC_PROD_IT_C"))
    public ItemComunicadoProducao getItemComunicadoProducao() {
        return this.itemComunicadoProducao;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    public void setQuantidade(Double Quantidade) {
        this.quantidade = Quantidade;
    }

    public void setValorUnitario(Double valorUnitario) {
        this.valorUnitario = valorUnitario;
    }

    public void setGradeCor(GradeCor gradeCor) {
        this.gradeCor = gradeCor;
    }

    public void setLoteFabricacao(LoteFabricacao loteFabricacao) {
        this.loteFabricacao = loteFabricacao;
    }

    public void setItemComunicadoProducao(ItemComunicadoProducao itemComunicadoProducao) {
        this.itemComunicadoProducao = itemComunicadoProducao;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return "";
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @Column(name="DATA_MOVIMENTACAO")
    @Temporal(value=TemporalType.DATE)
    public Date getDataMovimentacao() {
        return this.dataMovimentacao;
    }

    public void setDataMovimentacao(Date dataMovimentacao) {
        this.dataMovimentacao = dataMovimentacao;
    }

    @Column(name="QUANTIDADE_REFERENCIA", precision=15, scale=6)
    public Double getQuantidadeReferencia() {
        return this.quantidadeReferencia;
    }

    public void setQuantidadeReferencia(Double quantidadeReferencia) {
        this.quantidadeReferencia = quantidadeReferencia;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_GRADE_ITEM_COMUNIC_PROD_EMP"))
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_CENTRO_ESTOQUE", foreignKey=@ForeignKey(name="FK_GRADE_ITEM_COMUNIC_PROD_CE"), updatable=false)
    public CentroEstoque getCentroEstoque() {
        return this.centroEstoque;
    }

    public void setCentroEstoque(CentroEstoque centroEstoque) {
        this.centroEstoque = centroEstoque;
    }
}

