/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.CentroEstoque;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.GradeCor;
import com.touchcomp.basementor.model.vo.LoteFabricacao;
import com.touchcomp.basementor.model.vo.TicketFiscal;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;

@Entity
@Table(name="GRADE_ITEM_TICKET_FISCAL")
public class GradeItemTicketFiscal
implements InterfaceVO {
    private Long Identificador;
    private GradeCor gradeCor;
    private Double quantidade;
    private Double valorCusto;
    private LoteFabricacao loteFabricacao;
    private Short movimentacaoFisica;
    private TicketFiscal ticketFiscal;
    private Short provisao;
    private Date dataMovimentacao;
    private CentroEstoque centroEstoque;
    private Empresa empresa;

    public GradeItemTicketFiscal() {
        this.setQuantidade(0.0);
        this.quantidade = 0.0;
        this.valorCusto = 0.0;
        this.movimentacaoFisica = 0;
        this.provisao = 0;
    }

    public GradeItemTicketFiscal(GradeCor grade) {
        this();
        this.gradeCor = grade;
        this.setQuantidade(0.0);
    }

    @Id
    @Column(name="ID_GRADE_ITEM_TICKET_FISCAL")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_GRADE_ITEM_TICKET_FISCAL")
    public Long getIdentificador() {
        return this.Identificador;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_GRADE_COR", foreignKey=@ForeignKey(name="FK_GRADE_ITEM_TICKET_FISC_GCOR"))
    public GradeCor getGradeCor() {
        return this.gradeCor;
    }

    @Column(name="QUANTIDADE", precision=15, scale=6)
    public Double getQuantidade() {
        return this.quantidade;
    }

    @Column(nullable=false, name="VALOR_CUSTO", precision=15, scale=6)
    public Double getValorCusto() {
        return this.valorCusto;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @Cascade(value={CascadeType.SAVE_UPDATE, CascadeType.PERSIST, CascadeType.MERGE})
    @JoinColumn(name="ID_LOTE_FABRICACAO", foreignKey=@ForeignKey(name="FK_GRADE_ITEM_TICKET_FISCAL_LF"))
    public LoteFabricacao getLoteFabricacao() {
        return this.loteFabricacao;
    }

    @Column(name="MOVIMENTACAO_FISICA")
    public Short getMovimentacaoFisica() {
        return this.movimentacaoFisica;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_TICKET_FISCAL", foreignKey=@ForeignKey(name="FK_GRADE_ITEM_TICKET_FISC_TI_FI"))
    public TicketFiscal getTicketFiscal() {
        return this.ticketFiscal;
    }

    @Column(name="PROVISAO")
    public Short getProvisao() {
        return this.provisao;
    }

    public void setIdentificador(Long Identificador) {
        this.Identificador = Identificador;
    }

    public void setGradeCor(GradeCor gradeCor) {
        this.gradeCor = gradeCor;
    }

    public void setQuantidade(Double quantidade) {
        this.quantidade = quantidade;
    }

    public void setValorCusto(Double valorCusto) {
        this.valorCusto = valorCusto;
    }

    public void setLoteFabricacao(LoteFabricacao loteFabricacao) {
        this.loteFabricacao = loteFabricacao;
    }

    public void setMovimentacaoFisica(Short movimentacaoFisica) {
        this.movimentacaoFisica = movimentacaoFisica;
    }

    public void setTicketFiscal(TicketFiscal ticketFiscal) {
        this.ticketFiscal = ticketFiscal;
    }

    public void setProvisao(Short provisao) {
        this.provisao = provisao;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getGradeCor() != null ? this.getGradeCor().getCor() : this.getGradeCor()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_MOVIMENTACAO")
    public Date getDataMovimentacao() {
        return this.dataMovimentacao;
    }

    public void setDataMovimentacao(Date dataMovimentacao) {
        this.dataMovimentacao = dataMovimentacao;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_CENTRO_ESTOQUE", foreignKey=@ForeignKey(name="FK_GRADE_ITEM_TICKET_FISCAL_CE"))
    public CentroEstoque getCentroEstoque() {
        return this.centroEstoque;
    }

    public void setCentroEstoque(CentroEstoque centroEstoque) {
        this.centroEstoque = centroEstoque;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_GRADE_ITEM_TICKET_FISCAL_EM"))
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }
}

