/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.LoteGuiaGNRE;
import com.touchcomp.basementor.model.vo.ModeloGNREUF;
import com.touchcomp.basementor.model.vo.NotaFiscalPropria;
import com.touchcomp.basementor.model.vo.Pessoa;
import com.touchcomp.basementor.model.vo.Titulo;
import com.touchcomp.basementor.model.vo.UnidadeFederativa;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.Date;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Version;

@Entity
@Table(name="GUIA_GNRE")
public class GuiaGNRE
implements InterfaceVO {
    private Long identificador;
    private ModeloGNREUF modeloGNREUF;
    private Double valor = 0.0;
    private Double juros = 0.0;
    private Double multa = 0.0;
    private Double atMonetaria = 0.0;
    private Double valorTotal = 0.0;
    private NotaFiscalPropria notaFiscal;
    private Pessoa contribuinte;
    private Double percentualST = 0.0;
    private Date dataCadastro;
    private Timestamp dataAtualizacao;
    private Empresa empresa;
    private String observacao;
    private Date dataVencimento;
    private Short tipoST = 0;
    private Titulo tituloPagamento;
    private Titulo tituloRecebimento;
    private UnidadeFederativa unidadeFederativa;
    private Short gerarGuia = 0;
    private String origemValores;
    private LoteGuiaGNRE loteGuiaGNRE;

    @Id
    @Column(nullable=false, unique=true, name="ID_GUIA_GNRE")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_GUIA_GNRE")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_MODELO_GNRE_UF", foreignKey=@ForeignKey(name="FK_GUIA_GNRE_MODELO_GNRE"))
    public ModeloGNREUF getModeloGNREUF() {
        return this.modeloGNREUF;
    }

    public void setModeloGNREUF(ModeloGNREUF aliquotaSTModGNRE) {
        this.modeloGNREUF = aliquotaSTModGNRE;
    }

    @Column(name="VALOR", precision=15, scale=2)
    public Double getValor() {
        return this.valor;
    }

    public void setValor(Double valor) {
        this.valor = valor;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_NOTA_FISCAL", foreignKey=@ForeignKey(name="FK_GUIA_GNRE_NOTA_FISCAL"))
    public NotaFiscalPropria getNotaFiscal() {
        return this.notaFiscal;
    }

    public void setNotaFiscal(NotaFiscalPropria notaFiscal) {
        this.notaFiscal = notaFiscal;
    }

    @Column(name="PERCENTUAL_ST", precision=15, scale=2)
    public Double getPercentualST() {
        return this.percentualST;
    }

    public void setPercentualST(Double percentualST) {
        this.percentualST = percentualST;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0} - {1}", (Object[])new Object[]{this.getIdentificador(), this.getObservacao()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @Column(name="DATA_CADASTRO")
    @Temporal(value=TemporalType.DATE)
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @Column(name="DATA_ATUALIZACAO")
    @Version
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_GUIA_GNRE_EMPRESA"))
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    @Column(name="DATA_VENCIMENTO")
    @Temporal(value=TemporalType.DATE)
    public Date getDataVencimento() {
        return this.dataVencimento;
    }

    public void setDataVencimento(Date dataVencimento) {
        this.dataVencimento = dataVencimento;
    }

    @Column(name="OBSERVACAO", length=200)
    public String getObservacao() {
        return this.observacao;
    }

    public void setObservacao(String observacao) {
        this.observacao = observacao;
    }

    @Column(name="TIPO_ST")
    public Short getTipoST() {
        return this.tipoST;
    }

    public void setTipoST(Short tipoST) {
        this.tipoST = tipoST;
    }

    @Column(name="JUROS", precision=15, scale=2)
    public Double getJuros() {
        return this.juros;
    }

    public void setJuros(Double juros) {
        this.juros = juros;
    }

    @Column(name="MULTA", precision=15, scale=2)
    public Double getMulta() {
        return this.multa;
    }

    public void setMulta(Double multa) {
        this.multa = multa;
    }

    @Column(name="AT_MONETARIA", precision=15, scale=2)
    public Double getAtMonetaria() {
        return this.atMonetaria;
    }

    public void setAtMonetaria(Double atMonetaria) {
        this.atMonetaria = atMonetaria;
    }

    @Column(nullable=false, name="VALOR_TOTAL", precision=15, scale=2)
    public Double getValorTotal() {
        return this.valorTotal;
    }

    public void setValorTotal(Double valorTotal) {
        this.valorTotal = valorTotal;
    }

    @ManyToOne(cascade={CascadeType.ALL}, fetch=FetchType.LAZY)
    @JoinColumn(name="ID_TITULO_PAGAMENTO", foreignKey=@ForeignKey(name="FK_GUIA_GNRE_TITULO_PAG"))
    public Titulo getTituloPagamento() {
        return this.tituloPagamento;
    }

    public void setTituloPagamento(Titulo tituloPagamento) {
        this.tituloPagamento = tituloPagamento;
    }

    @ManyToOne(cascade={CascadeType.ALL}, fetch=FetchType.LAZY)
    @JoinColumn(name="ID_TITULO_RECEBIMENTO", foreignKey=@ForeignKey(name="FK_GUIA_GNRE_TITUO_REC"))
    public Titulo getTituloRecebimento() {
        return this.tituloRecebimento;
    }

    public void setTituloRecebimento(Titulo tituloRecebimento) {
        this.tituloRecebimento = tituloRecebimento;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_CONTRIBUINTE", foreignKey=@ForeignKey(name="FK_GUIA_GNRE_PESSOA"))
    public Pessoa getContribuinte() {
        return this.contribuinte;
    }

    public void setContribuinte(Pessoa contribuinte) {
        this.contribuinte = contribuinte;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_UNIDADE_FEDERATIVA", foreignKey=@ForeignKey(name="FK_GUIA_GNRE_UF"))
    public UnidadeFederativa getUnidadeFederativa() {
        return this.unidadeFederativa;
    }

    public void setUnidadeFederativa(UnidadeFederativa unidadeFederativa) {
        this.unidadeFederativa = unidadeFederativa;
    }

    @Column(name="GERAR_GUIA")
    public Short getGerarGuia() {
        return this.gerarGuia;
    }

    public void setGerarGuia(Short gerarGuia) {
        this.gerarGuia = gerarGuia;
    }

    @Column(name="ORIGEM_VALORES", length=8000)
    public String getOrigemValores() {
        return this.origemValores;
    }

    public void setOrigemValores(String origemValores) {
        this.origemValores = origemValores;
    }

    @JoinColumn(name="ID_LOTE_GUIA_GNRE", foreignKey=@ForeignKey(name="FK_GUIA_GNRE_LOTE_GUIA_GNRE"))
    @ManyToOne(fetch=FetchType.LAZY)
    public LoteGuiaGNRE getLoteGuiaGNRE() {
        return this.loteGuiaGNRE;
    }

    public void setLoteGuiaGNRE(LoteGuiaGNRE loteGuiaGNRE) {
        this.loteGuiaGNRE = loteGuiaGNRE;
    }
}

