/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.ObjectObsDinamica;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Version;

@Entity
@Table(name="HISTORICO_PADRAO")
public class HistoricoPadrao
implements InterfaceVO {
    private Long identificador;
    private String descricao;
    private Date dataCadastro;
    private Empresa empresa;
    private Timestamp dataAtualizacao;
    private ObjectObsDinamica observacaoDinamica;

    public HistoricoPadrao() {
    }

    public HistoricoPadrao(Long identificador, String descricao) {
        this.identificador = identificador;
        this.descricao = descricao;
    }

    @Id
    @Column(name="ID_HISTORICO_PADRAO")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_HISTORICO_PADRAO")
    public Long getIdentificador() {
        return this.identificador;
    }

    @Column(name="DESCRICAO", length=150)
    public String getDescricao() {
        return this.descricao;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_EMP", foreignKey=@ForeignKey(name="FK_HISTORICO_PADRAO_EMPRESA"))
    public Empresa getEmpresa() {
        return this.empresa;
    }

    @Column(name="DATA_CADASTRO")
    @Temporal(value=TemporalType.DATE)
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    public void setIdentificador(Long idHistoricoPadrao) {
        this.identificador = idHistoricoPadrao;
    }

    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getDescricao()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @Version
    @Column(name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_OBSERVACAO_DINAMICA", foreignKey=@ForeignKey(name="FK_HISTORICO_PADRAO_OBS_DIN"))
    public ObjectObsDinamica getObservacaoDinamica() {
        return this.observacaoDinamica;
    }

    public void setObservacaoDinamica(ObjectObsDinamica observacaoDinamica) {
        this.observacaoDinamica = observacaoDinamica;
    }
}

