/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.vo.IntegracaoRequisicao;
import com.touchcomp.basementor.model.vo.LancamentoCentroCusto;
import com.touchcomp.basementor.model.vo.LancamentoCtbGerencial;
import com.touchcomp.basementor.model.vo.LoteContabil;
import com.touchcomp.basementor.model.vo.Requisicao;
import com.touchcomp.basementortools.tools.date.ToolDate;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.hibernate.annotations.Cascade;

@Entity
@Table(name="INTEGRACAO_REQUISICAO_ITEM")
public class IntegracaoRequisicaoItem {
    private Long identificador;
    private Date dataLote;
    private LoteContabil loteContabil;
    private IntegracaoRequisicao integracaoRequisicao;
    private List<LancamentoCentroCusto> lancamentosCentroCusto = new LinkedList<LancamentoCentroCusto>();
    private List<LancamentoCtbGerencial> lancamentosCtbGerencial = new LinkedList<LancamentoCtbGerencial>();
    private List<Requisicao> requisicoes = new LinkedList<Requisicao>();

    @Id
    @Column(name="ID_INTEGRACAO_REQUISICAO_ITEM")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_INTEGRACAO_REQUISICAO_ITEM")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @Column(name="DATA_LOTE")
    @Temporal(value=TemporalType.DATE)
    public Date getDataLote() {
        return this.dataLote;
    }

    public void setDataLote(Date dataLote) {
        this.dataLote = dataLote;
    }

    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @JoinColumn(name="ID_LOTE_CONTABIL", foreignKey=@ForeignKey(name="FK_INTEGRACAO_REQ_ITEM_LT_CONTA"))
    public LoteContabil getLoteContabil() {
        return this.loteContabil;
    }

    public void setLoteContabil(LoteContabil loteContabil) {
        this.loteContabil = loteContabil;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_INTEGRACAO_REQUISICAO", foreignKey=@ForeignKey(name="FK_INTEGRACAO_REQ_ITEM_INT_REQ"))
    public IntegracaoRequisicao getIntegracaoRequisicao() {
        return this.integracaoRequisicao;
    }

    public void setIntegracaoRequisicao(IntegracaoRequisicao integracaoRequisicao) {
        this.integracaoRequisicao = integracaoRequisicao;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}:{1}", (Object[])new Object[]{ToolDate.dateToStr((Date)this.dataLote), this.getLoteContabil() != null ? this.getLoteContabil().getNumeroLote() : ""});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @OneToMany
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    @JoinTable(name="INTEG_REQ_ITEM_L_CEN_CUST", joinColumns={@JoinColumn(name="ID_INTEGRACAO_REQUISICAO_ITEM")}, inverseJoinColumns={@JoinColumn(name="ID_LANCAMENTO_CEN_CUSTO")})
    public List<LancamentoCentroCusto> getLancamentosCentroCusto() {
        return this.lancamentosCentroCusto;
    }

    public void setLancamentosCentroCusto(List<LancamentoCentroCusto> lancamentosCentroCusto) {
        this.lancamentosCentroCusto = lancamentosCentroCusto;
    }

    @OneToMany
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    @JoinTable(name="INTEG_REQ_ITEM_L_CTB_GER", joinColumns={@JoinColumn(name="ID_INTEGRACAO_REQUISICAO_ITEM")}, inverseJoinColumns={@JoinColumn(name="ID_LANCAMENTO_GERENCIAL")})
    public List<LancamentoCtbGerencial> getLancamentosCtbGerencial() {
        return this.lancamentosCtbGerencial;
    }

    public void setLancamentosCtbGerencial(List<LancamentoCtbGerencial> lancamentosCtbGerencial) {
        this.lancamentosCtbGerencial = lancamentosCtbGerencial;
    }

    @OneToMany(cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    @JoinTable(name="INTEG_REQUISICAO_ITEM_REQ", joinColumns={@JoinColumn(name="ID_INTEGRACAO_REQUISICAO_ITEM")}, inverseJoinColumns={@JoinColumn(name="ID_REQUISICAO")})
    public List<Requisicao> getRequisicoes() {
        return this.requisicoes;
    }

    public void setRequisicoes(List<Requisicao> requisicoes) {
        this.requisicoes = requisicoes;
    }
}

