/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.AutConsumoAtivo;
import com.touchcomp.basementor.model.vo.CentroCusto;
import com.touchcomp.basementor.model.vo.CentroEstoque;
import com.touchcomp.basementor.model.vo.GradeItemAutConsumoAtivo;
import com.touchcomp.basementor.model.vo.NaturezaRequisicao;
import com.touchcomp.basementor.model.vo.Produto;
import com.touchcomp.basementor.model.vo.UnidadeFatFornecedor;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;

@Entity
@Table(name="ITEM_AUT_CONSUMO_ATIVO")
public class ItemAutConsumoAtivo
implements InterfaceVO {
    private Long identificador;
    private Short movInterno = 0;
    private CentroEstoque centroEstoque;
    private CentroCusto centroCusto;
    private UnidadeFatFornecedor unidadeFatFornecedor;
    private Produto produto;
    private NaturezaRequisicao naturezaRequisicao;
    private Double valorUnitario = 0.0;
    private Double valorDesconto = 0.0;
    private Double valorTotal = 0.0;
    private AutConsumoAtivo autConsumoAtivo;
    private List<GradeItemAutConsumoAtivo> gradeItemAutConsumoAtivo = new ArrayList<GradeItemAutConsumoAtivo>();

    @Id
    @Column(nullable=false, name="ID_ITEM_AUT_CONSUMO_ATIVO")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_ITEM_AUT_CONSUMO_ATIVO")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @Column(name="MOV_INTERNO")
    public Short getMovInterno() {
        return this.movInterno;
    }

    public void setMovInterno(Short movInterno) {
        this.movInterno = movInterno;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_CENTRO_ESTOQUE", foreignKey=@ForeignKey(name="FK_ITEM_AUT_CONS_ATIVO_CENT_EST"))
    public CentroEstoque getCentroEstoque() {
        return this.centroEstoque;
    }

    public void setCentroEstoque(CentroEstoque centroEstoque) {
        this.centroEstoque = centroEstoque;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_CENTRO_CUSTO", foreignKey=@ForeignKey(name="FK_ITEM_AUT_CONS_ATIVO_CENT_CUS"))
    public CentroCusto getCentroCusto() {
        return this.centroCusto;
    }

    public void setCentroCusto(CentroCusto centroCusto) {
        this.centroCusto = centroCusto;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_UNIDADE_FAT_FORNECEDOR", foreignKey=@ForeignKey(name="FK_ITEM_AUT_CONS_ATIVO_UNID_FOR"))
    public UnidadeFatFornecedor getUnidadeFatFornecedor() {
        return this.unidadeFatFornecedor;
    }

    public void setUnidadeFatFornecedor(UnidadeFatFornecedor unidadeFatFornecedor) {
        this.unidadeFatFornecedor = unidadeFatFornecedor;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_PRODUTO", foreignKey=@ForeignKey(name="FK_ITEM_AUT_CONS_ATIVO_PRODUTO"))
    public Produto getProduto() {
        return this.produto;
    }

    public void setProduto(Produto produto) {
        this.produto = produto;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_NATUREZA_REQUISICAO", foreignKey=@ForeignKey(name="FK_ITEM_AUT_CONS_ATIVO_NAT_REQ"))
    public NaturezaRequisicao getNaturezaRequisicao() {
        return this.naturezaRequisicao;
    }

    public void setNaturezaRequisicao(NaturezaRequisicao naturezaRequisicao) {
        this.naturezaRequisicao = naturezaRequisicao;
    }

    @Column(nullable=false, name="VALOR_UNITARIO", precision=15, scale=6)
    public Double getValorUnitario() {
        return this.valorUnitario;
    }

    public void setValorUnitario(Double valorUnitario) {
        this.valorUnitario = valorUnitario;
    }

    @Column(name="VALOR_DESCONTO", precision=15, scale=6)
    public Double getValorDesconto() {
        return this.valorDesconto;
    }

    public void setValorDesconto(Double valorDesconto) {
        this.valorDesconto = valorDesconto;
    }

    @Column(nullable=false, name="VALOR_TOTAL", precision=15, scale=6)
    public Double getValorTotal() {
        return this.valorTotal;
    }

    public void setValorTotal(Double valorTotal) {
        this.valorTotal = valorTotal;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_AUT_CONSUMO_ATIVO", foreignKey=@ForeignKey(name="FK_ITEM_AUT_CONS_ATIVO_AUT_C_A"))
    public AutConsumoAtivo getAutConsumoAtivo() {
        return this.autConsumoAtivo;
    }

    public void setAutConsumoAtivo(AutConsumoAtivo autConsumoAtivo) {
        this.autConsumoAtivo = autConsumoAtivo;
    }

    @OneToMany(mappedBy="itemAutConsumoAtivo", fetch=FetchType.LAZY)
    @Cascade(value={CascadeType.DELETE_ORPHAN, CascadeType.ALL})
    public List<GradeItemAutConsumoAtivo> getGradeItemAutConsumoAtivo() {
        return this.gradeItemAutConsumoAtivo;
    }

    public void setGradeItemAutConsumoAtivo(List<GradeItemAutConsumoAtivo> gradeItemAutConsumoAtivo) {
        this.gradeItemAutConsumoAtivo = gradeItemAutConsumoAtivo;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0} - {1}", (Object[])new Object[]{this.autConsumoAtivo, this.produto});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }
}

