/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.constants.enums.centroestoque.EnumConstCentroEstTipoPropTerc;
import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.ConversorExpressoesDinamico;
import com.touchcomp.basementor.model.vo.GradeCor;
import com.touchcomp.basementor.model.vo.GradeFormulaProduto;
import com.touchcomp.basementor.model.vo.ItemGradeFormulaProdutoSubstituto;
import com.touchcomp.basementor.model.vo.NaturezaRequisicao;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Version;
import org.hibernate.annotations.Cascade;

@Entity
@Table(name="ITEM_GRADE_FORMULA_PRODUTO")
public class ItemGradeFormulaProduto
implements InterfaceVO {
    private Long identificador;
    private GradeFormulaProduto gradeFormulaProduto;
    private GradeCor gradeCor;
    private Double quantidade = 0.0;
    private Double percAdicional = 0.0;
    private Short naoRequisitarAutomatico = 0;
    private NaturezaRequisicao naturezaRequisicao;
    private GradeCor gradeCorSubstituto;
    private List<ItemGradeFormulaProdutoSubstituto> itensSubstitutos;
    private String codReferencia;
    private Double qtdReferencia = 0.0;
    private String observacao;
    private Short indice = 0;
    private Double comprimento = 0.0;
    private Double altura = 0.0;
    private Double largura = 0.0;
    private Double volume = 0.0;
    private Short tipoEstoque = EnumConstCentroEstTipoPropTerc.TIPO_CENTRO_ESTOQUE_PROPRIO.getValue();
    private Date dataAtualizacao;
    private Short naoUtilizarPesagem = 0;
    private ConversorExpressoesDinamico conversorExpressoesDinamico;

    public ItemGradeFormulaProduto() {
        this.itensSubstitutos = new ArrayList<ItemGradeFormulaProdutoSubstituto>();
    }

    @Id
    @Column(name="ID_ITEM_GRADE_FORMULA_PRODUTO")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_ITEM_GRADE_FORMULA_PRODUTO")
    public Long getIdentificador() {
        return this.identificador;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_GRADE_COR", foreignKey=@ForeignKey(name="FK_ITEM_GRADE_FORMULA_PROD_GC"))
    public GradeCor getGradeCor() {
        return this.gradeCor;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_GRADE_FORMULA_PRODUTO", foreignKey=@ForeignKey(name="FK_ITEM_GRADE_FORMULA_PROD_GF_P"))
    public GradeFormulaProduto getGradeFormulaProduto() {
        return this.gradeFormulaProduto;
    }

    @Column(nullable=true, name="QUANTIDADE", precision=15, scale=4)
    public Double getQuantidade() {
        return this.quantidade;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    public void setGradeCor(GradeCor gradeCor) {
        this.gradeCor = gradeCor;
    }

    public void setGradeFormulaProduto(GradeFormulaProduto gradeFormulaProduto) {
        this.gradeFormulaProduto = gradeFormulaProduto;
    }

    public void setQuantidade(Double quantidade) {
        this.quantidade = quantidade;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getGradeCor()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @Column(name="NAO_REQUISITAR_AUTOMATICO")
    public Short getNaoRequisitarAutomatico() {
        return this.naoRequisitarAutomatico;
    }

    public void setNaoRequisitarAutomatico(Short naoRequisitarAutomatico) {
        this.naoRequisitarAutomatico = naoRequisitarAutomatico;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_NATUREZA_REQUISICAO", foreignKey=@ForeignKey(name="FK_ITEM_GRADE_FORMULA_PROD_N_R"))
    public NaturezaRequisicao getNaturezaRequisicao() {
        return this.naturezaRequisicao;
    }

    public void setNaturezaRequisicao(NaturezaRequisicao naturezaRequisicao) {
        this.naturezaRequisicao = naturezaRequisicao;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_GRADE_COR_SUBSTITUTO", foreignKey=@ForeignKey(name="FK_ITEM_GRADE_FORMULA_PROD_GC_S"))
    public GradeCor getGradeCorSubstituto() {
        return this.gradeCorSubstituto;
    }

    public void setGradeCorSubstituto(GradeCor gradeCorSubstituto) {
        this.gradeCorSubstituto = gradeCorSubstituto;
    }

    @Column(name="PERC_ADICIONAL", precision=15, scale=6)
    public Double getPercAdicional() {
        return this.percAdicional;
    }

    public void setPercAdicional(Double percAdicional) {
        this.percAdicional = percAdicional;
    }

    @Column(name="COD_REFERENCIA", length=60)
    public String getCodReferencia() {
        return this.codReferencia;
    }

    public void setCodReferencia(String codReferencia) {
        this.codReferencia = codReferencia;
    }

    @Column(name="QTD_REFERENCIA", precision=15, scale=6)
    public Double getQtdReferencia() {
        return this.qtdReferencia;
    }

    public void setQtdReferencia(Double qtdReferencia) {
        this.qtdReferencia = qtdReferencia;
    }

    @Column(name="OBSERVACAO", length=500)
    public String getObservacao() {
        return this.observacao;
    }

    public void setObservacao(String observacao) {
        this.observacao = observacao;
    }

    @Column(name="INDICE")
    public Short getIndice() {
        return this.indice;
    }

    public void setIndice(Short indice) {
        this.indice = indice;
    }

    @Column(name="COMPRIMENTO", precision=15, scale=4)
    public Double getComprimento() {
        return this.comprimento;
    }

    public void setComprimento(Double comprimento) {
        this.comprimento = comprimento;
    }

    @Column(name="ALTURA", precision=15, scale=4)
    public Double getAltura() {
        return this.altura;
    }

    public void setAltura(Double altura) {
        this.altura = altura;
    }

    @Column(name="LARGURA", precision=15, scale=4)
    public Double getLargura() {
        return this.largura;
    }

    public void setLargura(Double largura) {
        this.largura = largura;
    }

    @Column(name="VOLUME", precision=15, scale=4)
    public Double getVolume() {
        return this.volume;
    }

    public void setVolume(Double volume) {
        this.volume = volume;
    }

    @Column(name="TIPO_ESTOQUE")
    public Short getTipoEstoque() {
        return this.tipoEstoque;
    }

    public void setTipoEstoque(Short tipoEstoque) {
        this.tipoEstoque = tipoEstoque;
    }

    @Version
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="data_atualizacao")
    public Date getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Date dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @Column(name="NAO_UTILIZAR_PESAGEM")
    public Short getNaoUtilizarPesagem() {
        return this.naoUtilizarPesagem;
    }

    public void setNaoUtilizarPesagem(Short naoUtilizarPesagem) {
        this.naoUtilizarPesagem = naoUtilizarPesagem;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_CONVERSOR", foreignKey=@ForeignKey(name="FK_ITEM_GRADE_FORMULA_CONV_EXP"))
    public ConversorExpressoesDinamico getConversorExpressoesDinamico() {
        return this.conversorExpressoesDinamico;
    }

    public void setConversorExpressoesDinamico(ConversorExpressoesDinamico conversorExpressoesDinamico) {
        this.conversorExpressoesDinamico = conversorExpressoesDinamico;
    }

    @OneToMany(mappedBy="itemGradeFormulaProduto", fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN, org.hibernate.annotations.CascadeType.ALL})
    public List<ItemGradeFormulaProdutoSubstituto> getItensSubstitutos() {
        return this.itensSubstitutos;
    }

    public void setItensSubstitutos(List<ItemGradeFormulaProdutoSubstituto> itensSubstitutos) {
        this.itensSubstitutos = itensSubstitutos;
    }
}

